"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUrlIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpUrlIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param url the URL to proxy to
     * @param props properties to configure the integration
     */
    constructor(id, url, props = {}) {
        super(id);
        this.url = url;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", "");
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpUrlIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpUrlIntegration);
            }
            throw error;
        }
    }
    bind(_options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            method: this.props.method ?? aws_apigatewayv2_alpha_1.HttpMethod.ANY,
            payloadFormatVersion: aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0,
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.url,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpUrlIntegration = HttpUrlIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpUrlIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpUrlIntegration", version: "2.112.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC1wcm94eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAtcHJveHkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsNEVBUXlDO0FBb0J6Qzs7R0FFRztBQUNILE1BQWEsa0JBQW1CLFNBQVEsNkNBQW9CO0lBQzFEOzs7O09BSUc7SUFDSCxZQUFZLEVBQVUsRUFBbUIsR0FBVyxFQUFtQixRQUFpQyxFQUFFO1FBQ3hHLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUQ2QixRQUFHLEdBQUgsR0FBRyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQThCOzs7Ozs7OytDQU4vRixrQkFBa0I7Ozs7S0FRNUI7SUFFTSxJQUFJLENBQUMsUUFBeUM7Ozs7Ozs7Ozs7UUFDbkQsT0FBTztZQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sSUFBSSxtQ0FBVSxDQUFDLEdBQUc7WUFDM0Msb0JBQW9CLEVBQUUsNkNBQW9CLENBQUMsV0FBVztZQUN0RCxJQUFJLEVBQUUsNENBQW1CLENBQUMsVUFBVTtZQUNwQyxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixnQkFBZ0IsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQjtTQUM5QyxDQUFDO0tBQ0g7O0FBbEJILGdEQW1CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIEh0dHBJbnRlZ3JhdGlvblR5cGUsXG4gIEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMsXG4gIEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnLFxuICBIdHRwTWV0aG9kLFxuICBIdHRwUm91dGVJbnRlZ3JhdGlvbixcbiAgUGFyYW1ldGVyTWFwcGluZyxcbiAgUGF5bG9hZEZvcm1hdFZlcnNpb24sXG59IGZyb20gJ0Bhd3MtY2RrL2F3cy1hcGlnYXRld2F5djItYWxwaGEnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgdG8gaW5pdGlhbGl6ZSBhIG5ldyBgSHR0cFByb3h5SW50ZWdyYXRpb25gLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBVcmxJbnRlZ3JhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBIVFRQIG1ldGhvZCB0aGF0IG11c3QgYmUgdXNlZCB0byBpbnZva2UgdGhlIHVuZGVybHlpbmcgSFRUUCBwcm94eS5cbiAgICogQGRlZmF1bHQgSHR0cE1ldGhvZC5BTllcbiAgICovXG4gIHJlYWRvbmx5IG1ldGhvZD86IEh0dHBNZXRob2Q7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyBob3cgdG8gdHJhbnNmb3JtIEhUVFAgcmVxdWVzdHMgYmVmb3JlIHNlbmRpbmcgdGhlbSB0byB0aGUgYmFja2VuZFxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9hcGlnYXRld2F5L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9odHRwLWFwaS1wYXJhbWV0ZXItbWFwcGluZy5odG1sXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZCByZXF1ZXN0cyBhcmUgc2VudCB0byB0aGUgYmFja2VuZCB1bm1vZGlmaWVkXG4gICAqL1xuICByZWFkb25seSBwYXJhbWV0ZXJNYXBwaW5nPzogUGFyYW1ldGVyTWFwcGluZztcbn1cblxuLyoqXG4gKiBUaGUgSFRUUCBQcm94eSBpbnRlZ3JhdGlvbiByZXNvdXJjZSBmb3IgSFRUUCBBUElcbiAqL1xuZXhwb3J0IGNsYXNzIEh0dHBVcmxJbnRlZ3JhdGlvbiBleHRlbmRzIEh0dHBSb3V0ZUludGVncmF0aW9uIHtcbiAgLyoqXG4gICAqIEBwYXJhbSBpZCBpZCBvZiB0aGUgdW5kZXJseWluZyBpbnRlZ3JhdGlvbiBjb25zdHJ1Y3RcbiAgICogQHBhcmFtIHVybCB0aGUgVVJMIHRvIHByb3h5IHRvXG4gICAqIEBwYXJhbSBwcm9wcyBwcm9wZXJ0aWVzIHRvIGNvbmZpZ3VyZSB0aGUgaW50ZWdyYXRpb25cbiAgICovXG4gIGNvbnN0cnVjdG9yKGlkOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgdXJsOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEh0dHBVcmxJbnRlZ3JhdGlvblByb3BzID0ge30pIHtcbiAgICBzdXBlcihpZCk7XG4gIH1cblxuICBwdWJsaWMgYmluZChfb3B0aW9uczogSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyk6IEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgbWV0aG9kOiB0aGlzLnByb3BzLm1ldGhvZCA/PyBIdHRwTWV0aG9kLkFOWSxcbiAgICAgIHBheWxvYWRGb3JtYXRWZXJzaW9uOiBQYXlsb2FkRm9ybWF0VmVyc2lvbi5WRVJTSU9OXzFfMCwgLy8gMS4wIGlzIHJlcXVpcmVkIGFuZCBpcyB0aGUgb25seSBzdXBwb3J0ZWQgZm9ybWF0XG4gICAgICB0eXBlOiBIdHRwSW50ZWdyYXRpb25UeXBlLkhUVFBfUFJPWFksXG4gICAgICB1cmk6IHRoaXMudXJsLFxuICAgICAgcGFyYW1ldGVyTWFwcGluZzogdGhpcy5wcm9wcy5wYXJhbWV0ZXJNYXBwaW5nLFxuICAgIH07XG4gIH1cbn0iXX0=