"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class HttpLambdaIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda handler to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, handler, props = {}) {
        super(id);
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration", "");
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpLambdaIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpLambdaIntegration);
            }
            throw error;
        }
        this._id = id;
    }
    completeBind(options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration#completeBind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.completeBind);
            }
            throw error;
        }
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${route.path ?? ''}`, // empty string in the case of the catch-all route $default
            }),
        });
    }
    bind(_options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.AWS_PROXY,
            uri: this.handler.functionArn,
            payloadFormatVersion: this.props.payloadFormatVersion ?? aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpLambdaIntegration = HttpLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration", version: "2.112.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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