"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpServiceDiscoveryIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("./private/integration");
/**
 * The Service Discovery integration resource for HTTP API
 */
class HttpServiceDiscoveryIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param service the service discovery resource to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, service, props = {}) {
        super(id);
        this.service = service;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpServiceDiscoveryIntegration", "");
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpServiceDiscoveryIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpServiceDiscoveryIntegration);
            }
            throw error;
        }
    }
    bind(_options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpServiceDiscoveryIntegration#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (!this.props.vpcLink) {
            throw new Error('The vpcLink property is mandatory');
        }
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: this.props.vpcLink.vpcLinkId,
            uri: this.service.serviceArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpServiceDiscoveryIntegration = HttpServiceDiscoveryIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpServiceDiscoveryIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpServiceDiscoveryIntegration", version: "2.112.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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