"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
/**
 * Lambda WebSocket Integration
 */
class WebSocketLambdaIntegration extends aws_apigatewayv2_alpha_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda function handler
     * @param props properties to configure the integration
     */
    constructor(id, handler) {
        super(id);
        this.handler = handler;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketLambdaIntegration", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketLambdaIntegration);
            }
            throw error;
        }
        this._id = id;
    }
    bind(options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketLambdaIntegration#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.webSocketApi.apiId,
                resourceName: `*${route.routeKey}`,
            }),
        });
        const integrationUri = core_1.Stack.of(route).formatArn({
            service: 'apigateway',
            account: 'lambda',
            resource: 'path/2015-03-31/functions',
            resourceName: `${this.handler.functionArn}/invocations`,
        });
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.AWS_PROXY,
            uri: integrationUri,
        };
    }
}
exports.WebSocketLambdaIntegration = WebSocketLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketLambdaIntegration", version: "2.112.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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