"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketMockIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * Mock WebSocket Integration
 */
class WebSocketMockIntegration extends aws_apigatewayv2_alpha_1.WebSocketRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     */
    constructor(id) {
        super(id);
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketMockIntegration", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketMockIntegration);
            }
            throw error;
        }
    }
    bind(options) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketMockIntegration#bind", "");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        options;
        return {
            type: aws_apigatewayv2_alpha_1.WebSocketIntegrationType.MOCK,
            uri: '',
        };
    }
}
exports.WebSocketMockIntegration = WebSocketMockIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketMockIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.WebSocketMockIntegration", version: "2.112.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9jay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1vY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsNEVBS3lDO0FBRXpDOztHQUVHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSxrREFBeUI7SUFFckU7O09BRUc7SUFDSCxZQUFZLEVBQVU7UUFDcEIsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7K0NBTkQsd0JBQXdCOzs7O0tBT2xDO0lBRUQsSUFBSSxDQUFDLE9BQTZDOzs7Ozs7Ozs7O1FBQ2hELE9BQU8sQ0FBQztRQUNSLE9BQU87WUFDTCxJQUFJLEVBQUUsaURBQXdCLENBQUMsSUFBSTtZQUNuQyxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUM7S0FDSDs7QUFmSCw0REFnQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBXZWJTb2NrZXRSb3V0ZUludGVncmF0aW9uLFxuICBXZWJTb2NrZXRJbnRlZ3JhdGlvblR5cGUsXG4gIFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb25Db25maWcsXG4gIFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyxcbn0gZnJvbSAnQGF3cy1jZGsvYXdzLWFwaWdhdGV3YXl2Mi1hbHBoYSc7XG5cbi8qKlxuICogTW9jayBXZWJTb2NrZXQgSW50ZWdyYXRpb25cbiAqL1xuZXhwb3J0IGNsYXNzIFdlYlNvY2tldE1vY2tJbnRlZ3JhdGlvbiBleHRlbmRzIFdlYlNvY2tldFJvdXRlSW50ZWdyYXRpb24ge1xuXG4gIC8qKlxuICAgKiBAcGFyYW0gaWQgaWQgb2YgdGhlIHVuZGVybHlpbmcgaW50ZWdyYXRpb24gY29uc3RydWN0XG4gICAqL1xuICBjb25zdHJ1Y3RvcihpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoaWQpO1xuICB9XG5cbiAgYmluZChvcHRpb25zOiBXZWJTb2NrZXRSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMpOiBXZWJTb2NrZXRSb3V0ZUludGVncmF0aW9uQ29uZmlnIHtcbiAgICBvcHRpb25zO1xuICAgIHJldHVybiB7XG4gICAgICB0eXBlOiBXZWJTb2NrZXRJbnRlZ3JhdGlvblR5cGUuTU9DSyxcbiAgICAgIHVyaTogJycsXG4gICAgfTtcbiAgfVxufVxuIl19