"""RemoteManager class.
"""
import logging

from ....utils.events import Event
from ...layerlist import LayerList
from ._commands import RemoteCommands
from ._messages import RemoteMessages

LOGGER = logging.getLogger("napari.monitor")


class RemoteManager:
    """Interacts with remote clients.

    The monitor system itself purposely does not depend on anything else in
    napari except for utils.events.

    However RemoteManager and its children RemoteCommands and
    RemoteMessages do very much depend on napari. RemoteCommands
    executes commands sent to napari by clients. RemoteMessages
    send message to remote clients, so as the current state
    of the layers.

    TODO_OCTREE: We expect this class to grow, if not we can nuke it
    and let ViewerModel just create both of these directly.

    Parameters
    ----------
    layers : LayerList
        The viewer's layers.
    """

    def __init__(self, layers: LayerList):
        self._commands = RemoteCommands(layers)
        self._messages = RemoteMessages(layers)

    def process_command(self, event: Event) -> None:
        """Process this command from a remote client.

        Parameters
        ----------
        event : Event
            Contains the command to process.
        """
        return self._commands.process_command(event)

    def on_poll(self, _event: Event) -> None:
        """Send out messages when polled."""
        self._messages.on_poll()
