"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Analytics = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const es = require("@aws-cdk/aws-elasticsearch");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class Analytics extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const account = cdk.Stack.of(this).account;
        // const stack = cdk.Stack.of(this);
        const esDomainName = (_a = props.domainName) !== null && _a !== void 0 ? _a : props.clusterId;
        // PolicyName: ElasticsearchPermissions
        const elasticsearchPermissionsPolicy = new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            actions: [
                'es:ESHttp*',
            ],
            principals: [
                new iam.AnyPrincipal,
            ],
            resources: [`arn:aws:es:${region}:${account}:domain/${esDomainName}/*`],
        });
        //Create Elasticsearch service
        const esDomain = new es.Domain(this, 'ElasticsearchDomain', {
            version: es.ElasticsearchVersion.V7_4,
            domainName: esDomainName,
            nodeToNodeEncryption: true,
            encryptionAtRest: {
                enabled: true,
            },
            ebs: {
                volumeSize: 100,
                volumeType: ec2.EbsDeviceVolumeType.GP2,
                enabled: true,
            },
            capacity: {
                masterNodes: 3,
                masterNodeInstanceType: 'm5.large.elasticsearch',
                dataNodes: 2,
                dataNodeInstanceType: 'm5.large.elasticsearch',
            },
            zoneAwareness: {
                enabled: true,
            },
            automatedSnapshotStartHour: 0,
            accessPolicies: [
                elasticsearchPermissionsPolicy,
            ],
            enforceHttps: true,
            logging: {
                slowSearchLogEnabled: true,
                appLogEnabled: true,
                slowIndexLogEnabled: true,
            },
        });
        new cdk.CfnOutput(this, 'ESDomainArn:', { value: esDomain.domainArn });
        new cdk.CfnOutput(this, 'ESDomainEndpoint:', { value: esDomain.domainEndpoint });
    }
}
exports.Analytics = Analytics;
//# sourceMappingURL=data:application/json;base64,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