import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TpuNodeConfig extends cdktf.TerraformMetaArguments {
    /**
     * The type of hardware accelerators associated with this node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#accelerator_type TpuNode#accelerator_type}
     *
     * @stability stable
     */
    readonly acceleratorType: string;
    /**
     * The CIDR block that the TPU node will use when selecting an IP address.
     *
     * This CIDR block must be a /29 block; the Compute Engine
     * networks API forbids a smaller block, and using a larger block would
     * be wasteful (a node can only consume one IP address).
     *
     * Errors will occur if the CIDR block has already been used for a
     * currently existing TPU node, the CIDR block conflicts with any
     * subnetworks in the user's provided network, or the provided network
     * is peered with another network that is using that CIDR block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#cidr_block TpuNode#cidr_block}
     *
     * @stability stable
     */
    readonly cidrBlock?: string;
    /**
     * The user-supplied description of the TPU. Maximum of 512 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#description TpuNode#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource labels to represent user provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#labels TpuNode#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The immutable name of the TPU.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#name TpuNode#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name of a network to peer the TPU node to.
     *
     * It must be a
     * preexisting Compute Engine network inside of the project on which
     * this API has been activated. If none is provided, "default" will be
     * used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#network TpuNode#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#project TpuNode#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The version of Tensorflow running in the Node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#tensorflow_version TpuNode#tensorflow_version}
     *
     * @stability stable
     */
    readonly tensorflowVersion: string;
    /**
     * Whether the VPC peering for the node is set up through Service Networking API.
     *
     * The VPC Peering should be set up before provisioning the node. If this field is set,
     * cidr_block field should not be specified. If the network that you want to peer the
     * TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#use_service_networking TpuNode#use_service_networking}
     *
     * @stability stable
     */
    readonly useServiceNetworking?: boolean | cdktf.IResolvable;
    /**
     * The GCP location for the TPU. If it is not provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#zone TpuNode#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * scheduling_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#scheduling_config TpuNode#scheduling_config}
     *
     * @stability stable
     */
    readonly schedulingConfig?: TpuNodeSchedulingConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#timeouts TpuNode#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TpuNodeTimeouts;
}
/**
 * @stability stable
 */
export declare class TpuNodeNetworkEndpoints extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get port(): number;
}
/**
 * @stability stable
 */
export interface TpuNodeSchedulingConfig {
    /**
     * Defines whether the TPU instance is preemptible.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#preemptible TpuNode#preemptible}
     *
     * @stability stable
     */
    readonly preemptible: boolean | cdktf.IResolvable;
}
export declare function tpuNodeSchedulingConfigToTerraform(struct?: TpuNodeSchedulingConfigOutputReference | TpuNodeSchedulingConfig): any;
/**
 * @stability stable
 */
export declare class TpuNodeSchedulingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TpuNodeSchedulingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TpuNodeSchedulingConfig | undefined);
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface TpuNodeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#create TpuNode#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#delete TpuNode#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html#update TpuNode#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function tpuNodeTimeoutsToTerraform(struct?: TpuNodeTimeoutsOutputReference | TpuNodeTimeouts): any;
/**
 * @stability stable
 */
export declare class TpuNodeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TpuNodeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TpuNodeTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html google_tpu_node}.
 *
 * @stability stable
 */
export declare class TpuNode extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tpu_node.html google_tpu_node} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TpuNodeConfig);
    private _acceleratorType?;
    /**
     * @stability stable
     */
    get acceleratorType(): string;
    /**
     * @stability stable
     */
    set acceleratorType(value: string);
    /**
     * @stability stable
     */
    get acceleratorTypeInput(): string | undefined;
    private _cidrBlock?;
    /**
     * @stability stable
     */
    get cidrBlock(): string;
    /**
     * @stability stable
     */
    set cidrBlock(value: string);
    /**
     * @stability stable
     */
    resetCidrBlock(): void;
    /**
     * @stability stable
     */
    get cidrBlockInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    /**
     * @stability stable
     */
    networkEndpoints(index: string): TpuNodeNetworkEndpoints;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    private _tensorflowVersion?;
    /**
     * @stability stable
     */
    get tensorflowVersion(): string;
    /**
     * @stability stable
     */
    set tensorflowVersion(value: string);
    /**
     * @stability stable
     */
    get tensorflowVersionInput(): string | undefined;
    private _useServiceNetworking?;
    /**
     * @stability stable
     */
    get useServiceNetworking(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useServiceNetworking(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseServiceNetworking(): void;
    /**
     * @stability stable
     */
    get useServiceNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _schedulingConfig;
    /**
     * @stability stable
     */
    get schedulingConfig(): TpuNodeSchedulingConfigOutputReference;
    /**
     * @stability stable
     */
    putSchedulingConfig(value: TpuNodeSchedulingConfig): void;
    /**
     * @stability stable
     */
    resetSchedulingConfig(): void;
    /**
     * @stability stable
     */
    get schedulingConfigInput(): TpuNodeSchedulingConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TpuNodeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TpuNodeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TpuNodeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
