# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['alto', 'alto.ext', 'alto.incl', 'alto.providers']

package_data = \
{'': ['*']}

install_requires = \
['doit>=0.36.0',
 'dynaconf>=3.1.11,<4.0.0',
 'fsspec>=2023.1.0,<2024.0.0',
 'pex>=2']

entry_points = \
{'console_scripts': ['alto = alto.main:main']}

setup_kwargs = {
    'name': 'singer-alto',
    'version': '0.2.14',
    'description': 'A package for managing singer.io taps and targets',
    'long_description': '# 👩\u200d🎤 Alto\n\n[![PyPI](https://img.shields.io/pypi/v/singer-alto)][pypi_]\n[![Status](https://img.shields.io/pypi/status/singer-alto.svg)][status]\n[![Python Version](https://img.shields.io/pypi/pyversions/singer-alto)][python version]\n[![License](https://img.shields.io/pypi/l/singer-alto)][license]\n\n[![Tests](https://github.com/z3z1ma/alto/workflows/Alto%20Tests/badge.svg)][tests]\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][pre-commit]\n[![Black](https://img.shields.io/badge/code%20style-black-000000.svg)][black]\n\n[pypi_]: https://pypi.org/project/singer-alto/\n[status]: https://pypi.org/project/singer-alto/\n[python version]: https://pypi.org/project/singer-alto\n[tests]: https://github.com/z3z1ma/alto/actions?workflow=Alto%20Tests\n[pre-commit]: https://github.com/pre-commit/pre-commit\n[black]: https://github.com/psf/black\n\n## Documentation\n\nJump into the [docs](https://z3z1ma.github.io/alto/) hosted on GitHub Pages to get started!\n\n[![Documentation](https://github.com/z3z1ma/alto/actions/workflows/pages/pages-build-deployment/badge.svg)](https://z3z1ma.github.io/alto/)\n\n✨ We have a lightweight, searchable **[tap](https://z3z1ma.github.io/alto/docs/integrations/taps)** index and **[target](https://z3z1ma.github.io/alto/docs/integrations/targets)** index embedded in the docs if you want to peruse the available integrations too! All links there forward to the integration documentation on Meltano Hub. ⏩\n\n## Introduction\n\n👋 Alto is a versatile data integration tool that allows you to easily run [Singer](https://www.singer.io/) plugins, build and cache [PEX](https://github.com/pantsbuild/pex) files encapsulating those plugins, and create a data reservoir 💧 whereby you can extract once and replay to as many destinations as you want as many times as you want. With Alto, you can seamlessly connect to various data sources, store your data in a centralized reservoir (singerlake), and manage lean, efficient extract load flows. Throw it into a `dbt` project, a data science project, or a passion project without fear of conflicting dependencies and watch it *just work*. The alto config file can sit right next to your dbt project yaml with no other changes to your repo beyond adding `singer-alto` to your requirements and you can be running data pipelines, today! 🎯\n\nLike [Meltano](https://github.com/meltano/meltano), Alto is driven **entirely by configuration** and the config structure drew much of its inspiration from Meltano. Alto supports YAML, TOML, and JSON leveraging [Dynaconf](https://github.com/dynaconf/dynaconf) for robust features. Because of the similarities to Meltano, using one or the other is a fairly straightforward process!\n\n### Installation\n\nI highly recommend going to the [docs](https://z3z1ma.github.io/alto/) to get up to speed. The docs are a work in progress but they are the best place to get started. If you are familiar with Meltano, you will feel right at home.\n\n```bash\npip install singer-alto\n```\n\n___\n\n## Example Configuration\n\nThe following is an example configuration file for Alto. It is a TOML file but you can use YAML or JSON as well. Alto will automatically detect the file type and load the configuration accordingly. I recommend using TOML for the most concise yet readable config file. I also recommend reading the [docs](https://z3z1ma.github.io/alto/) to get a better understanding of the config file structure.\n\n```toml title="alto.toml"\n[default]\nproject_name = "{project}"\nload_path = "raw"\nextensions = ["evidence"]\nenvironment.STARTER_PROJECT = 1\n# https://github.com/dlt-hub/dlt\nutilities.dlt.pip_url = "python-dlt[duckdb]>=0.2.0a25"\nutilities.dlt.environment.PEX_INHERIT_PATH = "fallback"\n\n[default.taps]\n# https://gitlab.com/meltano/tap-carbon-intensity\ncarbon-data.pip_url = "git+https://gitlab.com/meltano/tap-carbon-intensity.git#egg=tap_carbon_intensity"\ncarbon-data.executable = "tap-carbon-intensity"\ncarbon-data.load_path = "carbon_intensity"\ncarbon-data.capabilities = ["state", "catalog"]\ncarbon-data.select = ["*.*", "~*.dnoregion"]\n\n# https://hub.meltano.com/extractors/tap-bls\nlabor-data.pip_url = "git+https://github.com/frasermarlow/tap-bls#egg=tap_bls"\nlabor-data.executable = "tap-bls"\nlabor-data.capabilities = ["state", "catalog"]\nlabor-data.load_path = "bls"\nlabor-data.select = ["JTU000000000000000JOR", "JTU000000000000000JOL"]\nlabor-data.config.startyear = "2019"\nlabor-data.config.endyear = "2020"\nlabor-data.config.calculations = "true"\nlabor-data.config.annualaverage = "false"\nlabor-data.config.aspects = "false"\nlabor-data.config.disable_collection = "true"\nlabor-data.config.update_state = "false"\nlabor-data.config.series_list_file_location = "./series.json"\n\n[default.targets]\n# https://hub.meltano.com/loaders/target-singer-jsonl\njsonl.pip_url = "target-jsonl==0.1.4"\njsonl.executable = "target-jsonl"\njsonl.config.destination_path = "@format output/{this.load_path}"\n\n[github_actions]\nload_path = "cicd"\ntargets.jsonl.config.destination_path = "@format /github/workspace/output/{this.load_path}"\n```\n\nGiven the above configuration, you can run the following command to extract data from the BLS and Carbon Intensity APIs and load it into JSONL files.\n\n```bash\nalto carbon-data:jsonl\nalto labor-data:jsonl\n```\n\nOr send them to the project reservoir.\n\n```bash\nalto carbon-data:reservoir\nalto labor-data:reservoir\n```\n\nAnd from the reservoir, you can replay to any number of targets.\n\n```bash\nalto reservoir:carbon-data-jsonl\nalto reservoir:carbon-data-snowflake  # here as example, not in config\nalto reservoir:carbon-data-parquet    # here as example, not in config\n```\n\nLastly, you can invoke the utility defined above (you can invoke any plaugin this way).\n\n```bash\nalto invoke dlt --help  # invoke an executable\n\nalto invoke python dlt  # drop into a python shell with dlt installed\nalto invoke python dlt ./path/to/pipeline.py  # run a python script\n```\n\n## Comparison\n\n> How is this different than what exists today; namely Meltano? Outside of some of what we covered above.\n\n### Differences\n\nI would recommend `alto` if you want something lighter than Meltano. If you have a Python project where EL is one of many existing concerns and you want a dependency you can add that is lean, highly functional, and can stand alongside other dependencies without concern of conflict, I would recommend `alto`. I would recommend `alto` if you want a light snappy CLI with emphasis on less-is-more. I would recommend `alto` if you want to use Singer taps and targets but don\'t want to deal with the Meltano system db, migrations, or system directory. I would recommend `alto` if you want a codebase small enough to quickly iterate on or play with. I would recommend `meltano` if you want a tool that has a large community, more exposure, and features. I would recommend `alto` if those extra features are not necessary for your use case or your just looking to explore whats out there.\n\nAlto is able to run taps -> targets with centralized environment-aware configuration, secret management, automatically managed state, automatic discovery, catalog caching to a remote backend, catalog manipulation via `select` & `metadata` keys, and many of the things users love about Meltano. Given this, in most situations -- from a pure EL perspective, it stacks up well with Meltano since, given all else aside, it is the plugins that do much of the work once the state, configuration, and catalog are managed.\n\nThere are some compelling features in `alto` in general around how it manages plugins as cached PEX files, the built in reservoir as an available-by-default source & destination, and its _light_ footprint. Continuing to use Meltano as the baseline of comparison (since it was the inspiration!), here are some noteworthy differences:\n\n- The CLI is extremely fast due to the lightness of the package.\n\n- There is no system db so no database migrations or system directory to care about.\n\n- Significantly smaller dependency footprint by an **order of magnitude**. Alto only has 4 direct dependencies with no C or rust extensions in the dependency tree, it is pure python. The below comparison includes transitives:\n    - **Meltano**: >100\n    - **Alto**: 7\n\n- Because of its dependency footprint, it can be installed in very tiny Docker containers and wheels are cross platform compatible, naturally. It installs extremely quickly.\n\n- We use `PEX` (PythonEXecutable) for all plugins instead of loose venvs making plugins single files that are straightforward to cache.\n\n- We use a (simple) caching algorithm that makes the plugins re-usable across machines when combined with a remote filesystem and re-usable on the same system in general. This means, most of the time, you will build a PEX artifact once and **never** build it again. This makes an already lightweight `alto` even more portable. The benefits are applicable for your whole team.\n\n- Docker containers do not require you to "install" the plugins during the build process since the plugins are instantly pulled from a remote cache. This can **significantly** reduce image size if you are working with enough plugins.\n\n- Because of how plugins are handled it can be ran in `lambda` and serverless functions very easily. The time to spin up a pipeline is extremely quick.\n\n- We use `fsspec` to provide that filesystem abstraction layer that provides the exact same experience locally on a single machine as when plugged into a remote fsspec filesystem such as [s3](https://github.com/fsspec/s3fs), [gcs](https://github.com/fsspec/gcsfs), or [azure](https://github.com/fsspec/adlfs). We do not pin these remote backend dependencies, even as extras, but give the user the flexibility to include how they see fit.\n\n- An order of magnitude (`>85%`) less code which makes iteration/maintenance, extending, or forking easier (in theory) due to less accumulated tech debt though the flip side is less robustness\n\n- Because it is scaffolded over a build system, never worry about running `install` again, run pipelines immediately and alto works out the rest.\n\n- We use `Dynaconf` to manage configuration\n    - This gives us uniform support for json, toml, and yaml out of the box\n    - We get environment management\n    - We get configuration inheritance / deep merging\n    - We get `.env` support\n    - We get unique ways to render vars with `@format ` tokens\n    - We get hashicorp vault support\n\n- Encourages use of `bash` instead of `meltano run` commands. Bash is _already_ a fantastic glue code where you can run multiple extract load blocks, background them via `&` to parallelize loads, run utilities the way they have always been ran since everything is not wrapped in a venv with env vars injected by Meltano which is both a convenience and a constraint. `meltano run tap1 target1 tap2 target2` is ~ functionally identical to `alto tap1:target1 && alto tap2:target2`.\n\n- Straightforward to take advantage of the Python API exposed by `alto` to build your own custom pipelines.\n\n- A smaller codebase affords agility and flexibility. It has let us prove out integration with [dlt](https://dlthub.com/docs/intro) which is exciting!\n\n## Closing Remarks\n\nRemember, everything in software is a tradeoff. I offer `alto` as another tool in the ecosystem which gets the job done in a radically different way. I hope you find it useful and if you do, please consider contributing to the project or having the interesting discussions about what the ideal is. I am also happy to help with any questions you may have about the project.\n\nHats off to Meltano 🎉 for being a great inspiration and for being a great tool that helped to shape the ideal of what I wanted to build. I hope you find this interesting and divergent enough to warrant a look.\n\n[license]: https://github.com/z3z1ma/alto/blob/main/LICENSE\n',
    'author': 'z3z1ma',
    'author_email': 'butler.alex2010@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/z3z1ma/alto',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
