# aiosvkmimer
Asyncio library for SVK Mimer https://mimer.svk.se/

### UNDER DEVELOPMENT!!!


## Example
```python
#!/usr/bin/env python3
import asyncio
import logging
import pprint

from aiosvkmimer.client import Mimer
from prettytable import PrettyTable

# settings
AVAILABLE_KW = 8
LOGGING_LEVEL = logging.INFO
PERIOD_FROM = '2023-09-01'
PERIOD_TO = '2023-09-01'

# configure logging
logging.basicConfig(
    format='%(asctime)s.%(msecs)03d %(levelname)s %(module)s - %(funcName)s: %(message)s',
    datefmt='%Y-%m-%d %H:%M:%S',
    level=LOGGING_LEVEL
)

def nice_price_output(prices, prices_sum, description):
    table = PrettyTable()
    table.field_names = ['Date', f'{description} Price (SEK)']
    table.align = 'l'
    table.padding_width = 2
    for date, price in prices.items():
        table.add_row([date, price])
    table.add_row(['Total', prices_sum])
    print(table)

async def main():
    mimer = Mimer(
        kw_available=AVAILABLE_KW
    )
    await mimer.fetch(
        period_from=PERIOD_FROM,
        period_to=PERIOD_TO
    )

    prices_fcr_n = mimer.get_fcr_n_prices()
    prices_fcr_d_up = mimer.get_fcr_d_up_prices()
    prices_fcr_d_down = mimer.get_fcr_d_down_prices()

    nice_price_output(
        prices = prices_fcr_n,
        prices_sum = mimer.get_sum_prices(prices_fcr_n),
        description = 'FCR-N'
    )

    nice_price_output(
        prices = prices_fcr_d_up,
        prices_sum = mimer.get_sum_prices(prices_fcr_d_up),
        description = 'FCR-D UP'
    )

    nice_price_output(
        prices = prices_fcr_d_down,
        prices_sum = mimer.get_sum_prices(prices_fcr_d_down),
        description = 'FCR-D DOWN'
    )

if __name__ == '__main__':
    asyncio.run(main())
```

### Output
```bash
+-----------------------+----------------------+
|  Date                 |  FCR-N Price (SEK)   |
+-----------------------+----------------------+
|  2023-09-01 00:00:00  |  5.486731094065      |
|  2023-09-01 01:00:00  |  5.473278975271923   |
|  2023-09-01 02:00:00  |  5.483046953399573   |
|  2023-09-01 03:00:00  |  6.024919011768675   |
|  2023-09-01 04:00:00  |  6.104584800746637   |
|  2023-09-01 05:00:00  |  5.986810670706285   |
|  2023-09-01 06:00:00  |  5.294082266137055   |
|  2023-09-01 07:00:00  |  5.916679569335204   |
|  2023-09-01 08:00:00  |  5.313394297072511   |
|  2023-09-01 09:00:00  |  5.348831037548244   |
|  2023-09-01 10:00:00  |  5.9203287697025315  |
|  2023-09-01 11:00:00  |  5.135825881194346   |
|  2023-09-01 12:00:00  |  5.444676166159138   |
|  2023-09-01 13:00:00  |  5.870019916245568   |
|  2023-09-01 14:00:00  |  5.850853828046824   |
|  2023-09-01 15:00:00  |  5.273275331522941   |
|  2023-09-01 16:00:00  |  5.797683169549086   |
|  2023-09-01 17:00:00  |  5.319454888932867   |
|  2023-09-01 18:00:00  |  5.611263498677803   |
|  2023-09-01 19:00:00  |  5.239250943858182   |
|  2023-09-01 20:00:00  |  5.93201670243       |
|  2023-09-01 21:00:00  |  5.210278111126205   |
|  2023-09-01 22:00:00  |  5.133704096332981   |
|  2023-09-01 23:00:00  |  5.356158378649376   |
|  Total                |  133.52714835847897  |
+-----------------------+----------------------+
+-----------------------+------------------------+
|  Date                 |  FCR-D UP Price (SEK)  |
+-----------------------+------------------------+
|  2023-09-01 00:00:00  |  3.311632998865711     |
|  2023-09-01 01:00:00  |  3.288935554512015     |
|  2023-09-01 02:00:00  |  3.213295847960331     |
|  2023-09-01 03:00:00  |  3.3367902114671084    |
|  2023-09-01 04:00:00  |  3.398391009694043     |
|  2023-09-01 05:00:00  |  3.3220856146399993    |
|  2023-09-01 06:00:00  |  3.57437562248         |
|  2023-09-01 07:00:00  |  3.3276878273599997    |
|  2023-09-01 08:00:00  |  3.5360363853152434    |
|  2023-09-01 09:00:00  |  3.3858881034742017    |
|  2023-09-01 10:00:00  |  3.4942032289633813    |
|  2023-09-01 11:00:00  |  3.4234401975693007    |
|  2023-09-01 12:00:00  |  3.398380667428867     |
|  2023-09-01 13:00:00  |  3.4784308005587947    |
|  2023-09-01 14:00:00  |  3.467791909074881     |
|  2023-09-01 15:00:00  |  3.356563749603953     |
|  2023-09-01 16:00:00  |  3.4768104629727423    |
|  2023-09-01 17:00:00  |  3.3993578147653962    |
|  2023-09-01 18:00:00  |  3.4107899648525573    |
|  2023-09-01 19:00:00  |  3.399232440138542     |
|  2023-09-01 20:00:00  |  3.26405194036575      |
|  2023-09-01 21:00:00  |  3.3716430111448683    |
|  2023-09-01 22:00:00  |  3.287736021089064     |
|  2023-09-01 23:00:00  |  3.3028224861553075    |
|  Total                |  81.22637387045205     |
+-----------------------+------------------------+
+-----------------------+--------------------------+
|  Date                 |  FCR-D DOWN Price (SEK)  |
+-----------------------+--------------------------+
|  2023-09-01 00:00:00  |  6.320488106056495       |
|  2023-09-01 01:00:00  |  6.112997699823686       |
|  2023-09-01 02:00:00  |  6.134507849844338       |
|  2023-09-01 03:00:00  |  6.499827573714409       |
|  2023-09-01 04:00:00  |  6.844614022955501       |
|  2023-09-01 05:00:00  |  6.503989107457241       |
|  2023-09-01 06:00:00  |  5.819638910411214       |
|  2023-09-01 07:00:00  |  5.3365174089495655      |
|  2023-09-01 08:00:00  |  5.884750472026569       |
|  2023-09-01 09:00:00  |  5.607872638348425       |
|  2023-09-01 10:00:00  |  6.010793589290964       |
|  2023-09-01 11:00:00  |  5.860842833901714       |
|  2023-09-01 12:00:00  |  5.903521302210824       |
|  2023-09-01 13:00:00  |  5.986418718780103       |
|  2023-09-01 14:00:00  |  5.638328690026532       |
|  2023-09-01 15:00:00  |  5.50365199491099        |
|  2023-09-01 16:00:00  |  6.00273359520028        |
|  2023-09-01 17:00:00  |  5.799405263827196       |
|  2023-09-01 18:00:00  |  6.062401602087815       |
|  2023-09-01 19:00:00  |  5.780730776740605       |
|  2023-09-01 20:00:00  |  6.2497822237014375      |
|  2023-09-01 21:00:00  |  5.658725413145366       |
|  2023-09-01 22:00:00  |  5.317705775310582       |
|  2023-09-01 23:00:00  |  6.1910944685587         |
|  Total                |  143.03134003728056      |
+-----------------------+--------------------------+
```