import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as ecr from '@aws-cdk/aws-ecr';
import { Construct } from '@aws-cdk/core';
import { Action } from '../action';
/**
 * The CodePipeline variables emitted by the ECR source Action.
 *
 * @stability stable
 */
export interface EcrSourceVariables {
    /**
     * The identifier of the registry.
     *
     * In ECR, this is usually the ID of the AWS account owning it.
     *
     * @stability stable
     */
    readonly registryId: string;
    /**
     * The physical name of the repository that this action tracks.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * The digest of the current image, in the form '<digest type>:<digest value>'.
     *
     * @stability stable
     */
    readonly imageDigest: string;
    /**
     * The Docker tag of the current image.
     *
     * @stability stable
     */
    readonly imageTag: string;
    /**
     * The full ECR Docker URI of the current image.
     *
     * @stability stable
     */
    readonly imageUri: string;
}
/**
 * Construction properties of {@link EcrSourceAction}.
 *
 * @stability stable
 */
export interface EcrSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The image tag that will be checked for changes.
     *
     * @default 'latest'
     * @stability stable
     */
    readonly imageTag?: string;
    /**
     * @stability stable
     */
    readonly output: codepipeline.Artifact;
    /**
     * The repository that will be watched for changes.
     *
     * @stability stable
     */
    readonly repository: ecr.IRepository;
}
/**
 * The ECR Repository source CodePipeline Action.
 *
 * Will trigger the pipeline as soon as the target tag in the repository
 * changes, but only if there is a CloudTrail Trail in the account that
 * captures the ECR event.
 *
 * @stability stable
 */
export declare class EcrSourceAction extends Action {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: EcrSourceActionProps);
    /**
     * The variables emitted by this action.
     *
     * @stability stable
     */
    get variables(): EcrSourceVariables;
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @stability stable
     */
    protected bound(_scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
