"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsRedrive = void 0;
const path_1 = require("path");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const core_1 = require("@aws-cdk/core");
/**
 * A construct that encompasses a Lambda Function that will move all messages from a source queue (dlq) to a destination queue (main).
 */
class SqsRedrive extends core_1.Construct {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        this.redriveFunction = new aws_lambda_nodejs_1.NodejsFunction(this, `${id}-queue-redrive`, {
            functionName: id,
            entry: path_1.join(__dirname, 'sqs-redrive.queue-redrive.ts'),
            ...props.lambdaProps,
            environment: {
                QUEUE_URL: props.mainQueue.queueUrl,
                DLQ_URL: props.deadLetterQueue.queueUrl,
                ...(_a = props === null || props === void 0 ? void 0 : props.lambdaProps) === null || _a === void 0 ? void 0 : _a.environment,
            },
        });
        props.deadLetterQueue.grantConsumeMessages(this.redriveFunction);
        props.mainQueue.grantSendMessages(this.redriveFunction);
    }
}
exports.SqsRedrive = SqsRedrive;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLXJlZHJpdmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvc3FzLXJlZHJpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQTRCO0FBRTVCLGtFQUFpRjtBQUVqRix3Q0FBMEM7Ozs7QUFxQzFDLE1BQWEsVUFBVyxTQUFRLGdCQUFTOzs7O0lBTXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7O1FBQzlELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLGtDQUFjLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxnQkFBZ0IsRUFBRTtZQUNyRSxZQUFZLEVBQUUsRUFBRTtZQUNoQixLQUFLLEVBQUUsV0FBSSxDQUFDLFNBQVMsRUFBRSw4QkFBOEIsQ0FBQztZQUN0RCxHQUFHLEtBQUssQ0FBQyxXQUFXO1lBQ3BCLFdBQVcsRUFBRTtnQkFDWCxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxRQUFRO2dCQUNuQyxPQUFPLEVBQUUsS0FBSyxDQUFDLGVBQWdCLENBQUMsUUFBUTtnQkFDeEMsU0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsV0FBVywwQ0FBRSxXQUFXO2FBQ25DO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsS0FBSyxDQUFDLGVBQWUsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDakUsS0FBSyxDQUFDLFNBQVMsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7SUFFMUQsQ0FBQztDQUNGO0FBeEJELGdDQXdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGpvaW4gfSBmcm9tICdwYXRoJztcbmltcG9ydCB7IElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgTm9kZWpzRnVuY3Rpb24sIE5vZGVqc0Z1bmN0aW9uUHJvcHMgfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhLW5vZGVqcyc7XG5pbXBvcnQgeyBJUXVldWUgfSBmcm9tICdAYXdzLWNkay9hd3Mtc3FzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU3FzUmVkcml2ZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVhZExldHRlclF1ZXVlOiBJUXVldWU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWFpblF1ZXVlOiBJUXVldWU7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxhbWJkYVByb3BzPzogTm9kZWpzRnVuY3Rpb25Qcm9wcztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNxc1JlZHJpdmUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlZHJpdmVGdW5jdGlvbjogSUZ1bmN0aW9uO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTcXNSZWRyaXZlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5yZWRyaXZlRnVuY3Rpb24gPSBuZXcgTm9kZWpzRnVuY3Rpb24odGhpcywgYCR7aWR9LXF1ZXVlLXJlZHJpdmVgLCB7XG4gICAgICBmdW5jdGlvbk5hbWU6IGlkLFxuICAgICAgZW50cnk6IGpvaW4oX19kaXJuYW1lLCAnc3FzLXJlZHJpdmUucXVldWUtcmVkcml2ZS50cycpLFxuICAgICAgLi4ucHJvcHMubGFtYmRhUHJvcHMsXG4gICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICBRVUVVRV9VUkw6IHByb3BzLm1haW5RdWV1ZS5xdWV1ZVVybCxcbiAgICAgICAgRExRX1VSTDogcHJvcHMuZGVhZExldHRlclF1ZXVlIS5xdWV1ZVVybCxcbiAgICAgICAgLi4ucHJvcHM/LmxhbWJkYVByb3BzPy5lbnZpcm9ubWVudCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICBwcm9wcy5kZWFkTGV0dGVyUXVldWUuZ3JhbnRDb25zdW1lTWVzc2FnZXModGhpcy5yZWRyaXZlRnVuY3Rpb24pO1xuICAgIHByb3BzLm1haW5RdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyh0aGlzLnJlZHJpdmVGdW5jdGlvbik7XG5cbiAgfVxufVxuIl19