<!--
SPDX-FileCopyrightText: 2022 The Ikarus Developers mueller@ibb.uni-stuttgart.de
SPDX-License-Identifier: LGPL-3.0-or-later
-->
# Ikarus

[![Debian](https://github.com/ikarus-project/ikarus/actions/workflows/debian.yml/badge.svg)](https://github.com/ikarus-project/ikarus/actions/workflows/debian.yml)
[![codecov](https://codecov.io/gh/ikarus-project/ikarus/branch/main/graph/badge.svg?token=zJgggitPMc)](https://codecov.io/gh/ikarus-project/ikarus)
[![CodeStyle](https://github.com/ikarus-project/ikarus/actions/workflows/style.yml/badge.svg)](https://github.com/ikarus-project/ikarus/actions/workflows/style.yml)
[![Docs](https://github.com/ikarus-project/ikarus/actions/workflows/ghpages.yml/badge.svg)](https://github.com/ikarus-project/ikarus/actions/workflows/ghpages.yml)
[![CodeFactor](https://www.codefactor.io/repository/github/ikarus-project/ikarus/badge/main)](https://www.codefactor.io/repository/github/ikarus-project/ikarus/overview/main)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/5c588e67d1e541fc9be3c7377297aa8a)](https://www.codacy.com/gh/ikarus-project/ikarus/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=ikarus-project/ikarus&amp;utm_campaign=Badge_Grade)
[![Gitter](https://badges.gitter.im/ikarus-project/community.svg)](https://gitter.im/ikarus-project/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)


[![Release](https://badgen.net/badge/Release/0.3/purple?icon=github)](https://github.com/ikarus-project/ikarus/releases)
[![Doi](https://img.shields.io/badge/DOI-10.18419%2Fdarus--3303-orange)](https://doi.org/10.18419/darus-3303)
[![SWH](https://archive.softwareheritage.org/badge/origin/https://github.com/ikarus-project/ikarus/)](https://archive.softwareheritage.org/browse/origin/?origin_url=https://github.com/ikarus-project/ikarus)
[![SWHRelease](https://archive.softwareheritage.org/badge/swh:1:rel:2cbfacc591c5fa48bdc84b375e42d1ab5304425f/)](https://archive.softwareheritage.org/swh:1:rel:2cbfacc591c5fa48bdc84b375e42d1ab5304425f;origin=https://github.com/ikarus-project/ikarus;visit=swh:1:snp:22424908ab42ab0d38be84c34235b8b5ae7af6c4)

This project tries to provide an easy to read and an easy to use finite element framework.
It is heavily inspired by the finite element software [DUNE](https://dune-project.org/), the book [DUNE — The Distributed and Unified Numerics Environment](https://www.springer.com/gp/book/9783030597016),
[deal.II](https://www.dealii.org/) and [Kratos](https://github.com/KratosMultiphysics/Kratos).

We favor value semantics and readability.

Concerning the design of CI and the documentation we were inspired by [Autodiff](https://autodiff.github.io/)  and [Kratos](https://github.com/KratosMultiphysics/Kratos).

The documentation resides at https://ikarus-project.github.io/.

If you use Ikarus, please cite the dataset by clicking on the doi badge above and then selecting "Cite Dataset," where you will find several citing options. 

## Contributors

<img align="left" src="https://user-images.githubusercontent.com/10537464/205657284-f6ace981-42a8-49f1-9c66-4c464f15ce4a.png" width="128">
<p></br></br><a href="https://www.ibb.uni-stuttgart.de/">Institute for Structural Mechanics</a></p>
