---
draft: false
date: 2022-12-16
authors:
  - tm
  - am
categories:
  - Release
  - Prometheus
  - Linear elasticity
  - Path-following
  - Documentation
  - Docker images
  - Licenses

comments: true
---

# Release of v0.3 (Prometheus)
**We are happy to announce that Ikarus has made it to version 0.3. In this version, some new features are added, 
and maintenance-related fixes have been done by us (Tarun and Alex). We are moving forward to the first version (v1.0) release, 
and we consider v0.3 to be a bigger milestone.**

As this is the first blog, we would like to start by sharing the thoughts behind the reasons for creating Ikarus. Being 
researchers ourselves, we found it motivating to have an independent code for investigating various aspects of 
computational mechanics. On that note, we proceeded with the finite element approach to implement a generic 
code for solving partial differential equations, which was inspired by [generic](https://en.wikipedia.org/wiki/Generic_programming) algorithms. 
Consequently, [Ikarus](https://en.wikipedia.org/wiki/Icarus) was born, granting us the wings to perform intensive research in this field. 
It is basically a C++ library, providing several features to carry out finite element analysis.

<!-- more -->

During the development phase, we were always asked two questions: "How to use Ikarus?" and "Why to use Ikarus when 
there are so many other tools to perform a finite element analysis"? To address such concerns,
we attempted to make 
things easier for users in this version by automating several workflows on GitHub, updating the documentation, and 
adding some concepts from finite element fundamentals with relevant examples. To be specific, the major concern was 
easy-to-read documentation. We hope that good documentation 
will motivate us to make even better documentation, in the spirit of an "inverse" 
[broken windows theory](https://en.wikipedia.org/wiki/Broken_windows_theory). A quick overview of this version is provided
in the following text.

<figure class="inline end" markdown>
![Prometheus brings fire to humanity](https://upload.wikimedia.org/wikipedia/commons/thumb/5/5b/Heinrich_fueger_1817_prometheus_brings_fire_to_mankind.jpg/421px-Heinrich_fueger_1817_prometheus_brings_fire_to_mankind.jpg?20210918140744){width="600" loading=lazy}
  <figcaption style="font-size: 12px"><a href="https://commons.wikimedia.org/wiki/File:Heinrich_fueger_1817_prometheus_brings_fire_to_mankind.jpg">Prometheus brings fire to humanity</a> by <a href="https://en.wikipedia.org/wiki/Heinrich_F%C3%BCger">Heinrich Füger</a></figcaption>
</figure>


## Workflows
A workflow for [codespell](https://github.com/codespell-project/codespell) has been created in order to have a smarter 
CI. This workflow is executed on GitHub after every commit is pushed. The CI has now the capability to check grammar and 
typographical errors in comments and variable names. The examples, which resided earlier in the repository of Ikarus, 
have now been moved to a new repository. The users can thereby just use Ikarus as an external finite element library by installing 
it, followed by the execution of their own simulations. A workflow is created that checks if all the examples are working with 
every commit to the `main` branch of Ikarus. This ensures the proper functioning of the existing examples in Ikarus 
during the development of newer features. Docker images are automatically generated as well for systems with Ikarus 
installed, with commits to the `main` branch. The Docker images make it even easier to use Ikarus because no additional 
software is required.
A license statement is also added to each file, and the license files 
themselves are separated into a separate folder. A workflow also checks for the inclusion of the license statement in 
the files associated with Ikarus.
Moreover, we created a workflow that automatically creates a release on [GitHub](https://github.com/ikarus-project/ikarus/releases) 
and pushes it to [DaRUS](https://darus.uni-stuttgart.de/dataset.xhtml?persistentId=doi%3A10.18419%2Fdarus-3303&version=DRAFT), 
enabling us to assign a DOI to the current version.

## Finite element technology
A beginner to finite element technology, in the context of computational solid mechanics, always starts with simulations in the 
linear-elastic regime. This instilled us with the desire to incorporate this element technology into Ikarus in a sophisticated 
way. As a result, we implemented a template-based code that enables the users to utilize the linear-elastic finite 
elements in single and multi-dimensions for various geometries with lesser modifications to the code. To avoid locking
characteristics, the elements can also be decorated with the enhanced assumed strain (EAS) concept. A variety of examples, 
including the famous Cook's membrane problem, are made available to learn the implementation styles of Ikarus. This was 
followed by adding path-following techniques, which use a scalar subsidiary function to also solve non-linear problems. 
Furthermore, an additional class was added to handle homogeneous and inhomogeneous Dirichlet boundary conditions. 
A set of local functions that enable efficient implementation of finite elements are also moved to a separate repository 
for easier code handling and faster workflow processing in Ikarus.

## Documentation and social media
For a better understanding of Ikarus, the entire documentation has been refactored with grammatical corrections and the 
inclusion of relevant information while excluding the unnecessary parts. Installation instructions, blog capabilities, and brief explanations of examples are added.
Additionally, the *snow* plug-in from [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) is included for this release as a seasonal plug-in.
Links to the Ikarus developers' social media accounts can also be found on the bottom-right side of the page. 
Finally, a [Gitter](https://gitter.im/ikarus-project/community) community is formed in order to interact more with users and quickly resolve issues.

## What next?
The following are some key milestones that have been completed or are planned to be released as stepping stones to version 1.0.

- [ ] Workflows

    * [x] License and example checks ([#107](https://github.com/ikarus-project/ikarus/pull/107 "To pull request") and [#114](https://github.com/ikarus-project/ikarus/pull/114 "To pull request"))
    * [x] Create Docker images
    * [x] Create a workflow to create a "release" and add a version to [DaRUS](https://darus.uni-stuttgart.de/dataset.xhtml?persistentId=doi%3A10.18419%2Fdarus-3303&version=DRAFT)
    * [ ] Deploy Python bindings to [PyPi](https://pypi.org/) and create Python bindings

- [ ] Finite element technology

    * [x] Linear elastic finite elements with EAS ([#74](https://github.com/ikarus-project/ikarus/pull/74 "To pull request"))
    * [x] Path-following techniques ([#80](https://github.com/ikarus-project/ikarus/pull/80 "To pull request"))
    * [ ] Efficient implementation of non-linear elasticity
    * [ ] Standard plate and beam elements
    * [ ] Handling inhomogeneous Dirichlet boundary conditions in all existing solving methods
    * [ ] Include a mechanical-material library
    * [ ] Linear dynamics
    * [ ] More supporting examples

- [ ] Documentation
    * [x] Improving existing documentation and describing examples of Ikarus ([#106](https://github.com/ikarus-project/ikarus/pull/106 "To pull request") and [#125](https://github.com/ikarus-project/ikarus/pull/125 "To pull request"))
    * [ ] Detailed explanations of examples in Ikarus
    * [ ] Implementation of linear and non-linear elasticity
    * [ ] Logo and gallery
