<!--
SPDX-FileCopyrightText: 2022 The Ikarus Developers mueller@ibb.uni-stuttgart.de
SPDX-License-Identifier: CC-BY-SA-4.0
-->

# Welcome to the documentation of Ikarus
Ikarus is a C++-based library built within the finite element architecture. It originated at the [Institute for Structural Mechanics](https://www.ibb.uni-stuttgart.de/en/) at the University of Stuttgart.

This project tries to provide an easy-to-read and an easy-to-use finite element framework.
It is heavily inspired by the finite element software [DUNE](https://dune-project.org/), the book [DUNE — The Distributed and Unified Numerics Environment](https://www.springer.com/gp/book/9783030597016),
[deal.II](https://www.dealii.org/) and [Kratos](https://github.com/KratosMultiphysics/Kratos).
Furthermore, it directly uses several modules from [DUNE](https://dune-project.org/).

The design of CI and the documentation were inspired by [Autodiff](https://autodiff.github.io/)  and [Kratos](https://github.com/KratosMultiphysics/Kratos).

The documentation is built using [Material for MkDocs](https://squidfunk.github.io/mkdocs-material/).

Ikarus provides the tools to create one's own examples and rapidly prototype finite element solution algorithms. 
This is done by using template metaprogramming in C++ to write generic code, which is compiled for the example.