// SPDX-FileCopyrightText: 2022 The Ikarus Developers mueller@ibb.uni-stuttgart.de
// SPDX-License-Identifier: LGPL-3.0-or-later
#include <config.h>

#include <dune/common/test/testsuite.hh>

#include <pyikarus/utils/duneUtilities.hh>
#include <pyikarus/utils/init.hh>

using Dune::TestSuite;

int main(int argc, char** argv) {
  Ikarus::init(argc, argv);
  TestSuite t;

  autodiff::real valDual = 7.0;
  valDual[1]             = 1;
  Python::start();
  auto pyLambda = Python::Conversion<autodiff::Real<1, double>>::toPy(valDual);

  autodiff::real valExpected;
  Python::Conversion<autodiff::Real<1, double>>::toC(pyLambda, valExpected);

  t.check(valDual == valExpected);

  return t.exit();
}
