# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-08-17 18:45
from __future__ import unicode_literals

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [("core", "0002_post_maximum_memberships")]

    operations = [
        migrations.AlterField(
            model_name="division",
            name="country",
            field=models.CharField(
                help_text="An ISO-3166-1 alpha-2 code identifying the county where this division is found.",
                max_length=2,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="name",
            field=models.CharField(
                help_text="The name of the division.", max_length=300
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid1",
            field=models.CharField(
                blank=True,
                help_text="The first subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid2",
            field=models.CharField(
                blank=True,
                help_text="The second subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid3",
            field=models.CharField(
                blank=True,
                help_text="The third subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid4",
            field=models.CharField(
                blank=True,
                help_text="The fourth subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid5",
            field=models.CharField(
                blank=True,
                help_text="The fifth subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid6",
            field=models.CharField(
                blank=True,
                help_text="The sixth subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subid7",
            field=models.CharField(
                blank=True,
                help_text="The seventh subidentifier in the unique identifer.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype1",
            field=models.CharField(
                blank=True,
                help_text="The first subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype2",
            field=models.CharField(
                blank=True,
                help_text="The second subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype3",
            field=models.CharField(
                blank=True,
                help_text="The third subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype4",
            field=models.CharField(
                blank=True,
                help_text="The fourth subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype5",
            field=models.CharField(
                blank=True,
                help_text="The fifth subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype6",
            field=models.CharField(
                blank=True,
                help_text="The sixth subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="division",
            name="subtype7",
            field=models.CharField(
                blank=True,
                help_text="The seventh subtype in the unique identifier.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="classification",
            field=models.CharField(
                choices=[
                    ("government", "Government"),
                    ("legislature", "Legislature"),
                    ("executive", "Executive"),
                    ("school", "School System"),
                    ("park", "Park District"),
                    ("sewer", "Sewer District"),
                    ("forest", "Forest Preserve District"),
                    ("transit_authority", "Transit Authority"),
                ],
                db_index=True,
                default="government",
                help_text="The type of Jurisdiction being defined.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, help_text="The date and time of creation."
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="division",
            field=models.ForeignKey(
                help_text="A link to a Division related to this Jurisdiction.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="jurisdictions",
                to="core.Division",
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="extras",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=dict,
                help_text="A key-value store for storing arbitrary information not covered elsewhere.",
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="feature_flags",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.TextField(),
                blank=True,
                default=list,
                help_text="A list of features that are present for data in this jurisdiction.",
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="name",
            field=models.CharField(
                help_text="The common name of the Jurisdiction, such as 'Wyoming.'",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="updated_at",
            field=models.DateTimeField(
                auto_now=True, help_text="The date and time of the last update."
            ),
        ),
        migrations.AlterField(
            model_name="jurisdiction",
            name="url",
            field=models.URLField(
                help_text="The primary website of the Jurisdiction.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, help_text="The date and time of creation."
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="end_date",
            field=models.CharField(
                blank=True,
                help_text="The date on which the relationship ended in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="extras",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=dict,
                help_text="A key-value store for storing arbitrary information not covered elsewhere.",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="label",
            field=models.CharField(
                blank=True,
                help_text="A label describing the membership.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="on_behalf_of",
            field=models.ForeignKey(
                help_text="The Organization on whose behalf the Person is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="memberships_on_behalf_of",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="organization",
            field=models.ForeignKey(
                help_text="A link to the Organization in which the Person is a member.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="memberships",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person that is a member of the Organization.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="memberships",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="person_name",
            field=models.CharField(
                blank=True,
                default="",
                help_text="The name of the Person that is a member of the Organization.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="post",
            field=models.ForeignKey(
                help_text="\tThe Post held by the member in the Organization.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="memberships",
                to="core.Post",
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="role",
            field=models.CharField(
                blank=True,
                help_text="The role that the member fulfills in the Organization.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="start_date",
            field=models.CharField(
                blank=True,
                help_text="The date on which the relationship began in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="membership",
            name="updated_at",
            field=models.DateTimeField(
                auto_now=True, help_text="The date and time of the last update."
            ),
        ),
        migrations.AlterField(
            model_name="membershipcontactdetail",
            name="label",
            field=models.CharField(
                blank=True,
                help_text="A title for the content of the Contact.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membershipcontactdetail",
            name="membership",
            field=models.ForeignKey(
                help_text="A link to the Membership connected to this contact.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contact_details",
                to="core.Membership",
            ),
        ),
        migrations.AlterField(
            model_name="membershipcontactdetail",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about the Contact value.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membershipcontactdetail",
            name="type",
            field=models.CharField(
                choices=[
                    ("address", "Postal Address"),
                    ("email", "Email"),
                    ("url", "URL"),
                    ("fax", "Fax"),
                    ("text", "Text Phone"),
                    ("voice", "Voice Phone"),
                    ("video", "Video Phone"),
                    ("pager", "Pager"),
                    ("textphone", "Device for people with hearing impairment"),
                ],
                help_text="The type of Contact being defined.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="membershipcontactdetail",
            name="value",
            field=models.CharField(
                help_text="The content of the Contact information like a phone number or email address.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membershiplink",
            name="membership",
            field=models.ForeignKey(
                help_text="A reference to the Membership connected to this link.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="links",
                to="core.Membership",
            ),
        ),
        migrations.AlterField(
            model_name="membershiplink",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="membershiplink",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="classification",
            field=models.CharField(
                blank=True,
                choices=[
                    ("legislature", "Legislature"),
                    ("executive", "Executive"),
                    ("upper", "Upper Chamber"),
                    ("lower", "Lower Chamber"),
                    ("party", "Party"),
                    ("committee", "Committee"),
                    ("commission", "Commission"),
                    ("corporation", "Corporation"),
                    ("agency", "Agency"),
                    ("department", "Department"),
                ],
                help_text="The type of Organization being defined.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, help_text="The date and time of creation."
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="dissolution_date",
            field=models.CharField(
                blank=True,
                help_text="The dissolution date of the Organization in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="extras",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=dict,
                help_text="A key-value store for storing arbitrary information not covered elsewhere.",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="founding_date",
            field=models.CharField(
                blank=True,
                help_text="The founding date of the Organization in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="image",
            field=models.URLField(
                blank=True,
                help_text="A URL leading to an image that identifies the Organization visually.",
                max_length=2000,
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="jurisdiction",
            field=models.ForeignKey(
                help_text="A link to the Jurisdiction that contains this Organization.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="organizations",
                to="core.Jurisdiction",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="name",
            field=models.CharField(
                help_text="The name of the Organization.", max_length=300
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="parent",
            field=models.ForeignKey(
                help_text="A link to another Organization that serves as this Organization's parent.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="children",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organization",
            name="updated_at",
            field=models.DateTimeField(
                auto_now=True, help_text="The date and time of the last update."
            ),
        ),
        migrations.AlterField(
            model_name="organizationcontactdetail",
            name="label",
            field=models.CharField(
                blank=True,
                help_text="A title for the content of the Contact.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationcontactdetail",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about the Contact value.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationcontactdetail",
            name="organization",
            field=models.ForeignKey(
                help_text="A link to the Organization connected to this contact.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contact_details",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organizationcontactdetail",
            name="type",
            field=models.CharField(
                choices=[
                    ("address", "Postal Address"),
                    ("email", "Email"),
                    ("url", "URL"),
                    ("fax", "Fax"),
                    ("text", "Text Phone"),
                    ("voice", "Voice Phone"),
                    ("video", "Video Phone"),
                    ("pager", "Pager"),
                    ("textphone", "Device for people with hearing impairment"),
                ],
                help_text="The type of Contact being defined.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="organizationcontactdetail",
            name="value",
            field=models.CharField(
                help_text="The content of the Contact information like a phone number or email address.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationidentifier",
            name="identifier",
            field=models.CharField(
                help_text="A unique identifier developed by an upstream or third party source.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationidentifier",
            name="organization",
            field=models.ForeignKey(
                help_text="Reference to the Organization identified by this alternative identifier.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="identifiers",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organizationidentifier",
            name="scheme",
            field=models.CharField(
                help_text="The name of the service that created the identifier.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationlink",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationlink",
            name="organization",
            field=models.ForeignKey(
                help_text="A reference to the Organization connected to this link.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="links",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organizationlink",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="organizationname",
            name="end_date",
            field=models.CharField(
                blank=True,
                help_text="An optional end date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="organizationname",
            name="name",
            field=models.CharField(
                db_index=True, help_text="An alternative name.", max_length=500
            ),
        ),
        migrations.AlterField(
            model_name="organizationname",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about alternative name.",
                max_length=500,
            ),
        ),
        migrations.AlterField(
            model_name="organizationname",
            name="organization",
            field=models.ForeignKey(
                help_text="A link to the Organization with this alternative name.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="other_names",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organizationname",
            name="start_date",
            field=models.CharField(
                blank=True,
                help_text="An optional start date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="organizationsource",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="organizationsource",
            name="organization",
            field=models.ForeignKey(
                help_text="A link to the Organization connected to this source.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sources",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="organizationsource",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="biography",
            field=models.TextField(
                blank=True, help_text="An extended account of a Person's life."
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="birth_date",
            field=models.CharField(
                blank=True,
                help_text="The date of a Person's birth in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, help_text="The date and time of creation."
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="death_date",
            field=models.CharField(
                blank=True,
                help_text="The date of a Person's death in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="extras",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=dict,
                help_text="A key-value store for storing arbitrary information not covered elsewhere.",
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="family_name",
            field=models.CharField(
                blank=True, help_text="A Person's family name.", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="gender",
            field=models.CharField(
                blank=True, help_text="A Person's gender", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="given_name",
            field=models.CharField(
                blank=True, help_text="A Person's given name.", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="image",
            field=models.URLField(
                blank=True,
                help_text="A URL leading to an image that identifies the Person visually.",
                max_length=2000,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="name",
            field=models.CharField(
                db_index=True,
                help_text="A Person's preferred full name.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="national_identity",
            field=models.CharField(
                blank=True,
                help_text="The nation a Person is identified with.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="sort_name",
            field=models.CharField(
                blank=True,
                default="",
                help_text="A version of a Person's full name rearranged for alphabetical sorting.",
                max_length=100,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="summary",
            field=models.CharField(
                blank=True,
                help_text="A short, one-line account of a Person's life.",
                max_length=500,
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="updated_at",
            field=models.DateTimeField(
                auto_now=True, help_text="The date and time of the last update."
            ),
        ),
        migrations.AlterField(
            model_name="personcontactdetail",
            name="label",
            field=models.CharField(
                blank=True,
                help_text="A title for the content of the Contact.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personcontactdetail",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about the Contact value.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personcontactdetail",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person connected to this contact.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contact_details",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="personcontactdetail",
            name="type",
            field=models.CharField(
                choices=[
                    ("address", "Postal Address"),
                    ("email", "Email"),
                    ("url", "URL"),
                    ("fax", "Fax"),
                    ("text", "Text Phone"),
                    ("voice", "Voice Phone"),
                    ("video", "Video Phone"),
                    ("pager", "Pager"),
                    ("textphone", "Device for people with hearing impairment"),
                ],
                help_text="The type of Contact being defined.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="personcontactdetail",
            name="value",
            field=models.CharField(
                help_text="The content of the Contact information like a phone number or email address.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personidentifier",
            name="identifier",
            field=models.CharField(
                help_text="A unique identifier developed by an upstream or third party source.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personidentifier",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person connected to this alternative identifier.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="identifiers",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="personidentifier",
            name="scheme",
            field=models.CharField(
                help_text="The name of the service that created the identifier.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personlink",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personlink",
            name="person",
            field=models.ForeignKey(
                help_text="A reference to the Person connected to this link.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="links",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="personlink",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="personname",
            name="end_date",
            field=models.CharField(
                blank=True,
                help_text="An optional end date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="personname",
            name="name",
            field=models.CharField(
                db_index=True, help_text="An alternative name.", max_length=500
            ),
        ),
        migrations.AlterField(
            model_name="personname",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about alternative name.",
                max_length=500,
            ),
        ),
        migrations.AlterField(
            model_name="personname",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person connected to this alternative name.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="other_names",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="personname",
            name="start_date",
            field=models.CharField(
                blank=True,
                help_text="An optional start date for usage of the alternative name in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="personsource",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="personsource",
            name="person",
            field=models.ForeignKey(
                help_text="A link to the Person connected to this source.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sources",
                to="core.Person",
            ),
        ),
        migrations.AlterField(
            model_name="personsource",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, help_text="The date and time of creation."
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="division",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="The Division where the post exists.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="posts",
                to="core.Division",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="end_date",
            field=models.CharField(
                blank=True,
                help_text="An optional end date for the Post in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="extras",
            field=django.contrib.postgres.fields.jsonb.JSONField(
                blank=True,
                default=dict,
                help_text="A key-value store for storing arbitrary information not covered elsewhere.",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="label",
            field=models.CharField(
                help_text="A label describing the Post.", max_length=300
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="maximum_memberships",
            field=models.PositiveIntegerField(
                default=1,
                help_text="The maximum number of people who can hold this Post.",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="organization",
            field=models.ForeignKey(
                help_text="The Organization in which the post is held.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="posts",
                to="core.Organization",
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="role",
            field=models.CharField(
                blank=True,
                help_text="The function that the holder of the post fulfills.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="start_date",
            field=models.CharField(
                blank=True,
                help_text="An optional start date for the Post in YYYY[-MM[-DD]] string format.",
                max_length=10,
            ),
        ),
        migrations.AlterField(
            model_name="post",
            name="updated_at",
            field=models.DateTimeField(
                auto_now=True, help_text="The date and time of the last update."
            ),
        ),
        migrations.AlterField(
            model_name="postcontactdetail",
            name="label",
            field=models.CharField(
                blank=True,
                help_text="A title for the content of the Contact.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="postcontactdetail",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note about the Contact value.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="postcontactdetail",
            name="post",
            field=models.ForeignKey(
                help_text="A link to the Post connected to this contact.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="contact_details",
                to="core.Post",
            ),
        ),
        migrations.AlterField(
            model_name="postcontactdetail",
            name="type",
            field=models.CharField(
                choices=[
                    ("address", "Postal Address"),
                    ("email", "Email"),
                    ("url", "URL"),
                    ("fax", "Fax"),
                    ("text", "Text Phone"),
                    ("voice", "Voice Phone"),
                    ("video", "Video Phone"),
                    ("pager", "Pager"),
                    ("textphone", "Device for people with hearing impairment"),
                ],
                help_text="The type of Contact being defined.",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="postcontactdetail",
            name="value",
            field=models.CharField(
                help_text="The content of the Contact information like a phone number or email address.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="postlink",
            name="note",
            field=models.CharField(
                blank=True,
                help_text="A short, optional note related to an object.",
                max_length=300,
            ),
        ),
        migrations.AlterField(
            model_name="postlink",
            name="post",
            field=models.ForeignKey(
                help_text="A reference to the Post connected to this link.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="links",
                to="core.Post",
            ),
        ),
        migrations.AlterField(
            model_name="postlink",
            name="url",
            field=models.URLField(
                help_text="A hyperlink related to an object.", max_length=2000
            ),
        ),
    ]
