# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['spkpb', 'spkpb.speaker']

package_data = \
{'': ['*']}

install_requires = \
['mistool>=1.2.6-beta.0,<2.0.0', 'natsort>=7.1.1,<8.0.0']

setup_kwargs = {
    'name': 'spkpb',
    'version': '0.0.8b0',
    'description': 'A module to write programs which have to be verbose about a process on files and directories, and that have to emit informations, warnings and errors.',
    'long_description': 'The `Python` module `spkpb`\n===========================\n\n\n> **I beg your pardon for my english...**\n>\n> English is not my native language, so be nice if you notice misunderstandings, misspellings, or grammatical errors in my documents and codes.\n\n\nAbout `spkpb`\n-------------\n\nThis module proposes two classes that simplify the writing of programs which have to be verbose about a process on files and directories, and that have to emit informations, warnings and errors.\n\n  1. `Speaker`, the `spk` of `spkpb`, has methods tho print informations on a terminal and/or in a log file.\n  \n  1. `Problems`, the `pb` of `spkpb`, allows to indicate and store warnings, "criticals" and errors.\n\n\nThere is also a function `timestamp` to add time stamps in a log file without printing anything in the terminal.\n\n\nUsing directly the API - Default mode\n-------------------------------------\n\n### `Python` code\n\nLet\'s consider the following `Python` file where `Path` is a class proposed by the module `pathlib`. You have to know that the values of the arguments ``what`` are "stringified" (this allows to use either standard strings or advanced classes by defining your own ``__str__`` method for the resume output of problems if you need it).\n\n```python\nfrom spkpb import *\n\nspeaker = Speaker(\n    logfile = Path(\'mylog.log\')\n)\n\nproblems = Problems(speaker)\n\nproblems.new_warning(\n    what = Path(\'one/strange/file.txt\'),\n    info = "some strange behaviors."\n)\n\nproblems.new_error(\n    what = Path(\'one/bad/file.txt\'),\n    info = "bad things appear."\n)\n\nspeaker.recipe(\n    NL,\n    \'One basic showcase.\',\n    FORTERM,\n        {VAR_STEP_INFO: \'ONLY FOR THE TERMINAL OUPUT!\',\n         VAR_LEVEL    : 1},\n    FORLOG,\n        {VAR_STEP_INFO: \'ONLY IN THE LOG FILE!\',\n         VAR_LEVEL    : 1},\n)\n    \nproblems.resume()\n```\n\n### The terminal output\n\nLaunching our `Python` code from a terminal, we will see the following output.\n\n```\n1) [ #1 ] WARNING: some strange behaviors.\n2) [ #2 ] ERROR: bad things appear.\n\nOne basic showcase.\n    * ONLY FOR THE TERMINAL OUPUT!\n\n---------------\n1 WARNING FOUND\n---------------\n\nLook at the log file and/or above for details.\n\n    * "one/strange/file.txt"\n        + 1 warning.\n          See #.: [1].\n\n-------------\n1 ERROR FOUND\n-------------\n\nLook at the log file and/or above for details.\n\n    * "one/bad/file.txt"\n        + 1 error.\n          See #.: [2].\n```\n\n\n### The content of the log file `mylog.log`\n\nLaunching our `Python` code, `mylog.log` will have the following content (just note that the resume is more verbose than the one in a terminal).\n\n\n```\n1) [ #1 ] WARNING: some strange behaviors.\n2) [ #2 ] ERROR: bad things appear.\n\nOne basic showcase.\n    * ONLY IN THE LOG FILE!\n\n---------------\n1 WARNING FOUND\n---------------\n\n    * one/strange/file.txt\n        + See [ #.1 ] : some strange behaviors.\n\n-------------\n1 ERROR FOUND\n-------------\n\n    * one/bad/file.txt\n        + See [ #.2 ] : bad things appear.\n```\n\n\nUsing directly the API - Silent mode\n------------------------------------\n\nLet\'s modify a little our first code (the ellipsis indicate lines unchanged).\n\n```python\nfrom spkpb import *\n\nspeaker = Speaker(\n    logfile = Path(\'mylog.log\'),\n    silent  = True\n)\n\n...\n```\n\nThe use of the argument ``silent`` asks to prints only the summaries of problems (that is useful for short processes with no need to be verbose). The terminal and the log file will show the following same verbose resume.\n\n```\n---------------\n1 WARNING FOUND\n---------------\n\n    * one/strange/file.txt\n        + Some strange behaviors.\n\n-------------\n1 ERROR FOUND\n-------------\n\n    * one/bad/file.txt\n        + Bad things appear.\n```\n\n\nTime stamp in the log file\n--------------------------\n\nThe following code show how to use `timestamp` such as to add time stamps in the log file.\n\n```python\nfrom spkpb import *\n\nspeaker = Speaker(\n    logfile = Path(\'mylog.log\')\n)\n\ntimestamp(\n    speaker = speaker,\n    kind    = \'start 1\',\n)\n\ntimestamp(\n    speaker = speaker,\n    kind    = \'start 2\',\n    with_NL = False,\n)\n\ntimestamp(\n    speaker = speaker,\n    kind    = \'start 3\',\n)\n```\n\nThis will add the following lines in the log file `mylog.log` without printing anything in the terminal.\n\n```\n-----------------------------------------\nSTART 1 TIME STAMP: 2021-08-09 (00:40:02)\n-----------------------------------------\n\n-----------------------------------------\nSTART 2 TIME STAMP: 2021-08-09 (00:40:02)\n-----------------------------------------\n-----------------------------------------\nSTART 3 TIME STAMP: 2021-08-09 (00:40:02)\n-----------------------------------------\n\n```\n\n\nA ready-to-use communicating class\n----------------------------------\n\nWe have seen hard use of the API of `spkpb`. Indeed you can heritate the class `BaseCom` to do things easily: see the following code and outputs.\n\n\n### `Python` code\n\n~~~python\nfrom spkpb import *\n\nproject = BaseCom(\n    Problems(\n        Speaker(\n            logfile = Path(\'mylog.log\')\n        )\n    )\n)\n\nproject.timestamp(kind = \'start\')\n\nproject.new_warning(\n    what = Path(\'one/strange/file.txt\'),\n    info = "some strange behaviors."\n)\n\nprint(f\'>>>>>>>> sucess = {project.success}\')\n\nproject.new_error(\n    what = Path(\'one/bad/file.txt\'),\n    info = "bad things appear."\n)\n\nprint(f\'>>>>>>>> sucess = {project.success}\')\n\nproject.recipe(\n    NL,\n    \'One basic showcase.\',\n    FORTERM,\n        {VAR_STEP_INFO: \'ONLY FOR THE TERMINAL OUPUT!\',\n         VAR_LEVEL    : 1},\n    FORLOG,\n        {VAR_STEP_INFO: \'ONLY IN THE LOG FILE!\',\n         VAR_LEVEL    : 1},\n)\n    \nproject.resume()\n\nproject.recipe(NL)\nproject.timestamp(kind = \'end\')\n~~~\n\n\n### The terminal output\n\n~~~\n1) [ #1 ] WARNING: some strange behaviors.\n>>>>>>>> sucess = True\n2) [ #2 ] ERROR: bad things appear.\n>>>>>>>> sucess = False\n\nOne basic showcase.\n    * ONLY FOR THE TERMINAL OUPUT!\n\n---------------\n1 WARNING FOUND\n---------------\n\nLook at the log file or above for details.\n\n    * one/strange/file.txt\n        + 1 warning.\n          See #.: [1].\n\n-------------\n1 ERROR FOUND\n-------------\n\nLook at the log file or above for details.\n\n    * one/bad/file.txt\n        + 1 error.\n          See #.: [2].\n~~~\n\n\n### The content of the log file `mylog.log`\n\n~~~\n---------------------------------------\nSTART TIME STAMP: 2021-08-10 (11:40:02)\n---------------------------------------\n\n1) [ #1 ] WARNING: some strange behaviors.\n2) [ #2 ] ERROR: bad things appear.\n\nOne basic showcase.\n    * ONLY IN THE LOG FILE!\n\n---------------\n1 WARNING FOUND\n---------------\n\n    * one/strange/file.txt\n        + See [ #.1 ] : some strange behaviors.\n\n-------------\n1 ERROR FOUND\n-------------\n\n    * one/bad/file.txt\n        + See [ #.2 ] : bad things appear.\n\n-------------------------------------\nEND TIME STAMP: 2021-08-10 (11:40:02)\n-------------------------------------\n~~~\n\n\nReset the log file\n------------------\n\nThe classes `BaseCom`, `Problems` and `Speaker` all have a method `reset_logfile` to reset the log file. Here is a relly weird example of use even if the method is indeed very useful each time the communicating process restarts.\n\n~~~python\nfrom spkpb import *\n\nproject = BaseCom(\n    Problems(\n        Speaker(\n            logfile = Path(\'mylog.log\')\n        )\n    )\n)\n\nproject.new_warning(\n    what = Path(\'one/strange/file.txt\'),\n    info = "some strange behaviors."\n)\n\nproject.reset_logfile()\n\nproject.new_error(\n    what = Path(\'one/bad/file.txt\'),\n    info = "bad things appear."\n)\n~~~\n\n\nIn that case, the log file will be the following one with the 1st warning missing. Who has chosen this excellent example? :-)\n\n~~~\n2) [ #2 ] ERROR: bad things appear.\n~~~\n\n\n<!-- :tutorial-START: -->\n<!-- :tutorial-END: -->\n\n\n<!-- :version-START: -->\n<!-- :version-END: -->\n',
    'author': 'Christophe BAL',
    'author_email': None,
    'maintainer': 'Christophe BAL',
    'maintainer_email': None,
    'url': 'https://github.com/projetmbc/tools-for-dev/tree/master/spkpb',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
