import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [application-autoscaling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationautoscaling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ApplicationAutoscaling extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [application-autoscaling](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapplicationautoscaling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to delete a scaling policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScalingPolicy.html
     */
    toDeleteScalingPolicy(): this;
    /**
     * Grants permission to delete a scheduled action
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeleteScheduledAction.html
     */
    toDeleteScheduledAction(): this;
    /**
     * Grants permission to deregister a scalable target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DeregisterScalableTarget.html
     */
    toDeregisterScalableTarget(): this;
    /**
     * Grants permission to describe one or more scalable targets in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalableTargets.html
     */
    toDescribeScalableTargets(): this;
    /**
     * Grants permission to describe a set of scaling activities or all scaling activities in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingActivities.html
     */
    toDescribeScalingActivities(): this;
    /**
     * Grants permission to describe a set of scaling policies or all scaling policies in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScalingPolicies.html
     */
    toDescribeScalingPolicies(): this;
    /**
     * Grants permission to describe a set of scheduled actions or all scheduled actions in the specified namespace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_DescribeScheduledActions.html
     */
    toDescribeScheduledActions(): this;
    /**
     * Grants permission to list tags for a scalable target
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create and update a scaling policy for a scalable target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html
     */
    toPutScalingPolicy(): this;
    /**
     * Grants permission to create and update a scheduled action for a scalable target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScheduledAction.html
     */
    toPutScheduledAction(): this;
    /**
     * Grants permission to register AWS or custom resources as scalable targets with Application Auto Scaling and to update configuration parameters used to manage a scalable target
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifServiceNamespace()
     * - .ifScalableDimension()
     *
     * Dependent actions:
     * - application-autoscaling:TagResource
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     */
    toRegisterScalableTarget(): this;
    /**
     * Grants permission to tag a scalable target
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a scalable target
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/autoscaling/application/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ScalableTarget to the statement
     *
     * https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScalableTarget(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the scalable dimension that is passed in the request
     *
     * https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toDeleteScalingPolicy()
     * - .toDeleteScheduledAction()
     * - .toDeregisterScalableTarget()
     * - .toPutScalingPolicy()
     * - .toPutScheduledAction()
     * - .toRegisterScalableTarget()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifScalableDimension(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the service namespace that is passed in the request
     *
     * https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toDeleteScalingPolicy()
     * - .toDeleteScheduledAction()
     * - .toDeregisterScalableTarget()
     * - .toPutScalingPolicy()
     * - .toPutScheduledAction()
     * - .toRegisterScalableTarget()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifServiceNamespace(value: string | string[], operator?: Operator | string): this;
}
