import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitouserpools.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CognitoIdp extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncognitouserpools.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to add user attributes to the user pool schema
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AddCustomAttributes.html
     */
    toAddCustomAttributes(): this;
    /**
     * Grants permission to add any user to any group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminAddUserToGroup.html
     */
    toAdminAddUserToGroup(): this;
    /**
     * Grants permission to confirm any user's registration without a confirmation code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminConfirmSignUp.html
     */
    toAdminConfirmSignUp(): this;
    /**
     * Grants permission to create new users and send welcome messages via email or SMS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html
     */
    toAdminCreateUser(): this;
    /**
     * Grants permission to delete any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUser.html
     */
    toAdminDeleteUser(): this;
    /**
     * Grants permission to delete attributes from any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUserAttributes.html
     */
    toAdminDeleteUserAttributes(): this;
    /**
     * Grants permission to unlink any user pool user from a third-party identity provider (IdP) user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableProviderForUser.html
     */
    toAdminDisableProviderForUser(): this;
    /**
     * Grants permission to deactivate any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableUser.html
     */
    toAdminDisableUser(): this;
    /**
     * Grants permission to activate any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminEnableUser.html
     */
    toAdminEnableUser(): this;
    /**
     * Grants permission to deregister any user's devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminForgetDevice.html
     */
    toAdminForgetDevice(): this;
    /**
     * Grants permission to get information about any user's devices
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetDevice.html
     */
    toAdminGetDevice(): this;
    /**
     * Grants permission to look up any user by user name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetUser.html
     */
    toAdminGetUser(): this;
    /**
     * Grants permission to authenticate any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html
     */
    toAdminInitiateAuth(): this;
    /**
     * Grants permission to link any user pool user to a third-party IdP user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html
     */
    toAdminLinkProviderForUser(): this;
    /**
     * Grants permission to list any user's remembered devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListDevices.html
     */
    toAdminListDevices(): this;
    /**
     * Grants permission to list the groups that any user belongs to
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListGroupsForUser.html
     */
    toAdminListGroupsForUser(): this;
    /**
     * Grants permission to lists sign-in events for any user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListUserAuthEvents.html
     */
    toAdminListUserAuthEvents(): this;
    /**
     * Grants permission to remove any user from any group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRemoveUserFromGroup.html
     */
    toAdminRemoveUserFromGroup(): this;
    /**
     * Grants permission to reset any user's password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminResetUserPassword.html
     */
    toAdminResetUserPassword(): this;
    /**
     * Grants permission to respond to an authentication challenge during the authentication of any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRespondToAuthChallenge.html
     */
    toAdminRespondToAuthChallenge(): this;
    /**
     * Grants permission to set any user's preferred MFA method
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html
     */
    toAdminSetUserMFAPreference(): this;
    /**
     * Grants permission to set any user's password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html
     */
    toAdminSetUserPassword(): this;
    /**
     * Grants permission to set user settings for any user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserSettings.html
     */
    toAdminSetUserSettings(): this;
    /**
     * Grants permission to update advanced security feedback for any user's authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateAuthEventFeedback.html
     */
    toAdminUpdateAuthEventFeedback(): this;
    /**
     * Grants permission to update the status of any user's remembered devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateDeviceStatus.html
     */
    toAdminUpdateDeviceStatus(): this;
    /**
     * Grants permission to updates any user's standard or custom attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html
     */
    toAdminUpdateUserAttributes(): this;
    /**
     * Grants permission to sign out any user from all sessions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUserGlobalSignOut.html
     */
    toAdminUserGlobalSignOut(): this;
    /**
     * Returns a unique generated shared secret key code for the user account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html
     */
    toAssociateSoftwareToken(): this;
    /**
     * Grants permission to associate the user pool with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toAssociateWebACL(): this;
    /**
     * Changes the password for a specified user in a user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ChangePassword.html
     */
    toChangePassword(): this;
    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html
     */
    toConfirmDevice(): this;
    /**
     * Allows a user to enter a confirmation code to reset a forgotten password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html
     */
    toConfirmForgotPassword(): this;
    /**
     * Confirms registration of a user and handles the existing alias from a previous user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmSignUp.html
     */
    toConfirmSignUp(): this;
    /**
     * Grants permission to create new user pool groups
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup(): this;
    /**
     * Grants permission to add identity providers to user pools
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html
     */
    toCreateIdentityProvider(): this;
    /**
     * Grants permission to create and configure scopes for OAuth 2.0 resource servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateResourceServer.html
     */
    toCreateResourceServer(): this;
    /**
     * Grants permission to create user CSV import jobs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserImportJob.html
     */
    toCreateUserImportJob(): this;
    /**
     * Grants permission to create and set password policy for user pools
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html
     */
    toCreateUserPool(): this;
    /**
     * Grants permission to create user pool app clients
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolClient.html
     */
    toCreateUserPoolClient(): this;
    /**
     * Grants permission to add user pool domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolDomain.html
     */
    toCreateUserPoolDomain(): this;
    /**
     * Grants permission to delete any empty user pool group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup(): this;
    /**
     * Grants permission to delete any identity provider from user pools
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteIdentityProvider.html
     */
    toDeleteIdentityProvider(): this;
    /**
     * Grants permission to delete any OAuth 2.0 resource server from user pools
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteResourceServer.html
     */
    toDeleteResourceServer(): this;
    /**
     * Allows a user to delete one's self
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser(): this;
    /**
     * Deletes the attributes for a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserAttributes.html
     */
    toDeleteUserAttributes(): this;
    /**
     * Grants permission to delete user pools
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPool.html
     */
    toDeleteUserPool(): this;
    /**
     * Grants permission to delete any user pool app client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolClient.html
     */
    toDeleteUserPoolClient(): this;
    /**
     * Grants permission to delete any user pool domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolDomain.html
     */
    toDeleteUserPoolDomain(): this;
    /**
     * Grants permission to describe any user pool identity provider
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeIdentityProvider.html
     */
    toDescribeIdentityProvider(): this;
    /**
     * Grants permission to describe any OAuth 2.0 resource server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeResourceServer.html
     */
    toDescribeResourceServer(): this;
    /**
     * Grants permission to describe the risk configuration settings of user pools and app clients
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeRiskConfiguration.html
     */
    toDescribeRiskConfiguration(): this;
    /**
     * Grants permission to describe any user import job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserImportJob.html
     */
    toDescribeUserImportJob(): this;
    /**
     * Grants permission to describe user pools
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html
     */
    toDescribeUserPool(): this;
    /**
     * Grants permission to describe any user pool app client
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html
     */
    toDescribeUserPoolClient(): this;
    /**
     * Grants permission to describe any user pool domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolDomain.html
     */
    toDescribeUserPoolDomain(): this;
    /**
     * Grants permission to disassociate the user pool with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toDisassociateWebACL(): this;
    /**
     * Forgets the specified device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgetDevice.html
     */
    toForgetDevice(): this;
    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html
     */
    toForgotPassword(): this;
    /**
     * Grants permission to generate headers for a user import .csv file
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetCSVHeader.html
     */
    toGetCSVHeader(): this;
    /**
     * Gets the device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetDevice.html
     */
    toGetDevice(): this;
    /**
     * Grants permission to describe a user pool group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetGroup.html
     */
    toGetGroup(): this;
    /**
     * Grants permission to correlate a user pool IdP identifier to the IdP Name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetIdentityProviderByIdentifier.html
     */
    toGetIdentityProviderByIdentifier(): this;
    /**
     * Grants permission to look up signing certificates for user pools
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetSigningCertificate.html
     */
    toGetSigningCertificate(): this;
    /**
     * Grants permission to get UI customization information for the hosted UI of any app client
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUICustomization.html
     */
    toGetUICustomization(): this;
    /**
     * Gets the user attributes and metadata for a user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html
     */
    toGetUser(): this;
    /**
     * Gets the user attribute verification code for the specified attribute name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserAttributeVerificationCode.html
     */
    toGetUserAttributeVerificationCode(): this;
    /**
     * Grants permission to look up the MFA configuration of user pools
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserPoolMfaConfig.html
     */
    toGetUserPoolMfaConfig(): this;
    /**
     * Grants permission to get the AWS WAF web ACL that is associated with an Amazon Cognito user pool
     *
     * Access Level: Read
     */
    toGetWebACLForResource(): this;
    /**
     * Signs out users from all devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GlobalSignOut.html
     */
    toGlobalSignOut(): this;
    /**
     * Initiates the authentication flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html
     */
    toInitiateAuth(): this;
    /**
     * Lists the devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListDevices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to list all groups in user pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListGroups.html
     */
    toListGroups(): this;
    /**
     * Grants permission to list all identity providers in user pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListIdentityProviders.html
     */
    toListIdentityProviders(): this;
    /**
     * Grants permission to list all resource servers in user pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListResourceServers.html
     */
    toListResourceServers(): this;
    /**
     * Grants permission to list the user pools that are associated with an AWS WAF web ACL
     *
     * Access Level: List
     */
    toListResourcesForWebACL(): this;
    /**
     * Grants permission to list the tags that are assigned to an Amazon Cognito user pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all user import jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserImportJobs.html
     */
    toListUserImportJobs(): this;
    /**
     * Grants permission to list all app clients in user pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPoolClients.html
     */
    toListUserPoolClients(): this;
    /**
     * Grants permission to list all user pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPools.html
     */
    toListUserPools(): this;
    /**
     * Grants permission to list all user pool users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsers.html
     */
    toListUsers(): this;
    /**
     * Grants permission to list the users in any group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsersInGroup.html
     */
    toListUsersInGroup(): this;
    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ResendConfirmationCode.html
     */
    toResendConfirmationCode(): this;
    /**
     * Responds to the authentication challenge
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RespondToAuthChallenge.html
     */
    toRespondToAuthChallenge(): this;
    /**
     * Revokes all of the access tokens generated by the specified refresh token
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html
     */
    toRevokeToken(): this;
    /**
     * Grants permission to set risk configuration for user pools and app clients
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetRiskConfiguration.html
     */
    toSetRiskConfiguration(): this;
    /**
     * Grants permission to customize the hosted UI for any app client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUICustomization.html
     */
    toSetUICustomization(): this;
    /**
     * Sets MFA preference for the user in the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html
     */
    toSetUserMFAPreference(): this;
    /**
     * Grants permission to set user pool MFA configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html
     */
    toSetUserPoolMfaConfig(): this;
    /**
     * Sets the user settings like multi-factor authentication (MFA)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserSettings.html
     */
    toSetUserSettings(): this;
    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html
     */
    toSignUp(): this;
    /**
     * Grants permission to start any user import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StartUserImportJob.html
     */
    toStartUserImportJob(): this;
    /**
     * Grants permission to stop any user import job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StopUserImportJob.html
     */
    toStopUserImportJob(): this;
    /**
     * Grants permission to tag a user pool
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a user pool
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Updates the feedback for the user authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateAuthEventFeedback.html
     */
    toUpdateAuthEventFeedback(): this;
    /**
     * Updates the device status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html
     */
    toUpdateDeviceStatus(): this;
    /**
     * Grants permission to update the configuration of any group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateGroup.html
     */
    toUpdateGroup(): this;
    /**
     * Grants permission to update the configuration of any user pool IdP
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateIdentityProvider.html
     */
    toUpdateIdentityProvider(): this;
    /**
     * Grants permission to update the configuration of any OAuth 2.0 resource server
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateResourceServer.html
     */
    toUpdateResourceServer(): this;
    /**
     * Allows a user to update a specific attribute (one at a time)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html
     */
    toUpdateUserAttributes(): this;
    /**
     * Grants permission to updates the configuration of user pools
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html
     */
    toUpdateUserPool(): this;
    /**
     * Grants permission to update any user pool client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolClient.html
     */
    toUpdateUserPoolClient(): this;
    /**
     * Grants permission to replace the certificate for any custom domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolDomain.html
     */
    toUpdateUserPoolDomain(): this;
    /**
     * Registers a user's entered TOTP code and mark the user's software token MFA status as verified if successful
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html
     */
    toVerifySoftwareToken(): this;
    /**
     * Verifies a user attribute using a one time verification code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html
     */
    toVerifyUserAttribute(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type userpool to the statement
     *
     * https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html
     *
     * @param userPoolId - Identifier for the userPoolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUserpool(userPoolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type webacl to the statement
     *
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-waf.html
     *
     * @param scope - Identifier for the scope.
     * @param name - Identifier for the name.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWebacl(scope: string, name: string, id: string, account?: string, region?: string, partition?: string): this;
}
