"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Geo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Geo extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [geo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'geo';
        this.accessLevelList = {
            Write: [
                'AssociateTrackerConsumer',
                'BatchDeleteDevicePositionHistory',
                'BatchDeleteGeofence',
                'BatchEvaluateGeofences',
                'BatchPutGeofence',
                'BatchUpdateDevicePosition',
                'CreateGeofenceCollection',
                'CreateKey',
                'CreateMap',
                'CreatePlaceIndex',
                'CreateRouteCalculator',
                'CreateTracker',
                'DeleteGeofenceCollection',
                'DeleteKey',
                'DeleteMap',
                'DeletePlaceIndex',
                'DeleteRouteCalculator',
                'DeleteTracker',
                'DisassociateTrackerConsumer',
                'PutGeofence',
                'UpdateGeofenceCollection',
                'UpdateKey',
                'UpdateMap',
                'UpdatePlaceIndex',
                'UpdateRouteCalculator',
                'UpdateTracker'
            ],
            Read: [
                'BatchGetDevicePosition',
                'CalculateRoute',
                'CalculateRouteMatrix',
                'DescribeGeofenceCollection',
                'DescribeKey',
                'DescribeMap',
                'DescribePlaceIndex',
                'DescribeRouteCalculator',
                'DescribeTracker',
                'GetDevicePosition',
                'GetDevicePositionHistory',
                'GetGeofence',
                'GetMapGlyphs',
                'GetMapSprites',
                'GetMapStyleDescriptor',
                'GetMapTile',
                'GetPlace',
                'ListDevicePositions',
                'ListGeofences',
                'ListTagsForResource',
                'ListTrackerConsumers',
                'SearchPlaceIndexForPosition',
                'SearchPlaceIndexForSuggestions',
                'SearchPlaceIndexForText'
            ],
            List: [
                'ListGeofenceCollections',
                'ListKeys',
                'ListMaps',
                'ListPlaceIndexes',
                'ListRouteCalculators',
                'ListTrackers'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create an association between a geofence-collection and a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_AssociateTrackerConsumer.html
     */
    toAssociateTrackerConsumer() {
        return this.to('AssociateTrackerConsumer');
    }
    /**
     * Grants permission to delete a batch of device position histories from a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchDeleteDevicePositionHistory.html
     */
    toBatchDeleteDevicePositionHistory() {
        return this.to('BatchDeleteDevicePositionHistory');
    }
    /**
     * Grants permission to delete a batch of geofences from a geofence collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchDeleteGeofence.html
     */
    toBatchDeleteGeofence() {
        return this.to('BatchDeleteGeofence');
    }
    /**
     * Grants permission to evaluate device positions against the position of geofences in a given geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchEvaluateGeofences.html
     */
    toBatchEvaluateGeofences() {
        return this.to('BatchEvaluateGeofences');
    }
    /**
     * Grants permission to send a batch request to retrieve device positions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchGetDevicePosition.html
     */
    toBatchGetDevicePosition() {
        return this.to('BatchGetDevicePosition');
    }
    /**
     * Grants permission to send a batch request for adding geofences into a given geofence collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchPutGeofence.html
     */
    toBatchPutGeofence() {
        return this.to('BatchPutGeofence');
    }
    /**
     * Grants permission to upload a position update for one or more devices to a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_BatchUpdateDevicePosition.html
     */
    toBatchUpdateDevicePosition() {
        return this.to('BatchUpdateDevicePosition');
    }
    /**
     * Grants permission to calculate routes using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRoute.html
     */
    toCalculateRoute() {
        return this.to('CalculateRoute');
    }
    /**
     * Grants permission to calculate a route matrix using a given route calculator resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CalculateRouteMatrix.html
     */
    toCalculateRouteMatrix() {
        return this.to('CalculateRouteMatrix');
    }
    /**
     * Grants permission to create a geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateGeofenceCollection.html
     */
    toCreateGeofenceCollection() {
        return this.to('CreateGeofenceCollection');
    }
    /**
     * Grants permission to create an API key resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateKey.html
     */
    toCreateKey() {
        return this.to('CreateKey');
    }
    /**
     * Grants permission to create a map resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html
     */
    toCreateMap() {
        return this.to('CreateMap');
    }
    /**
     * Grants permission to create a place index resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreatePlaceIndex.html
     */
    toCreatePlaceIndex() {
        return this.to('CreatePlaceIndex');
    }
    /**
     * Grants permission to create a route calculator resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateRouteCalculator.html
     */
    toCreateRouteCalculator() {
        return this.to('CreateRouteCalculator');
    }
    /**
     * Grants permission to create a tracker resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_CreateTracker.html
     */
    toCreateTracker() {
        return this.to('CreateTracker');
    }
    /**
     * Grants permission to delete a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteGeofenceCollection.html
     */
    toDeleteGeofenceCollection() {
        return this.to('DeleteGeofenceCollection');
    }
    /**
     * Grants permission to delete an API key resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteKey.html
     */
    toDeleteKey() {
        return this.to('DeleteKey');
    }
    /**
     * Grants permission to delete a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteMap.html
     */
    toDeleteMap() {
        return this.to('DeleteMap');
    }
    /**
     * Grants permission to delete a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeletePlaceIndex.html
     */
    toDeletePlaceIndex() {
        return this.to('DeletePlaceIndex');
    }
    /**
     * Grants permission to delete a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteRouteCalculator.html
     */
    toDeleteRouteCalculator() {
        return this.to('DeleteRouteCalculator');
    }
    /**
     * Grants permission to delete a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DeleteTracker.html
     */
    toDeleteTracker() {
        return this.to('DeleteTracker');
    }
    /**
     * Grants permission to retrieve geofence collection details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeGeofenceCollection.html
     */
    toDescribeGeofenceCollection() {
        return this.to('DescribeGeofenceCollection');
    }
    /**
     * Grants permission to retrieve API key resource details and secret
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeKey.html
     */
    toDescribeKey() {
        return this.to('DescribeKey');
    }
    /**
     * Grants permission to retrieve map resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeMap.html
     */
    toDescribeMap() {
        return this.to('DescribeMap');
    }
    /**
     * Grants permission to retrieve place-index resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribePlaceIndex.html
     */
    toDescribePlaceIndex() {
        return this.to('DescribePlaceIndex');
    }
    /**
     * Grants permission to retrieve route calculator resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeRouteCalculator.html
     */
    toDescribeRouteCalculator() {
        return this.to('DescribeRouteCalculator');
    }
    /**
     * Grants permission to retrieve a tracker resource details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DescribeTracker.html
     */
    toDescribeTracker() {
        return this.to('DescribeTracker');
    }
    /**
     * Grants permission to remove the association between a tracker resource and a geofence-collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_DisassociateTrackerConsumer.html
     */
    toDisassociateTrackerConsumer() {
        return this.to('DisassociateTrackerConsumer');
    }
    /**
     * Grants permission to retrieve the latest device position
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetDevicePosition.html
     */
    toGetDevicePosition() {
        return this.to('GetDevicePosition');
    }
    /**
     * Grants permission to retrieve the device position history
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifDeviceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetDevicePositionHistory.html
     */
    toGetDevicePositionHistory() {
        return this.to('GetDevicePositionHistory');
    }
    /**
     * Grants permission to retrieve the geofence details from a geofence-collection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetGeofence.html
     */
    toGetGeofence() {
        return this.to('GetGeofence');
    }
    /**
     * Grants permission to retrieve the glyph file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapGlyphs.html
     */
    toGetMapGlyphs() {
        return this.to('GetMapGlyphs');
    }
    /**
     * Grants permission to retrieve the sprite file for a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapSprites.html
     */
    toGetMapSprites() {
        return this.to('GetMapSprites');
    }
    /**
     * Grants permission to retrieve the map style descriptor from a map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapStyleDescriptor.html
     */
    toGetMapStyleDescriptor() {
        return this.to('GetMapStyleDescriptor');
    }
    /**
     * Grants permission to retrieve the map tile from the map resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetMapTile.html
     */
    toGetMapTile() {
        return this.to('GetMapTile');
    }
    /**
     * Grants permission to find a place by its unique ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_GetPlace.html
     */
    toGetPlace() {
        return this.to('GetPlace');
    }
    /**
     * Grants permission to retrieve a list of devices and their latest positions from the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListDevicePositions.html
     */
    toListDevicePositions() {
        return this.to('ListDevicePositions');
    }
    /**
     * Grants permission to lists geofence-collections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListGeofenceCollections.html
     */
    toListGeofenceCollections() {
        return this.to('ListGeofenceCollections');
    }
    /**
     * Grants permission to list geofences stored in a given geofence collection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListGeofences.html
     */
    toListGeofences() {
        return this.to('ListGeofences');
    }
    /**
     * Grants permission to list API key resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListKeys.html
     */
    toListKeys() {
        return this.to('ListKeys');
    }
    /**
     * Grants permission to list map resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListMaps.html
     */
    toListMaps() {
        return this.to('ListMaps');
    }
    /**
     * Grants permission to return a list of place index resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListPlaceIndexes.html
     */
    toListPlaceIndexes() {
        return this.to('ListPlaceIndexes');
    }
    /**
     * Grants permission to return a list of route calculator resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListRouteCalculators.html
     */
    toListRouteCalculators() {
        return this.to('ListRouteCalculators');
    }
    /**
     * Grants permission to list the tags (metadata) which you have assigned to the resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to retrieve a list of geofence collections currently associated to the given tracker resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTrackerConsumers.html
     */
    toListTrackerConsumers() {
        return this.to('ListTrackerConsumers');
    }
    /**
     * Grants permission to return a list of tracker resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_ListTrackers.html
     */
    toListTrackers() {
        return this.to('ListTrackers');
    }
    /**
     * Grants permission to add a new geofence or update an existing geofence to a given geofence-collection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifGeofenceIds()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_PutGeofence.html
     */
    toPutGeofence() {
        return this.to('PutGeofence');
    }
    /**
     * Grants permission to reverse geocodes a given coordinate
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForPosition.html
     */
    toSearchPlaceIndexForPosition() {
        return this.to('SearchPlaceIndexForPosition');
    }
    /**
     * Grants permission to generate suggestions for addresses and points of interest based on partial or misspelled free-form text
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForSuggestions.html
     */
    toSearchPlaceIndexForSuggestions() {
        return this.to('SearchPlaceIndexForSuggestions');
    }
    /**
     * Grants permission to geocode free-form text, such as an address, name, city or region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_SearchPlaceIndexForText.html
     */
    toSearchPlaceIndexForText() {
        return this.to('SearchPlaceIndexForText');
    }
    /**
     * Grants permission to adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the given tags (metadata) from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a geofence collection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateGeofenceCollection.html
     */
    toUpdateGeofenceCollection() {
        return this.to('UpdateGeofenceCollection');
    }
    /**
     * Grants permission to update an API key resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateKey.html
     */
    toUpdateKey() {
        return this.to('UpdateKey');
    }
    /**
     * Grants permission to update a map resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateMap.html
     */
    toUpdateMap() {
        return this.to('UpdateMap');
    }
    /**
     * Grants permission to update a place index resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdatePlaceIndex.html
     */
    toUpdatePlaceIndex() {
        return this.to('UpdatePlaceIndex');
    }
    /**
     * Grants permission to update a route calculator resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateRouteCalculator.html
     */
    toUpdateRouteCalculator() {
        return this.to('UpdateRouteCalculator');
    }
    /**
     * Grants permission to update a tracker resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/location/latest/APIReference/API_UpdateTracker.html
     */
    toUpdateTracker() {
        return this.to('UpdateTracker');
    }
    /**
     * Adds a resource of type api-key to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html
     *
     * @param keyName - Identifier for the keyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApiKey(keyName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:api-key/${keyName}`);
    }
    /**
     * Adds a resource of type geofence-collection to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html
     *
     * @param geofenceCollectionName - Identifier for the geofenceCollectionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifGeofenceIds()
     */
    onGeofenceCollection(geofenceCollectionName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:geofence-collection/${geofenceCollectionName}`);
    }
    /**
     * Adds a resource of type map to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html
     *
     * @param mapName - Identifier for the mapName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMap(mapName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:map/${mapName}`);
    }
    /**
     * Adds a resource of type place-index to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaceIndex(indexName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:place-index/${indexName}`);
    }
    /**
     * Adds a resource of type route-calculator to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/route-concepts.html
     *
     * @param calculatorName - Identifier for the calculatorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRouteCalculator(calculatorName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:route-calculator/${calculatorName}`);
    }
    /**
     * Adds a resource of type tracker to the statement
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html
     *
     * @param trackerName - Identifier for the trackerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifDeviceIds()
     */
    onTracker(trackerName, account, region, partition) {
        return this.on(`arn:${partition || Geo.defaultPartition}:geo:${region || '*'}:${account || '*'}:tracker/${trackerName}`);
    }
    /**
     * Filters access by the presence of device ids in the request
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toBatchDeleteDevicePositionHistory()
     * - .toBatchGetDevicePosition()
     * - .toBatchUpdateDevicePosition()
     * - .toGetDevicePosition()
     * - .toGetDevicePositionHistory()
     *
     * Applies to resource types:
     * - tracker
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDeviceIds(value, operator) {
        return this.if(`DeviceIds`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the presence of geofence ids in the request
     *
     * https://docs.aws.amazon.com/location/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toBatchDeleteGeofence()
     * - .toBatchPutGeofence()
     * - .toGetGeofence()
     * - .toPutGeofence()
     *
     * Applies to resource types:
     * - geofence-collection
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifGeofenceIds(value, operator) {
        return this.if(`GeofenceIds`, value, operator || 'StringLike');
    }
}
exports.Geo = Geo;
_a = JSII_RTTI_SYMBOL_1;
Geo[_a] = { fqn: "iam-floyd.Geo", version: "0.504.0" };
//# sourceMappingURL=data:application/json;base64,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