"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Proton = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [proton](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Proton extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [proton](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'proton';
        this.accessLevelList = {
            Write: [
                'AcceptEnvironmentAccountConnection',
                'CancelComponentDeployment',
                'CancelEnvironmentDeployment',
                'CancelServiceInstanceDeployment',
                'CancelServicePipelineDeployment',
                'CreateComponent',
                'CreateEnvironment',
                'CreateEnvironmentAccountConnection',
                'CreateEnvironmentTemplate',
                'CreateEnvironmentTemplateMajorVersion',
                'CreateEnvironmentTemplateMinorVersion',
                'CreateEnvironmentTemplateVersion',
                'CreateRepository',
                'CreateService',
                'CreateServiceInstance',
                'CreateServiceSyncConfig',
                'CreateServiceTemplate',
                'CreateServiceTemplateMajorVersion',
                'CreateServiceTemplateMinorVersion',
                'CreateServiceTemplateVersion',
                'CreateTemplateSyncConfig',
                'DeleteAccountRoles',
                'DeleteComponent',
                'DeleteEnvironment',
                'DeleteEnvironmentAccountConnection',
                'DeleteEnvironmentTemplate',
                'DeleteEnvironmentTemplateMajorVersion',
                'DeleteEnvironmentTemplateMinorVersion',
                'DeleteEnvironmentTemplateVersion',
                'DeleteRepository',
                'DeleteService',
                'DeleteServiceSyncConfig',
                'DeleteServiceTemplate',
                'DeleteServiceTemplateMajorVersion',
                'DeleteServiceTemplateMinorVersion',
                'DeleteServiceTemplateVersion',
                'DeleteTemplateSyncConfig',
                'NotifyResourceDeploymentStatusChange',
                'RejectEnvironmentAccountConnection',
                'UpdateAccountRoles',
                'UpdateAccountSettings',
                'UpdateComponent',
                'UpdateEnvironment',
                'UpdateEnvironmentAccountConnection',
                'UpdateEnvironmentTemplate',
                'UpdateEnvironmentTemplateMajorVersion',
                'UpdateEnvironmentTemplateMinorVersion',
                'UpdateEnvironmentTemplateVersion',
                'UpdateService',
                'UpdateServiceInstance',
                'UpdateServicePipeline',
                'UpdateServiceSyncBlocker',
                'UpdateServiceSyncConfig',
                'UpdateServiceTemplate',
                'UpdateServiceTemplateMajorVersion',
                'UpdateServiceTemplateMinorVersion',
                'UpdateServiceTemplateVersion',
                'UpdateTemplateSyncConfig'
            ],
            Read: [
                'GetAccountRoles',
                'GetAccountSettings',
                'GetComponent',
                'GetEnvironment',
                'GetEnvironmentAccountConnection',
                'GetEnvironmentTemplate',
                'GetEnvironmentTemplateMajorVersion',
                'GetEnvironmentTemplateMinorVersion',
                'GetEnvironmentTemplateVersion',
                'GetRepository',
                'GetRepositorySyncStatus',
                'GetResourceTemplateVersionStatusCounts',
                'GetResourcesSummary',
                'GetService',
                'GetServiceInstance',
                'GetServiceInstanceSyncStatus',
                'GetServiceSyncBlockerSummary',
                'GetServiceSyncConfig',
                'GetServiceTemplate',
                'GetServiceTemplateMajorVersion',
                'GetServiceTemplateMinorVersion',
                'GetServiceTemplateVersion',
                'GetTemplateSyncConfig',
                'GetTemplateSyncStatus',
                'ListTagsForResource'
            ],
            List: [
                'ListComponentOutputs',
                'ListComponentProvisionedResources',
                'ListComponents',
                'ListEnvironmentAccountConnections',
                'ListEnvironmentOutputs',
                'ListEnvironmentProvisionedResources',
                'ListEnvironmentTemplateMajorVersions',
                'ListEnvironmentTemplateMinorVersions',
                'ListEnvironmentTemplateVersions',
                'ListEnvironmentTemplates',
                'ListEnvironments',
                'ListRepositories',
                'ListRepositorySyncDefinitions',
                'ListServiceInstanceOutputs',
                'ListServiceInstanceProvisionedResources',
                'ListServiceInstances',
                'ListServicePipelineOutputs',
                'ListServicePipelineProvisionedResources',
                'ListServiceTemplateMajorVersions',
                'ListServiceTemplateMinorVersions',
                'ListServiceTemplateVersions',
                'ListServiceTemplates',
                'ListServices'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to reject an environment account connection request from another environment account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_AcceptEnvironmentAccountConnection.html
     */
    toAcceptEnvironmentAccountConnection() {
        return this.to('AcceptEnvironmentAccountConnection');
    }
    /**
     * Grants permission to cancel component deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelComponentDeployment.html
     */
    toCancelComponentDeployment() {
        return this.to('CancelComponentDeployment');
    }
    /**
     * Grants permission to cancel an environment deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelEnvironmentDeployment.html
     */
    toCancelEnvironmentDeployment() {
        return this.to('CancelEnvironmentDeployment');
    }
    /**
     * Grants permission to cancel a service instance deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServiceInstanceDeployment.html
     */
    toCancelServiceInstanceDeployment() {
        return this.to('CancelServiceInstanceDeployment');
    }
    /**
     * Grants permission to cancel a service pipeline deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServicePipelineDeployment.html
     */
    toCancelServicePipelineDeployment() {
        return this.to('CancelServicePipelineDeployment');
    }
    /**
     * Grants permission to create component
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateComponent.html
     */
    toCreateComponent() {
        return this.to('CreateComponent');
    }
    /**
     * Grants permission to create an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifEnvironmentTemplate()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironment.html
     */
    toCreateEnvironment() {
        return this.to('CreateEnvironment');
    }
    /**
     * Grants permission to create an environment account connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentAccountConnection.html
     */
    toCreateEnvironmentAccountConnection() {
        return this.to('CreateEnvironmentAccountConnection');
    }
    /**
     * Grants permission to create an environment template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplate.html
     */
    toCreateEnvironmentTemplate() {
        return this.to('CreateEnvironmentTemplate');
    }
    /**
     * Grants permission to create an environment template major version. DEPRECATED - use CreateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMajorVersion.html
     */
    toCreateEnvironmentTemplateMajorVersion() {
        return this.to('CreateEnvironmentTemplateMajorVersion');
    }
    /**
     * Grants permission to create an environment template minor version. DEPRECATED - use CreateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMinorVersion.html
     */
    toCreateEnvironmentTemplateMinorVersion() {
        return this.to('CreateEnvironmentTemplateMinorVersion');
    }
    /**
     * Grants permission to create an environment template version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateVersion.html
     */
    toCreateEnvironmentTemplateVersion() {
        return this.to('CreateEnvironmentTemplateVersion');
    }
    /**
     * Grants permission to create a repository
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateRepository.html
     */
    toCreateRepository() {
        return this.to('CreateRepository');
    }
    /**
     * Grants permission to create a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifServiceTemplate()
     *
     * Dependent actions:
     * - codestar-connections:PassConnection
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateService.html
     */
    toCreateService() {
        return this.to('CreateService');
    }
    /**
     * Grants permission to create a service instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceInstance.html
     */
    toCreateServiceInstance() {
        return this.to('CreateServiceInstance');
    }
    /**
     * Grants permission to create a service sync config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceSyncConfig.html
     */
    toCreateServiceSyncConfig() {
        return this.to('CreateServiceSyncConfig');
    }
    /**
     * Grants permission to create a service template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplate.html
     */
    toCreateServiceTemplate() {
        return this.to('CreateServiceTemplate');
    }
    /**
     * Grants permission to create a service template major version. DEPRECATED - use CreateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMajorVersion.html
     */
    toCreateServiceTemplateMajorVersion() {
        return this.to('CreateServiceTemplateMajorVersion');
    }
    /**
     * Grants permission to create a service template minor version. DEPRECATED - use CreateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMinorVersion.html
     */
    toCreateServiceTemplateMinorVersion() {
        return this.to('CreateServiceTemplateMinorVersion');
    }
    /**
     * Grants permission to create a service template version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateVersion.html
     */
    toCreateServiceTemplateVersion() {
        return this.to('CreateServiceTemplateVersion');
    }
    /**
     * Grants permission to create a template sync config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateTemplateSyncConfig.html
     */
    toCreateTemplateSyncConfig() {
        return this.to('CreateTemplateSyncConfig');
    }
    /**
     * Grants permission to delete account roles. DEPRECATED - use UpdateAccountSettings instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteAccountRoles.html
     */
    toDeleteAccountRoles() {
        return this.to('DeleteAccountRoles');
    }
    /**
     * Grants permission to delete component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteComponent.html
     */
    toDeleteComponent() {
        return this.to('DeleteComponent');
    }
    /**
     * Grants permission to delete an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironment.html
     */
    toDeleteEnvironment() {
        return this.to('DeleteEnvironment');
    }
    /**
     * Grants permission to delete an environment account connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentAccountConnection.html
     */
    toDeleteEnvironmentAccountConnection() {
        return this.to('DeleteEnvironmentAccountConnection');
    }
    /**
     * Grants permission to delete an environment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplate.html
     */
    toDeleteEnvironmentTemplate() {
        return this.to('DeleteEnvironmentTemplate');
    }
    /**
     * Grants permission to delete an environment template major version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMajorVersion.html
     */
    toDeleteEnvironmentTemplateMajorVersion() {
        return this.to('DeleteEnvironmentTemplateMajorVersion');
    }
    /**
     * Grants permission to delete an environment template minor version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMinorVersion.html
     */
    toDeleteEnvironmentTemplateMinorVersion() {
        return this.to('DeleteEnvironmentTemplateMinorVersion');
    }
    /**
     * Grants permission to delete an environment template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateVersion.html
     */
    toDeleteEnvironmentTemplateVersion() {
        return this.to('DeleteEnvironmentTemplateVersion');
    }
    /**
     * Grants permission to delete a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteRepository.html
     */
    toDeleteRepository() {
        return this.to('DeleteRepository');
    }
    /**
     * Grants permission to delete a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteService.html
     */
    toDeleteService() {
        return this.to('DeleteService');
    }
    /**
     * Grants permission to delete a service sync config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceSyncConfig.html
     */
    toDeleteServiceSyncConfig() {
        return this.to('DeleteServiceSyncConfig');
    }
    /**
     * Grants permission to delete a service template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplate.html
     */
    toDeleteServiceTemplate() {
        return this.to('DeleteServiceTemplate');
    }
    /**
     * Grants permission to delete a service template major version. DEPRECATED - use DeleteServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMajorVersion.html
     */
    toDeleteServiceTemplateMajorVersion() {
        return this.to('DeleteServiceTemplateMajorVersion');
    }
    /**
     * Grants permission to delete a service template minor version. DEPRECATED - use DeleteServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMinorVersion.html
     */
    toDeleteServiceTemplateMinorVersion() {
        return this.to('DeleteServiceTemplateMinorVersion');
    }
    /**
     * Grants permission to delete a service template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateVersion.html
     */
    toDeleteServiceTemplateVersion() {
        return this.to('DeleteServiceTemplateVersion');
    }
    /**
     * Grants permission to delete a TemplateSyncConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteTemplateSyncConfig.html
     */
    toDeleteTemplateSyncConfig() {
        return this.to('DeleteTemplateSyncConfig');
    }
    /**
     * Grants permission to get account roles. DEPRECATED - use GetAccountSettings instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountRoles.html
     */
    toGetAccountRoles() {
        return this.to('GetAccountRoles');
    }
    /**
     * Grants permission to describe the account settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountSettings.html
     */
    toGetAccountSettings() {
        return this.to('GetAccountSettings');
    }
    /**
     * Grants permission to describe a component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetComponent.html
     */
    toGetComponent() {
        return this.to('GetComponent');
    }
    /**
     * Grants permission to describe an environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironment.html
     */
    toGetEnvironment() {
        return this.to('GetEnvironment');
    }
    /**
     * Grants permission to describe an environment account connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentAccountConnection.html
     */
    toGetEnvironmentAccountConnection() {
        return this.to('GetEnvironmentAccountConnection');
    }
    /**
     * Grants permission to describe an environment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplate.html
     */
    toGetEnvironmentTemplate() {
        return this.to('GetEnvironmentTemplate');
    }
    /**
     * Grants permission to get an environment template major version. DEPRECATED - use GetEnvironmentTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMajorVersion.html
     */
    toGetEnvironmentTemplateMajorVersion() {
        return this.to('GetEnvironmentTemplateMajorVersion');
    }
    /**
     * Grants permission to get an environment template minor version. DEPRECATED - use GetEnvironmentTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMinorVersion.html
     */
    toGetEnvironmentTemplateMinorVersion() {
        return this.to('GetEnvironmentTemplateMinorVersion');
    }
    /**
     * Grants permission to describe an environment template version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateVersion.html
     */
    toGetEnvironmentTemplateVersion() {
        return this.to('GetEnvironmentTemplateVersion');
    }
    /**
     * Grants permission to describe a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepository.html
     */
    toGetRepository() {
        return this.to('GetRepository');
    }
    /**
     * Grants permission to get the latest sync status for a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepositorySyncStatus.html
     */
    toGetRepositorySyncStatus() {
        return this.to('GetRepositorySyncStatus');
    }
    /**
     * Grants permission to list resource template version status counts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetResourceTemplateVersionStatusCounts.html
     */
    toGetResourceTemplateVersionStatusCounts() {
        return this.to('GetResourceTemplateVersionStatusCounts');
    }
    /**
     * Grants permission to get resources summary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetResourcesSummary.html
     */
    toGetResourcesSummary() {
        return this.to('GetResourcesSummary');
    }
    /**
     * Grants permission to describe a service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetService.html
     */
    toGetService() {
        return this.to('GetService');
    }
    /**
     * Grants permission to describe a service instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceInstance.html
     */
    toGetServiceInstance() {
        return this.to('GetServiceInstance');
    }
    /**
     * Grants permission to describe the sync status of a service instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceInstanceSyncStatus.html
     */
    toGetServiceInstanceSyncStatus() {
        return this.to('GetServiceInstanceSyncStatus');
    }
    /**
     * Grants permission to describe service sync blockers on a service or service instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceSyncBlockerSummary.html
     */
    toGetServiceSyncBlockerSummary() {
        return this.to('GetServiceSyncBlockerSummary');
    }
    /**
     * Grants permission to describe a service sync config
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceSyncConfig.html
     */
    toGetServiceSyncConfig() {
        return this.to('GetServiceSyncConfig');
    }
    /**
     * Grants permission to describe a service template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplate.html
     */
    toGetServiceTemplate() {
        return this.to('GetServiceTemplate');
    }
    /**
     * Grants permission to get a service template major version. DEPRECATED - use GetServiceTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMajorVersion.html
     */
    toGetServiceTemplateMajorVersion() {
        return this.to('GetServiceTemplateMajorVersion');
    }
    /**
     * Grants permission to get a service template minor version. DEPRECATED - use GetServiceTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMinorVersion.html
     */
    toGetServiceTemplateMinorVersion() {
        return this.to('GetServiceTemplateMinorVersion');
    }
    /**
     * Grants permission to describe a service template version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateVersion.html
     */
    toGetServiceTemplateVersion() {
        return this.to('GetServiceTemplateVersion');
    }
    /**
     * Grants permission to describe a TemplateSyncConfig
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncConfig.html
     */
    toGetTemplateSyncConfig() {
        return this.to('GetTemplateSyncConfig');
    }
    /**
     * Grants permission to describe the sync status of a template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncStatus.html
     */
    toGetTemplateSyncStatus() {
        return this.to('GetTemplateSyncStatus');
    }
    /**
     * Grants permission to list component outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponentOutputs.html
     */
    toListComponentOutputs() {
        return this.to('ListComponentOutputs');
    }
    /**
     * Grants permission to list component provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponentProvisionedResources.html
     */
    toListComponentProvisionedResources() {
        return this.to('ListComponentProvisionedResources');
    }
    /**
     * Grants permission to list components
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListComponents.html
     */
    toListComponents() {
        return this.to('ListComponents');
    }
    /**
     * Grants permission to list environment account connections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentAccountConnections.html
     */
    toListEnvironmentAccountConnections() {
        return this.to('ListEnvironmentAccountConnections');
    }
    /**
     * Grants permission to list environment outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentOutputs.html
     */
    toListEnvironmentOutputs() {
        return this.to('ListEnvironmentOutputs');
    }
    /**
     * Grants permission to list environment provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentProvisionedResources.html
     */
    toListEnvironmentProvisionedResources() {
        return this.to('ListEnvironmentProvisionedResources');
    }
    /**
     * Grants permission to list environment template major versions. DEPRECATED - use ListEnvironmentTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMajorVersions.html
     */
    toListEnvironmentTemplateMajorVersions() {
        return this.to('ListEnvironmentTemplateMajorVersions');
    }
    /**
     * Grants permission to list an environment template minor versions. DEPRECATED - use ListEnvironmentTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMinorVersions.html
     */
    toListEnvironmentTemplateMinorVersions() {
        return this.to('ListEnvironmentTemplateMinorVersions');
    }
    /**
     * Grants permission to list environment template versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateVersions.html
     */
    toListEnvironmentTemplateVersions() {
        return this.to('ListEnvironmentTemplateVersions');
    }
    /**
     * Grants permission to list environment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplates.html
     */
    toListEnvironmentTemplates() {
        return this.to('ListEnvironmentTemplates');
    }
    /**
     * Grants permission to list environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironments.html
     */
    toListEnvironments() {
        return this.to('ListEnvironments');
    }
    /**
     * Grants permission to list repositories
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositories.html
     */
    toListRepositories() {
        return this.to('ListRepositories');
    }
    /**
     * Grants permission to list repository sync definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositorySyncDefinitions.html
     */
    toListRepositorySyncDefinitions() {
        return this.to('ListRepositorySyncDefinitions');
    }
    /**
     * Grants permission to list service instance outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceOutputs.html
     */
    toListServiceInstanceOutputs() {
        return this.to('ListServiceInstanceOutputs');
    }
    /**
     * Grants permission to list service instance provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceProvisionedResources.html
     */
    toListServiceInstanceProvisionedResources() {
        return this.to('ListServiceInstanceProvisionedResources');
    }
    /**
     * Grants permission to list service instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstances.html
     */
    toListServiceInstances() {
        return this.to('ListServiceInstances');
    }
    /**
     * Grants permission to list service pipeline outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineOutputs.html
     */
    toListServicePipelineOutputs() {
        return this.to('ListServicePipelineOutputs');
    }
    /**
     * Grants permission to list service pipeline provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineProvisionedResources.html
     */
    toListServicePipelineProvisionedResources() {
        return this.to('ListServicePipelineProvisionedResources');
    }
    /**
     * Grants permission to list service template major versions. DEPRECATED - use ListServiceTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMajorVersions.html
     */
    toListServiceTemplateMajorVersions() {
        return this.to('ListServiceTemplateMajorVersions');
    }
    /**
     * Grants permission to list service template minor versions. DEPRECATED - use ListServiceTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMinorVersions.html
     */
    toListServiceTemplateMinorVersions() {
        return this.to('ListServiceTemplateMinorVersions');
    }
    /**
     * Grants permission to list service template versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateVersions.html
     */
    toListServiceTemplateVersions() {
        return this.to('ListServiceTemplateVersions');
    }
    /**
     * Grants permission to list service templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplates.html
     */
    toListServiceTemplates() {
        return this.to('ListServiceTemplates');
    }
    /**
     * Grants permission to list services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServices.html
     */
    toListServices() {
        return this.to('ListServices');
    }
    /**
     * Grants permission to list tags of a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to notify Proton of resource deployment status changes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_NotifyResourceDeploymentStatusChange.html
     */
    toNotifyResourceDeploymentStatusChange() {
        return this.to('NotifyResourceDeploymentStatusChange');
    }
    /**
     * Grants permission to reject an environment account connection request from another environment account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_RejectEnvironmentAccountConnection.html
     */
    toRejectEnvironmentAccountConnection() {
        return this.to('RejectEnvironmentAccountConnection');
    }
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update account roles. DEPRECATED - use UpdateAccountSettings instead
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountRoles.html
     */
    toUpdateAccountRoles() {
        return this.to('UpdateAccountRoles');
    }
    /**
     * Grants permission to update the account settings
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountSettings.html
     */
    toUpdateAccountSettings() {
        return this.to('UpdateAccountSettings');
    }
    /**
     * Grants permission to update component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateComponent.html
     */
    toUpdateComponent() {
        return this.to('UpdateComponent');
    }
    /**
     * Grants permission to update an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironment.html
     */
    toUpdateEnvironment() {
        return this.to('UpdateEnvironment');
    }
    /**
     * Grants permission to update an environment account connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentAccountConnection.html
     */
    toUpdateEnvironmentAccountConnection() {
        return this.to('UpdateEnvironmentAccountConnection');
    }
    /**
     * Grants permission to update an environment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplate.html
     */
    toUpdateEnvironmentTemplate() {
        return this.to('UpdateEnvironmentTemplate');
    }
    /**
     * Grants permission to update an environment template major version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMajorVersion.html
     */
    toUpdateEnvironmentTemplateMajorVersion() {
        return this.to('UpdateEnvironmentTemplateMajorVersion');
    }
    /**
     * Grants permission to update an environment template minor version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMinorVersion.html
     */
    toUpdateEnvironmentTemplateMinorVersion() {
        return this.to('UpdateEnvironmentTemplateMinorVersion');
    }
    /**
     * Grants permission to update an environment template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateVersion.html
     */
    toUpdateEnvironmentTemplateVersion() {
        return this.to('UpdateEnvironmentTemplateVersion');
    }
    /**
     * Grants permission to update a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateService.html
     */
    toUpdateService() {
        return this.to('UpdateService');
    }
    /**
     * Grants permission to update a service instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceInstance.html
     */
    toUpdateServiceInstance() {
        return this.to('UpdateServiceInstance');
    }
    /**
     * Grants permission to update a service pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServicePipeline.html
     */
    toUpdateServicePipeline() {
        return this.to('UpdateServicePipeline');
    }
    /**
     * Grants permission to update a service sync blocker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceSyncBlocker.html
     */
    toUpdateServiceSyncBlocker() {
        return this.to('UpdateServiceSyncBlocker');
    }
    /**
     * Grants permission to update a service sync config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceSyncConfig.html
     */
    toUpdateServiceSyncConfig() {
        return this.to('UpdateServiceSyncConfig');
    }
    /**
     * Grants permission to update a service template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplate.html
     */
    toUpdateServiceTemplate() {
        return this.to('UpdateServiceTemplate');
    }
    /**
     * Grants permission to update a service template major version. DEPRECATED - use UpdateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMajorVersion.html
     */
    toUpdateServiceTemplateMajorVersion() {
        return this.to('UpdateServiceTemplateMajorVersion');
    }
    /**
     * Grants permission to create a service template minor version. DEPRECATED - use UpdateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMinorVersion.html
     */
    toUpdateServiceTemplateMinorVersion() {
        return this.to('UpdateServiceTemplateMinorVersion');
    }
    /**
     * Grants permission to update a service template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateVersion.html
     */
    toUpdateServiceTemplateVersion() {
        return this.to('UpdateServiceTemplateVersion');
    }
    /**
     * Grants permission to update a TemplateSyncConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateTemplateSyncConfig.html
     */
    toUpdateTemplateSyncConfig() {
        return this.to('UpdateTemplateSyncConfig');
    }
    /**
     * Adds a resource of type environment-template to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplate(name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment-template/${name}`);
    }
    /**
     * Adds a resource of type environment-template-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersion - Identifier for the majorVersion.
     * @param minorVersion - Identifier for the minorVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateVersion(templateName, majorVersion, minorVersion, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment-template/${templateName}:${majorVersion}.${minorVersion}`);
    }
    /**
     * Adds a resource of type environment-template-major-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateMajorVersion(templateName, majorVersionId, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment-template/${templateName}:${majorVersionId}`);
    }
    /**
     * Adds a resource of type environment-template-minor-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param minorVersionId - Identifier for the minorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateMinorVersion(templateName, majorVersionId, minorVersionId, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment-template/${templateName}:${majorVersionId}.${minorVersionId}`);
    }
    /**
     * Adds a resource of type service-template to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplate(name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service-template/${name}`);
    }
    /**
     * Adds a resource of type service-template-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersion - Identifier for the majorVersion.
     * @param minorVersion - Identifier for the minorVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateVersion(templateName, majorVersion, minorVersion, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service-template/${templateName}:${majorVersion}.${minorVersion}`);
    }
    /**
     * Adds a resource of type service-template-major-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateMajorVersion(templateName, majorVersionId, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service-template/${templateName}:${majorVersionId}`);
    }
    /**
     * Adds a resource of type service-template-minor-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param minorVersionId - Identifier for the minorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateMinorVersion(templateName, majorVersionId, minorVersionId, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service-template/${templateName}:${majorVersionId}.${minorVersionId}`);
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment/${name}`);
    }
    /**
     * Adds a resource of type service to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onService(name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service/${name}`);
    }
    /**
     * Adds a resource of type service-instance to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html
     *
     * @param serviceName - Identifier for the serviceName.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceInstance(serviceName, name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:service/${serviceName}/service-instance/${name}`);
    }
    /**
     * Adds a resource of type environment-account-connection to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentAccountConnection(id, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:environment-account-connection/${id}`);
    }
    /**
     * Adds a resource of type repository to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-repositories.html
     *
     * @param provider - Identifier for the provider.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRepository(provider, name, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:repository/${provider}:${name}`);
    }
    /**
     * Adds a resource of type component to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onComponent(id, account, region, partition) {
        return this.on(`arn:${partition || Proton.defaultPartition}:proton:${region || '*'}:${account || '*'}:component/${id}`);
    }
    /**
     * Filters access by specified environment template related to resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html
     *
     * Applies to actions:
     * - .toCancelEnvironmentDeployment()
     * - .toCreateEnvironment()
     * - .toDeleteEnvironment()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEnvironmentTemplate(value, operator) {
        return this.if(`EnvironmentTemplate`, value, operator || 'StringLike');
    }
    /**
     * Filters access by specified service template related to resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html
     *
     * Applies to actions:
     * - .toCancelServiceInstanceDeployment()
     * - .toCancelServicePipelineDeployment()
     * - .toCreateService()
     * - .toCreateServiceInstance()
     * - .toDeleteService()
     * - .toUpdateService()
     * - .toUpdateServiceInstance()
     * - .toUpdateServicePipeline()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifServiceTemplate(value, operator) {
        return this.if(`ServiceTemplate`, value, operator || 'StringLike');
    }
}
exports.Proton = Proton;
_a = JSII_RTTI_SYMBOL_1;
Proton[_a] = { fqn: "iam-floyd.Proton", version: "0.504.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvdG9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicHJvdG9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQXNEO0FBRXREOzs7O0dBSUc7QUFDSCxNQUFhLE1BQU8sU0FBUSx3QkFBZTtJQUd6Qzs7OztPQUlHO0lBQ0gsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQVJOLGtCQUFhLEdBQUcsUUFBUSxDQUFDO1FBMnhDdEIsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLG9DQUFvQztnQkFDcEMsMkJBQTJCO2dCQUMzQiw2QkFBNkI7Z0JBQzdCLGlDQUFpQztnQkFDakMsaUNBQWlDO2dCQUNqQyxpQkFBaUI7Z0JBQ2pCLG1CQUFtQjtnQkFDbkIsb0NBQW9DO2dCQUNwQywyQkFBMkI7Z0JBQzNCLHVDQUF1QztnQkFDdkMsdUNBQXVDO2dCQUN2QyxrQ0FBa0M7Z0JBQ2xDLGtCQUFrQjtnQkFDbEIsZUFBZTtnQkFDZix1QkFBdUI7Z0JBQ3ZCLHlCQUF5QjtnQkFDekIsdUJBQXVCO2dCQUN2QixtQ0FBbUM7Z0JBQ25DLG1DQUFtQztnQkFDbkMsOEJBQThCO2dCQUM5QiwwQkFBMEI7Z0JBQzFCLG9CQUFvQjtnQkFDcEIsaUJBQWlCO2dCQUNqQixtQkFBbUI7Z0JBQ25CLG9DQUFvQztnQkFDcEMsMkJBQTJCO2dCQUMzQix1Q0FBdUM7Z0JBQ3ZDLHVDQUF1QztnQkFDdkMsa0NBQWtDO2dCQUNsQyxrQkFBa0I7Z0JBQ2xCLGVBQWU7Z0JBQ2YseUJBQXlCO2dCQUN6Qix1QkFBdUI7Z0JBQ3ZCLG1DQUFtQztnQkFDbkMsbUNBQW1DO2dCQUNuQyw4QkFBOEI7Z0JBQzlCLDBCQUEwQjtnQkFDMUIsc0NBQXNDO2dCQUN0QyxvQ0FBb0M7Z0JBQ3BDLG9CQUFvQjtnQkFDcEIsdUJBQXVCO2dCQUN2QixpQkFBaUI7Z0JBQ2pCLG1CQUFtQjtnQkFDbkIsb0NBQW9DO2dCQUNwQywyQkFBMkI7Z0JBQzNCLHVDQUF1QztnQkFDdkMsdUNBQXVDO2dCQUN2QyxrQ0FBa0M7Z0JBQ2xDLGVBQWU7Z0JBQ2YsdUJBQXVCO2dCQUN2Qix1QkFBdUI7Z0JBQ3ZCLDBCQUEwQjtnQkFDMUIseUJBQXlCO2dCQUN6Qix1QkFBdUI7Z0JBQ3ZCLG1DQUFtQztnQkFDbkMsbUNBQW1DO2dCQUNuQyw4QkFBOEI7Z0JBQzlCLDBCQUEwQjthQUMzQjtZQUNELElBQUksRUFBRTtnQkFDSixpQkFBaUI7Z0JBQ2pCLG9CQUFvQjtnQkFDcEIsY0FBYztnQkFDZCxnQkFBZ0I7Z0JBQ2hCLGlDQUFpQztnQkFDakMsd0JBQXdCO2dCQUN4QixvQ0FBb0M7Z0JBQ3BDLG9DQUFvQztnQkFDcEMsK0JBQStCO2dCQUMvQixlQUFlO2dCQUNmLHlCQUF5QjtnQkFDekIsd0NBQXdDO2dCQUN4QyxxQkFBcUI7Z0JBQ3JCLFlBQVk7Z0JBQ1osb0JBQW9CO2dCQUNwQiw4QkFBOEI7Z0JBQzlCLDhCQUE4QjtnQkFDOUIsc0JBQXNCO2dCQUN0QixvQkFBb0I7Z0JBQ3BCLGdDQUFnQztnQkFDaEMsZ0NBQWdDO2dCQUNoQywyQkFBMkI7Z0JBQzNCLHVCQUF1QjtnQkFDdkIsdUJBQXVCO2dCQUN2QixxQkFBcUI7YUFDdEI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osc0JBQXNCO2dCQUN0QixtQ0FBbUM7Z0JBQ25DLGdCQUFnQjtnQkFDaEIsbUNBQW1DO2dCQUNuQyx3QkFBd0I7Z0JBQ3hCLHFDQUFxQztnQkFDckMsc0NBQXNDO2dCQUN0QyxzQ0FBc0M7Z0JBQ3RDLGlDQUFpQztnQkFDakMsMEJBQTBCO2dCQUMxQixrQkFBa0I7Z0JBQ2xCLGtCQUFrQjtnQkFDbEIsK0JBQStCO2dCQUMvQiw0QkFBNEI7Z0JBQzVCLHlDQUF5QztnQkFDekMsc0JBQXNCO2dCQUN0Qiw0QkFBNEI7Z0JBQzVCLHlDQUF5QztnQkFDekMsa0NBQWtDO2dCQUNsQyxrQ0FBa0M7Z0JBQ2xDLDZCQUE2QjtnQkFDN0Isc0JBQXNCO2dCQUN0QixjQUFjO2FBQ2Y7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQXY0Q0YsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7T0FjRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHVDQUF1QztRQUM1QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUNBQXVDLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHVDQUF1QztRQUM1QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUNBQXVDLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7O09BV0c7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQ0FBb0M7UUFDekMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUNBQXVDO1FBQzVDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1Q0FBdUM7UUFDNUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVDQUF1QyxDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUNBQW1DO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQ0FBb0M7UUFDekMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksK0JBQStCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3Q0FBd0M7UUFDN0MsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdDQUF3QyxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQ0FBZ0M7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUNBQW1DO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFDQUFxQztRQUMxQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0NBQXNDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQ0FBc0M7UUFDM0MsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7SUFDekQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksK0JBQStCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlDQUF5QztRQUM5QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUNBQXlDLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlDQUF5QztRQUM5QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUNBQXlDLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQ0FBc0M7UUFDM0MsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7SUFDekQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9DQUFvQztRQUN6QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsb0NBQW9DLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQ0FBb0M7UUFDekMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG9DQUFvQyxDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUNBQXVDO1FBQzVDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1Q0FBdUM7UUFDNUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVDQUF1QyxDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQXlIRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxxQkFBcUIsQ0FBQyxJQUFZLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDOUYsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLHlCQUEwQixJQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQy9JLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7T0FjRztJQUNJLDRCQUE0QixDQUFDLFlBQW9CLEVBQUUsWUFBb0IsRUFBRSxZQUFvQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3pKLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSx5QkFBMEIsWUFBYSxJQUFLLFlBQWEsSUFBSyxZQUFhLEVBQUUsQ0FBQyxDQUFDO0lBQzNMLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksaUNBQWlDLENBQUMsWUFBb0IsRUFBRSxjQUFzQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQzFJLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSx5QkFBMEIsWUFBYSxJQUFLLGNBQWUsRUFBRSxDQUFDLENBQUM7SUFDM0ssQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksaUNBQWlDLENBQUMsWUFBb0IsRUFBRSxjQUFzQixFQUFFLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDbEssT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLHlCQUEwQixZQUFhLElBQUssY0FBZSxJQUFLLGNBQWUsRUFBRSxDQUFDLENBQUM7SUFDL0wsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLGlCQUFpQixDQUFDLElBQVksRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUMxRixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUkscUJBQXNCLElBQUssRUFBRSxDQUFDLENBQUM7SUFDM0ksQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksd0JBQXdCLENBQUMsWUFBb0IsRUFBRSxZQUFvQixFQUFFLFlBQW9CLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckosT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLHFCQUFzQixZQUFhLElBQUssWUFBYSxJQUFLLFlBQWEsRUFBRSxDQUFDLENBQUM7SUFDdkwsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSw2QkFBNkIsQ0FBQyxZQUFvQixFQUFFLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDdEksT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLHFCQUFzQixZQUFhLElBQUssY0FBZSxFQUFFLENBQUMsQ0FBQztJQUN2SyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7O09BY0c7SUFDSSw2QkFBNkIsQ0FBQyxZQUFvQixFQUFFLGNBQXNCLEVBQUUsY0FBc0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUM5SixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUkscUJBQXNCLFlBQWEsSUFBSyxjQUFlLElBQUssY0FBZSxFQUFFLENBQUMsQ0FBQztJQUMzTCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksYUFBYSxDQUFDLElBQVksRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN0RixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksZ0JBQWlCLElBQUssRUFBRSxDQUFDLENBQUM7SUFDdEksQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLFNBQVMsQ0FBQyxJQUFZLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDbEYsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLFlBQWEsSUFBSyxFQUFFLENBQUMsQ0FBQztJQUNsSSxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7T0FhRztJQUNJLGlCQUFpQixDQUFDLFdBQW1CLEVBQUUsSUFBWSxFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQy9HLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxZQUFhLFdBQVkscUJBQXNCLElBQUssRUFBRSxDQUFDLENBQUM7SUFDcEssQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLDhCQUE4QixDQUFDLEVBQVUsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNyRyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksTUFBTSxDQUFDLGdCQUFpQixXQUFZLE1BQU0sSUFBSSxHQUFJLElBQUssT0FBTyxJQUFJLEdBQUksbUNBQW9DLEVBQUcsRUFBRSxDQUFDLENBQUM7SUFDdkosQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxZQUFZLENBQUMsUUFBZ0IsRUFBRSxJQUFZLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDdkcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLE1BQU0sQ0FBQyxnQkFBaUIsV0FBWSxNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLGVBQWdCLFFBQVMsSUFBSyxJQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ25KLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxXQUFXLENBQUMsRUFBVSxFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ2xGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSxNQUFNLENBQUMsZ0JBQWlCLFdBQVksTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxjQUFlLEVBQUcsRUFBRSxDQUFDLENBQUM7SUFDbEksQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7O09BYUc7SUFDSSxxQkFBcUIsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQ2pGLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ3pFLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FpQkc7SUFDSSxpQkFBaUIsQ0FBQyxLQUF3QixFQUFFLFFBQTRCO1FBQzdFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ3JFLENBQUM7O0FBbnJESCx3QkFvckRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQsIE9wZXJhdG9yIH0gZnJvbSAnLi4vc2hhcmVkJztcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW3Byb3Rvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzcHJvdG9uLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgUHJvdG9uIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAncHJvdG9uJztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtwcm90b25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c3Byb3Rvbi5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJlamVjdCBhbiBlbnZpcm9ubWVudCBhY2NvdW50IGNvbm5lY3Rpb24gcmVxdWVzdCBmcm9tIGFub3RoZXIgZW52aXJvbm1lbnQgYWNjb3VudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQWNjZXB0RW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9BY2NlcHRFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBY2NlcHRFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2FuY2VsIGNvbXBvbmVudCBkZXBsb3ltZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DYW5jZWxDb21wb25lbnREZXBsb3ltZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbENvbXBvbmVudERlcGxveW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NhbmNlbENvbXBvbmVudERlcGxveW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjYW5jZWwgYW4gZW52aXJvbm1lbnQgZGVwbG95bWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmRW52aXJvbm1lbnRUZW1wbGF0ZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ2FuY2VsRW52aXJvbm1lbnREZXBsb3ltZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbEVudmlyb25tZW50RGVwbG95bWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FuY2VsRW52aXJvbm1lbnREZXBsb3ltZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY2FuY2VsIGEgc2VydmljZSBpbnN0YW5jZSBkZXBsb3ltZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZTZXJ2aWNlVGVtcGxhdGUoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NhbmNlbFNlcnZpY2VJbnN0YW5jZURlcGxveW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ2FuY2VsU2VydmljZUluc3RhbmNlRGVwbG95bWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ2FuY2VsU2VydmljZUluc3RhbmNlRGVwbG95bWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNhbmNlbCBhIHNlcnZpY2UgcGlwZWxpbmUgZGVwbG95bWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmU2VydmljZVRlbXBsYXRlKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DYW5jZWxTZXJ2aWNlUGlwZWxpbmVEZXBsb3ltZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbFNlcnZpY2VQaXBlbGluZURlcGxveW1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NhbmNlbFNlcnZpY2VQaXBlbGluZURlcGxveW1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgY29tcG9uZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVDb21wb25lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQ29tcG9uZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVDb21wb25lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYW4gZW52aXJvbm1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkVudmlyb25tZW50VGVtcGxhdGUoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBpYW06UGFzc1JvbGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVFbnZpcm9ubWVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVFbnZpcm9ubWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRW52aXJvbm1lbnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYW4gZW52aXJvbm1lbnQgYWNjb3VudCBjb25uZWN0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYW4gZW52aXJvbm1lbnQgdGVtcGxhdGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZSBtYWpvciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIENyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uIGluc3RlYWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZSBtaW5vciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIENyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uIGluc3RlYWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZSB2ZXJzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSByZXBvc2l0b3J5XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVSZXBvc2l0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVJlcG9zaXRvcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVJlcG9zaXRvcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzZXJ2aWNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZTZXJ2aWNlVGVtcGxhdGUoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBjb2Rlc3Rhci1jb25uZWN0aW9uczpQYXNzQ29ubmVjdGlvblxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0NyZWF0ZVNlcnZpY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU2VydmljZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU2VydmljZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHNlcnZpY2UgaW5zdGFuY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZlNlcnZpY2VUZW1wbGF0ZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlU2VydmljZUluc3RhbmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VJbnN0YW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU2VydmljZUluc3RhbmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgc2VydmljZSBzeW5jIGNvbmZpZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlU2VydmljZVN5bmNDb25maWcuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU2VydmljZVN5bmNDb25maWcoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVNlcnZpY2VTeW5jQ29uZmlnJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgc2VydmljZSB0ZW1wbGF0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlU2VydmljZVRlbXBsYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU2VydmljZVRlbXBsYXRlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgc2VydmljZSB0ZW1wbGF0ZSBtYWpvciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIENyZWF0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlU2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZU1ham9yVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgc2VydmljZSB0ZW1wbGF0ZSBtaW5vciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIENyZWF0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgc2VydmljZSB0ZW1wbGF0ZSB2ZXJzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVTZXJ2aWNlVGVtcGxhdGVWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSB0ZW1wbGF0ZSBzeW5jIGNvbmZpZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfQ3JlYXRlVGVtcGxhdGVTeW5jQ29uZmlnLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVRlbXBsYXRlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlVGVtcGxhdGVTeW5jQ29uZmlnJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFjY291bnQgcm9sZXMuIERFUFJFQ0FURUQgLSB1c2UgVXBkYXRlQWNjb3VudFNldHRpbmdzIGluc3RlYWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZUFjY291bnRSb2xlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVBY2NvdW50Um9sZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUFjY291bnRSb2xlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZUNvbXBvbmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVDb21wb25lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUNvbXBvbmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhbiBlbnZpcm9ubWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmRW52aXJvbm1lbnRUZW1wbGF0ZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlRW52aXJvbm1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRW52aXJvbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUVudmlyb25tZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGVudmlyb25tZW50IGFjY291bnQgY29ubmVjdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlRW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGVudmlyb25tZW50IHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVFbnZpcm9ubWVudFRlbXBsYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYW4gZW52aXJvbm1lbnQgdGVtcGxhdGUgbWFqb3IgdmVyc2lvbi4gREVQUkVDQVRFRCAtIHVzZSBEZWxldGVFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYW4gZW52aXJvbm1lbnQgdGVtcGxhdGUgbWlub3IgdmVyc2lvbi4gREVQUkVDQVRFRCAtIHVzZSBEZWxldGVFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYW4gZW52aXJvbm1lbnQgdGVtcGxhdGUgdmVyc2lvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcmVwb3NpdG9yeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlUmVwb3NpdG9yeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZXBvc2l0b3J5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVSZXBvc2l0b3J5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgc2VydmljZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmU2VydmljZVRlbXBsYXRlKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTZXJ2aWNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVNlcnZpY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVNlcnZpY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBzZXJ2aWNlIHN5bmMgY29uZmlnXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTZXJ2aWNlU3luY0NvbmZpZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVTZXJ2aWNlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlU2VydmljZVN5bmNDb25maWcnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBzZXJ2aWNlIHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTZXJ2aWNlVGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU2VydmljZVRlbXBsYXRlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVTZXJ2aWNlVGVtcGxhdGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBzZXJ2aWNlIHRlbXBsYXRlIG1ham9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgRGVsZXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBzZXJ2aWNlIHRlbXBsYXRlIG1pbm9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgRGVsZXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9EZWxldGVTZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVTZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSBzZXJ2aWNlIHRlbXBsYXRlIHZlcnNpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIFRlbXBsYXRlU3luY0NvbmZpZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGVsZXRlVGVtcGxhdGVTeW5jQ29uZmlnLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVRlbXBsYXRlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlVGVtcGxhdGVTeW5jQ29uZmlnJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFjY291bnQgcm9sZXMuIERFUFJFQ0FURUQgLSB1c2UgR2V0QWNjb3VudFNldHRpbmdzIGluc3RlYWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0QWNjb3VudFJvbGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEFjY291bnRSb2xlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWNjb3VudFJvbGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgdGhlIGFjY291bnQgc2V0dGluZ3NcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0QWNjb3VudFNldHRpbmdzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEFjY291bnRTZXR0aW5ncygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWNjb3VudFNldHRpbmdzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0Q29tcG9uZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldENvbXBvbmVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Q29tcG9uZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYW4gZW52aXJvbm1lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RW52aXJvbm1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RW52aXJvbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVudmlyb25tZW50Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYW4gZW52aXJvbm1lbnQgYWNjb3VudCBjb25uZWN0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGFuIGVudmlyb25tZW50IHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVudmlyb25tZW50VGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RW52aXJvbm1lbnRUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RW52aXJvbm1lbnRUZW1wbGF0ZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZSBtYWpvciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIEdldEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uIGluc3RlYWRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFuIGVudmlyb25tZW50IHRlbXBsYXRlIG1pbm9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgR2V0RW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZSB2ZXJzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgcmVwb3NpdG9yeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZXBvc2l0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlcG9zaXRvcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlcG9zaXRvcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIGxhdGVzdCBzeW5jIHN0YXR1cyBmb3IgYSByZXBvc2l0b3J5XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFJlcG9zaXRvcnlTeW5jU3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlcG9zaXRvcnlTeW5jU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXBvc2l0b3J5U3luY1N0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgcmVzb3VyY2UgdGVtcGxhdGUgdmVyc2lvbiBzdGF0dXMgY291bnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFJlc291cmNlVGVtcGxhdGVWZXJzaW9uU3RhdHVzQ291bnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlc291cmNlVGVtcGxhdGVWZXJzaW9uU3RhdHVzQ291bnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXNvdXJjZVRlbXBsYXRlVmVyc2lvblN0YXR1c0NvdW50cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZXNvdXJjZXMgc3VtbWFyeVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZXNvdXJjZXNTdW1tYXJ5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlc291cmNlc1N1bW1hcnkoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlc291cmNlc1N1bW1hcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhIHNlcnZpY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0U2VydmljZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTZXJ2aWNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTZXJ2aWNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBzZXJ2aWNlIGluc3RhbmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFNlcnZpY2VJbnN0YW5jZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTZXJ2aWNlSW5zdGFuY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFNlcnZpY2VJbnN0YW5jZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSBzeW5jIHN0YXR1cyBvZiBhIHNlcnZpY2UgaW5zdGFuY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0U2VydmljZUluc3RhbmNlU3luY1N0YXR1cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTZXJ2aWNlSW5zdGFuY2VTeW5jU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTZXJ2aWNlSW5zdGFuY2VTeW5jU3RhdHVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgc2VydmljZSBzeW5jIGJsb2NrZXJzIG9uIGEgc2VydmljZSBvciBzZXJ2aWNlIGluc3RhbmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFNlcnZpY2VTeW5jQmxvY2tlclN1bW1hcnkuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U2VydmljZVN5bmNCbG9ja2VyU3VtbWFyeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2VydmljZVN5bmNCbG9ja2VyU3VtbWFyeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgc2VydmljZSBzeW5jIGNvbmZpZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRTZXJ2aWNlU3luY0NvbmZpZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTZXJ2aWNlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2VydmljZVN5bmNDb25maWcnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhIHNlcnZpY2UgdGVtcGxhdGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0U2VydmljZVRlbXBsYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFNlcnZpY2VUZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2VydmljZVRlbXBsYXRlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGEgc2VydmljZSB0ZW1wbGF0ZSBtYWpvciB2ZXJzaW9uLiBERVBSRUNBVEVEIC0gdXNlIEdldFNlcnZpY2VUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgYSBzZXJ2aWNlIHRlbXBsYXRlIG1pbm9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgR2V0U2VydmljZVRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgc2VydmljZSB0ZW1wbGF0ZSB2ZXJzaW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFNlcnZpY2VUZW1wbGF0ZVZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U2VydmljZVRlbXBsYXRlVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2VydmljZVRlbXBsYXRlVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgVGVtcGxhdGVTeW5jQ29uZmlnXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFRlbXBsYXRlU3luY0NvbmZpZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRUZW1wbGF0ZVN5bmNDb25maWcoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFRlbXBsYXRlU3luY0NvbmZpZycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSBzeW5jIHN0YXR1cyBvZiBhIHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldFRlbXBsYXRlU3luY1N0YXR1cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRUZW1wbGF0ZVN5bmNTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFRlbXBsYXRlU3luY1N0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgY29tcG9uZW50IG91dHB1dHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdENvbXBvbmVudE91dHB1dHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdENvbXBvbmVudE91dHB1dHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDb21wb25lbnRPdXRwdXRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBjb21wb25lbnQgcHJvdmlzaW9uZWQgcmVzb3VyY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RDb21wb25lbnRQcm92aXNpb25lZFJlc291cmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q29tcG9uZW50UHJvdmlzaW9uZWRSZXNvdXJjZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDb21wb25lbnRQcm92aXNpb25lZFJlc291cmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgY29tcG9uZW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0Q29tcG9uZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q29tcG9uZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdENvbXBvbmVudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGVudmlyb25tZW50IGFjY291bnQgY29ubmVjdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBlbnZpcm9ubWVudCBvdXRwdXRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RFbnZpcm9ubWVudE91dHB1dHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEVudmlyb25tZW50T3V0cHV0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEVudmlyb25tZW50T3V0cHV0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZW52aXJvbm1lbnQgcHJvdmlzaW9uZWQgcmVzb3VyY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RFbnZpcm9ubWVudFByb3Zpc2lvbmVkUmVzb3VyY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RFbnZpcm9ubWVudFByb3Zpc2lvbmVkUmVzb3VyY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RW52aXJvbm1lbnRQcm92aXNpb25lZFJlc291cmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZW52aXJvbm1lbnQgdGVtcGxhdGUgbWFqb3IgdmVyc2lvbnMuIERFUFJFQ0FURUQgLSB1c2UgTGlzdEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9ucyBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYW4gZW52aXJvbm1lbnQgdGVtcGxhdGUgbWlub3IgdmVyc2lvbnMuIERFUFJFQ0FURUQgLSB1c2UgTGlzdEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9ucyBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgZW52aXJvbm1lbnQgdGVtcGxhdGUgdmVyc2lvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBlbnZpcm9ubWVudCB0ZW1wbGF0ZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEVudmlyb25tZW50VGVtcGxhdGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEVudmlyb25tZW50VGVtcGxhdGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBlbnZpcm9ubWVudHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEVudmlyb25tZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RW52aXJvbm1lbnRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RW52aXJvbm1lbnRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCByZXBvc2l0b3JpZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFJlcG9zaXRvcmllcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVwb3NpdG9yaWVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVwb3NpdG9yaWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCByZXBvc2l0b3J5IHN5bmMgZGVmaW5pdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFJlcG9zaXRvcnlTeW5jRGVmaW5pdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFJlcG9zaXRvcnlTeW5jRGVmaW5pdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RSZXBvc2l0b3J5U3luY0RlZmluaXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBzZXJ2aWNlIGluc3RhbmNlIG91dHB1dHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFNlcnZpY2VJbnN0YW5jZU91dHB1dHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFNlcnZpY2VJbnN0YW5jZU91dHB1dHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RTZXJ2aWNlSW5zdGFuY2VPdXRwdXRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBzZXJ2aWNlIGluc3RhbmNlIHByb3Zpc2lvbmVkIHJlc291cmNlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U2VydmljZUluc3RhbmNlUHJvdmlzaW9uZWRSZXNvdXJjZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFNlcnZpY2VJbnN0YW5jZVByb3Zpc2lvbmVkUmVzb3VyY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2VydmljZUluc3RhbmNlUHJvdmlzaW9uZWRSZXNvdXJjZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHNlcnZpY2UgaW5zdGFuY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RTZXJ2aWNlSW5zdGFuY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZXJ2aWNlSW5zdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2VydmljZUluc3RhbmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgc2VydmljZSBwaXBlbGluZSBvdXRwdXRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RTZXJ2aWNlUGlwZWxpbmVPdXRwdXRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZXJ2aWNlUGlwZWxpbmVPdXRwdXRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2VydmljZVBpcGVsaW5lT3V0cHV0cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgc2VydmljZSBwaXBlbGluZSBwcm92aXNpb25lZCByZXNvdXJjZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFNlcnZpY2VQaXBlbGluZVByb3Zpc2lvbmVkUmVzb3VyY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZXJ2aWNlUGlwZWxpbmVQcm92aXNpb25lZFJlc291cmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFNlcnZpY2VQaXBlbGluZVByb3Zpc2lvbmVkUmVzb3VyY2VzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBzZXJ2aWNlIHRlbXBsYXRlIG1ham9yIHZlcnNpb25zLiBERVBSRUNBVEVEIC0gdXNlIExpc3RTZXJ2aWNlVGVtcGxhdGVWZXJzaW9ucyBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0U2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgc2VydmljZSB0ZW1wbGF0ZSBtaW5vciB2ZXJzaW9ucy4gREVQUkVDQVRFRCAtIHVzZSBMaXN0U2VydmljZVRlbXBsYXRlVmVyc2lvbnMgaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHNlcnZpY2UgdGVtcGxhdGUgdmVyc2lvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdFNlcnZpY2VUZW1wbGF0ZVZlcnNpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTZXJ2aWNlVGVtcGxhdGVWZXJzaW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFNlcnZpY2VUZW1wbGF0ZVZlcnNpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBzZXJ2aWNlIHRlbXBsYXRlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9MaXN0U2VydmljZVRlbXBsYXRlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VydmljZVRlbXBsYXRlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFNlcnZpY2VUZW1wbGF0ZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHNlcnZpY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RTZXJ2aWNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VydmljZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RTZXJ2aWNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGFncyBvZiBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0xpc3RUYWdzRm9yUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRhZ3NGb3JSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFRhZ3NGb3JSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIG5vdGlmeSBQcm90b24gb2YgcmVzb3VyY2UgZGVwbG95bWVudCBzdGF0dXMgY2hhbmdlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTm90aWZ5UmVzb3VyY2VEZXBsb3ltZW50U3RhdHVzQ2hhbmdlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b05vdGlmeVJlc291cmNlRGVwbG95bWVudFN0YXR1c0NoYW5nZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5UmVzb3VyY2VEZXBsb3ltZW50U3RhdHVzQ2hhbmdlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVqZWN0IGFuIGVudmlyb25tZW50IGFjY291bnQgY29ubmVjdGlvbiByZXF1ZXN0IGZyb20gYW5vdGhlciBlbnZpcm9ubWVudCBhY2NvdW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9SZWplY3RFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1JlamVjdEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlamVjdEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhZGQgdGFncyB0byBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1RhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1RhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdUYWdSZXNvdXJjZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHJlbW92ZSB0YWdzIGZyb20gYSByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VbnRhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VudGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VudGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYWNjb3VudCByb2xlcy4gREVQUkVDQVRFRCAtIHVzZSBVcGRhdGVBY2NvdW50U2V0dGluZ3MgaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUFjY291bnRSb2xlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBY2NvdW50Um9sZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFjY291bnRSb2xlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSB0aGUgYWNjb3VudCBzZXR0aW5nc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUFjY291bnRTZXR0aW5ncy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBY2NvdW50U2V0dGluZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUFjY291bnRTZXR0aW5ncycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBjb21wb25lbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUNvbXBvbmVudC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVDb21wb25lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUNvbXBvbmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhbiBlbnZpcm9ubWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmRW52aXJvbm1lbnRUZW1wbGF0ZSgpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUVudmlyb25tZW50Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUVudmlyb25tZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFbnZpcm9ubWVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhbiBlbnZpcm9ubWVudCBhY2NvdW50IGNvbm5lY3Rpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhbiBlbnZpcm9ubWVudCB0ZW1wbGF0ZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlRW52aXJvbm1lbnRUZW1wbGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuIGVudmlyb25tZW50IHRlbXBsYXRlIG1ham9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgVXBkYXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuIGVudmlyb25tZW50IHRlbXBsYXRlIG1pbm9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgVXBkYXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24gaW5zdGVhZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuIGVudmlyb25tZW50IHRlbXBsYXRlIHZlcnNpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHNlcnZpY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlNlcnZpY2VUZW1wbGF0ZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlU2VydmljZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTZXJ2aWNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgc2VydmljZSBpbnN0YW5jZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmU2VydmljZVRlbXBsYXRlKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlSW5zdGFuY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZUluc3RhbmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlSW5zdGFuY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBzZXJ2aWNlIHBpcGVsaW5lXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZTZXJ2aWNlVGVtcGxhdGUoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVNlcnZpY2VQaXBlbGluZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTZXJ2aWNlUGlwZWxpbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVNlcnZpY2VQaXBlbGluZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIHNlcnZpY2Ugc3luYyBibG9ja2VyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlU3luY0Jsb2NrZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZVN5bmNCbG9ja2VyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlU3luY0Jsb2NrZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBzZXJ2aWNlIHN5bmMgY29uZmlnXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlU3luY0NvbmZpZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTZXJ2aWNlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlU2VydmljZVN5bmNDb25maWcnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBzZXJ2aWNlIHRlbXBsYXRlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlVGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZVRlbXBsYXRlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlVGVtcGxhdGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBzZXJ2aWNlIHRlbXBsYXRlIG1ham9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgVXBkYXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBzZXJ2aWNlIHRlbXBsYXRlIG1pbm9yIHZlcnNpb24uIERFUFJFQ0FURUQgLSB1c2UgVXBkYXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbiBpbnN0ZWFkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVTZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVTZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBzZXJ2aWNlIHRlbXBsYXRlIHZlcnNpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1VwZGF0ZVNlcnZpY2VUZW1wbGF0ZVZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHVwZGF0ZSBhIFRlbXBsYXRlU3luY0NvbmZpZ1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfVXBkYXRlVGVtcGxhdGVTeW5jQ29uZmlnLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVRlbXBsYXRlU3luY0NvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlVGVtcGxhdGVTeW5jQ29uZmlnJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdBY2NlcHRFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uJyxcbiAgICAgICdDYW5jZWxDb21wb25lbnREZXBsb3ltZW50JyxcbiAgICAgICdDYW5jZWxFbnZpcm9ubWVudERlcGxveW1lbnQnLFxuICAgICAgJ0NhbmNlbFNlcnZpY2VJbnN0YW5jZURlcGxveW1lbnQnLFxuICAgICAgJ0NhbmNlbFNlcnZpY2VQaXBlbGluZURlcGxveW1lbnQnLFxuICAgICAgJ0NyZWF0ZUNvbXBvbmVudCcsXG4gICAgICAnQ3JlYXRlRW52aXJvbm1lbnQnLFxuICAgICAgJ0NyZWF0ZUVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24nLFxuICAgICAgJ0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGUnLFxuICAgICAgJ0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb24nLFxuICAgICAgJ0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24nLFxuICAgICAgJ0NyZWF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uJyxcbiAgICAgICdDcmVhdGVSZXBvc2l0b3J5JyxcbiAgICAgICdDcmVhdGVTZXJ2aWNlJyxcbiAgICAgICdDcmVhdGVTZXJ2aWNlSW5zdGFuY2UnLFxuICAgICAgJ0NyZWF0ZVNlcnZpY2VTeW5jQ29uZmlnJyxcbiAgICAgICdDcmVhdGVTZXJ2aWNlVGVtcGxhdGUnLFxuICAgICAgJ0NyZWF0ZVNlcnZpY2VUZW1wbGF0ZU1ham9yVmVyc2lvbicsXG4gICAgICAnQ3JlYXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uJyxcbiAgICAgICdDcmVhdGVTZXJ2aWNlVGVtcGxhdGVWZXJzaW9uJyxcbiAgICAgICdDcmVhdGVUZW1wbGF0ZVN5bmNDb25maWcnLFxuICAgICAgJ0RlbGV0ZUFjY291bnRSb2xlcycsXG4gICAgICAnRGVsZXRlQ29tcG9uZW50JyxcbiAgICAgICdEZWxldGVFbnZpcm9ubWVudCcsXG4gICAgICAnRGVsZXRlRW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbicsXG4gICAgICAnRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZScsXG4gICAgICAnRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbicsXG4gICAgICAnRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbicsXG4gICAgICAnRGVsZXRlRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24nLFxuICAgICAgJ0RlbGV0ZVJlcG9zaXRvcnknLFxuICAgICAgJ0RlbGV0ZVNlcnZpY2UnLFxuICAgICAgJ0RlbGV0ZVNlcnZpY2VTeW5jQ29uZmlnJyxcbiAgICAgICdEZWxldGVTZXJ2aWNlVGVtcGxhdGUnLFxuICAgICAgJ0RlbGV0ZVNlcnZpY2VUZW1wbGF0ZU1ham9yVmVyc2lvbicsXG4gICAgICAnRGVsZXRlU2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uJyxcbiAgICAgICdEZWxldGVTZXJ2aWNlVGVtcGxhdGVWZXJzaW9uJyxcbiAgICAgICdEZWxldGVUZW1wbGF0ZVN5bmNDb25maWcnLFxuICAgICAgJ05vdGlmeVJlc291cmNlRGVwbG95bWVudFN0YXR1c0NoYW5nZScsXG4gICAgICAnUmVqZWN0RW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbicsXG4gICAgICAnVXBkYXRlQWNjb3VudFJvbGVzJyxcbiAgICAgICdVcGRhdGVBY2NvdW50U2V0dGluZ3MnLFxuICAgICAgJ1VwZGF0ZUNvbXBvbmVudCcsXG4gICAgICAnVXBkYXRlRW52aXJvbm1lbnQnLFxuICAgICAgJ1VwZGF0ZUVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb24nLFxuICAgICAgJ1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGUnLFxuICAgICAgJ1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb24nLFxuICAgICAgJ1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24nLFxuICAgICAgJ1VwZGF0ZUVudmlyb25tZW50VGVtcGxhdGVWZXJzaW9uJyxcbiAgICAgICdVcGRhdGVTZXJ2aWNlJyxcbiAgICAgICdVcGRhdGVTZXJ2aWNlSW5zdGFuY2UnLFxuICAgICAgJ1VwZGF0ZVNlcnZpY2VQaXBlbGluZScsXG4gICAgICAnVXBkYXRlU2VydmljZVN5bmNCbG9ja2VyJyxcbiAgICAgICdVcGRhdGVTZXJ2aWNlU3luY0NvbmZpZycsXG4gICAgICAnVXBkYXRlU2VydmljZVRlbXBsYXRlJyxcbiAgICAgICdVcGRhdGVTZXJ2aWNlVGVtcGxhdGVNYWpvclZlcnNpb24nLFxuICAgICAgJ1VwZGF0ZVNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbicsXG4gICAgICAnVXBkYXRlU2VydmljZVRlbXBsYXRlVmVyc2lvbicsXG4gICAgICAnVXBkYXRlVGVtcGxhdGVTeW5jQ29uZmlnJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldEFjY291bnRSb2xlcycsXG4gICAgICAnR2V0QWNjb3VudFNldHRpbmdzJyxcbiAgICAgICdHZXRDb21wb25lbnQnLFxuICAgICAgJ0dldEVudmlyb25tZW50JyxcbiAgICAgICdHZXRFbnZpcm9ubWVudEFjY291bnRDb25uZWN0aW9uJyxcbiAgICAgICdHZXRFbnZpcm9ubWVudFRlbXBsYXRlJyxcbiAgICAgICdHZXRFbnZpcm9ubWVudFRlbXBsYXRlTWFqb3JWZXJzaW9uJyxcbiAgICAgICdHZXRFbnZpcm9ubWVudFRlbXBsYXRlTWlub3JWZXJzaW9uJyxcbiAgICAgICdHZXRFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbicsXG4gICAgICAnR2V0UmVwb3NpdG9yeScsXG4gICAgICAnR2V0UmVwb3NpdG9yeVN5bmNTdGF0dXMnLFxuICAgICAgJ0dldFJlc291cmNlVGVtcGxhdGVWZXJzaW9uU3RhdHVzQ291bnRzJyxcbiAgICAgICdHZXRSZXNvdXJjZXNTdW1tYXJ5JyxcbiAgICAgICdHZXRTZXJ2aWNlJyxcbiAgICAgICdHZXRTZXJ2aWNlSW5zdGFuY2UnLFxuICAgICAgJ0dldFNlcnZpY2VJbnN0YW5jZVN5bmNTdGF0dXMnLFxuICAgICAgJ0dldFNlcnZpY2VTeW5jQmxvY2tlclN1bW1hcnknLFxuICAgICAgJ0dldFNlcnZpY2VTeW5jQ29uZmlnJyxcbiAgICAgICdHZXRTZXJ2aWNlVGVtcGxhdGUnLFxuICAgICAgJ0dldFNlcnZpY2VUZW1wbGF0ZU1ham9yVmVyc2lvbicsXG4gICAgICAnR2V0U2VydmljZVRlbXBsYXRlTWlub3JWZXJzaW9uJyxcbiAgICAgICdHZXRTZXJ2aWNlVGVtcGxhdGVWZXJzaW9uJyxcbiAgICAgICdHZXRUZW1wbGF0ZVN5bmNDb25maWcnLFxuICAgICAgJ0dldFRlbXBsYXRlU3luY1N0YXR1cycsXG4gICAgICAnTGlzdFRhZ3NGb3JSZXNvdXJjZSdcbiAgICBdLFxuICAgIExpc3Q6IFtcbiAgICAgICdMaXN0Q29tcG9uZW50T3V0cHV0cycsXG4gICAgICAnTGlzdENvbXBvbmVudFByb3Zpc2lvbmVkUmVzb3VyY2VzJyxcbiAgICAgICdMaXN0Q29tcG9uZW50cycsXG4gICAgICAnTGlzdEVudmlyb25tZW50QWNjb3VudENvbm5lY3Rpb25zJyxcbiAgICAgICdMaXN0RW52aXJvbm1lbnRPdXRwdXRzJyxcbiAgICAgICdMaXN0RW52aXJvbm1lbnRQcm92aXNpb25lZFJlc291cmNlcycsXG4gICAgICAnTGlzdEVudmlyb25tZW50VGVtcGxhdGVNYWpvclZlcnNpb25zJyxcbiAgICAgICdMaXN0RW52aXJvbm1lbnRUZW1wbGF0ZU1pbm9yVmVyc2lvbnMnLFxuICAgICAgJ0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlVmVyc2lvbnMnLFxuICAgICAgJ0xpc3RFbnZpcm9ubWVudFRlbXBsYXRlcycsXG4gICAgICAnTGlzdEVudmlyb25tZW50cycsXG4gICAgICAnTGlzdFJlcG9zaXRvcmllcycsXG4gICAgICAnTGlzdFJlcG9zaXRvcnlTeW5jRGVmaW5pdGlvbnMnLFxuICAgICAgJ0xpc3RTZXJ2aWNlSW5zdGFuY2VPdXRwdXRzJyxcbiAgICAgICdMaXN0U2VydmljZUluc3RhbmNlUHJvdmlzaW9uZWRSZXNvdXJjZXMnLFxuICAgICAgJ0xpc3RTZXJ2aWNlSW5zdGFuY2VzJyxcbiAgICAgICdMaXN0U2VydmljZVBpcGVsaW5lT3V0cHV0cycsXG4gICAgICAnTGlzdFNlcnZpY2VQaXBlbGluZVByb3Zpc2lvbmVkUmVzb3VyY2VzJyxcbiAgICAgICdMaXN0U2VydmljZVRlbXBsYXRlTWFqb3JWZXJzaW9ucycsXG4gICAgICAnTGlzdFNlcnZpY2VUZW1wbGF0ZU1pbm9yVmVyc2lvbnMnLFxuICAgICAgJ0xpc3RTZXJ2aWNlVGVtcGxhdGVWZXJzaW9ucycsXG4gICAgICAnTGlzdFNlcnZpY2VUZW1wbGF0ZXMnLFxuICAgICAgJ0xpc3RTZXJ2aWNlcydcbiAgICBdLFxuICAgIFRhZ2dpbmc6IFtcbiAgICAgICdUYWdSZXNvdXJjZScsXG4gICAgICAnVW50YWdSZXNvdXJjZSdcbiAgICBdXG4gIH07XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGVudmlyb25tZW50LXRlbXBsYXRlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvYWRtaW5ndWlkZS9hZy1lbnYtdGVtcGxhdGVzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIG5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgbmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkVudmlyb25tZW50VGVtcGxhdGUobmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IFByb3Rvbi5kZWZhdWx0UGFydGl0aW9uIH06cHJvdG9uOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmVudmlyb25tZW50LXRlbXBsYXRlLyR7IG5hbWUgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGVudmlyb25tZW50LXRlbXBsYXRlLXZlcnNpb24gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9hZG1pbmd1aWRlL2FnLWVudi10ZW1wbGF0ZXMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdGVtcGxhdGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRlbXBsYXRlTmFtZS5cbiAgICogQHBhcmFtIG1ham9yVmVyc2lvbiAtIElkZW50aWZpZXIgZm9yIHRoZSBtYWpvclZlcnNpb24uXG4gICAqIEBwYXJhbSBtaW5vclZlcnNpb24gLSBJZGVudGlmaWVyIGZvciB0aGUgbWlub3JWZXJzaW9uLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRW52aXJvbm1lbnRUZW1wbGF0ZVZlcnNpb24odGVtcGxhdGVOYW1lOiBzdHJpbmcsIG1ham9yVmVyc2lvbjogc3RyaW5nLCBtaW5vclZlcnNpb246IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTplbnZpcm9ubWVudC10ZW1wbGF0ZS8keyB0ZW1wbGF0ZU5hbWUgfTokeyBtYWpvclZlcnNpb24gfS4keyBtaW5vclZlcnNpb24gfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGVudmlyb25tZW50LXRlbXBsYXRlLW1ham9yLXZlcnNpb24gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9hZG1pbmd1aWRlL2FnLWVudi10ZW1wbGF0ZXMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdGVtcGxhdGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRlbXBsYXRlTmFtZS5cbiAgICogQHBhcmFtIG1ham9yVmVyc2lvbklkIC0gSWRlbnRpZmllciBmb3IgdGhlIG1ham9yVmVyc2lvbklkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRW52aXJvbm1lbnRUZW1wbGF0ZU1ham9yVmVyc2lvbih0ZW1wbGF0ZU5hbWU6IHN0cmluZywgbWFqb3JWZXJzaW9uSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTplbnZpcm9ubWVudC10ZW1wbGF0ZS8keyB0ZW1wbGF0ZU5hbWUgfTokeyBtYWpvclZlcnNpb25JZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgZW52aXJvbm1lbnQtdGVtcGxhdGUtbWlub3ItdmVyc2lvbiB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L2FkbWluZ3VpZGUvYWctZW52LXRlbXBsYXRlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSB0ZW1wbGF0ZU5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgdGVtcGxhdGVOYW1lLlxuICAgKiBAcGFyYW0gbWFqb3JWZXJzaW9uSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgbWFqb3JWZXJzaW9uSWQuXG4gICAqIEBwYXJhbSBtaW5vclZlcnNpb25JZCAtIElkZW50aWZpZXIgZm9yIHRoZSBtaW5vclZlcnNpb25JZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkVudmlyb25tZW50VGVtcGxhdGVNaW5vclZlcnNpb24odGVtcGxhdGVOYW1lOiBzdHJpbmcsIG1ham9yVmVyc2lvbklkOiBzdHJpbmcsIG1pbm9yVmVyc2lvbklkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgUHJvdG9uLmRlZmF1bHRQYXJ0aXRpb24gfTpwcm90b246JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06ZW52aXJvbm1lbnQtdGVtcGxhdGUvJHsgdGVtcGxhdGVOYW1lIH06JHsgbWFqb3JWZXJzaW9uSWQgfS4keyBtaW5vclZlcnNpb25JZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgc2VydmljZS10ZW1wbGF0ZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L2FkbWluZ3VpZGUvbWFuYWdpbmctc3ZjLXRlbXBsYXRlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBuYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIG5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25TZXJ2aWNlVGVtcGxhdGUobmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IFByb3Rvbi5kZWZhdWx0UGFydGl0aW9uIH06cHJvdG9uOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OnNlcnZpY2UtdGVtcGxhdGUvJHsgbmFtZSB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgc2VydmljZS10ZW1wbGF0ZS12ZXJzaW9uIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvYWRtaW5ndWlkZS9tYW5hZ2luZy1zdmMtdGVtcGxhdGVzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHRlbXBsYXRlTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSB0ZW1wbGF0ZU5hbWUuXG4gICAqIEBwYXJhbSBtYWpvclZlcnNpb24gLSBJZGVudGlmaWVyIGZvciB0aGUgbWFqb3JWZXJzaW9uLlxuICAgKiBAcGFyYW0gbWlub3JWZXJzaW9uIC0gSWRlbnRpZmllciBmb3IgdGhlIG1pbm9yVmVyc2lvbi5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblNlcnZpY2VUZW1wbGF0ZVZlcnNpb24odGVtcGxhdGVOYW1lOiBzdHJpbmcsIG1ham9yVmVyc2lvbjogc3RyaW5nLCBtaW5vclZlcnNpb246IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpzZXJ2aWNlLXRlbXBsYXRlLyR7IHRlbXBsYXRlTmFtZSB9OiR7IG1ham9yVmVyc2lvbiB9LiR7IG1pbm9yVmVyc2lvbiB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgc2VydmljZS10ZW1wbGF0ZS1tYWpvci12ZXJzaW9uIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvYWRtaW5ndWlkZS9tYW5hZ2luZy1zdmMtdGVtcGxhdGVzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHRlbXBsYXRlTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSB0ZW1wbGF0ZU5hbWUuXG4gICAqIEBwYXJhbSBtYWpvclZlcnNpb25JZCAtIElkZW50aWZpZXIgZm9yIHRoZSBtYWpvclZlcnNpb25JZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblNlcnZpY2VUZW1wbGF0ZU1ham9yVmVyc2lvbih0ZW1wbGF0ZU5hbWU6IHN0cmluZywgbWFqb3JWZXJzaW9uSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpzZXJ2aWNlLXRlbXBsYXRlLyR7IHRlbXBsYXRlTmFtZSB9OiR7IG1ham9yVmVyc2lvbklkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzZXJ2aWNlLXRlbXBsYXRlLW1pbm9yLXZlcnNpb24gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9hZG1pbmd1aWRlL21hbmFnaW5nLXN2Yy10ZW1wbGF0ZXMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdGVtcGxhdGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRlbXBsYXRlTmFtZS5cbiAgICogQHBhcmFtIG1ham9yVmVyc2lvbklkIC0gSWRlbnRpZmllciBmb3IgdGhlIG1ham9yVmVyc2lvbklkLlxuICAgKiBAcGFyYW0gbWlub3JWZXJzaW9uSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgbWlub3JWZXJzaW9uSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25TZXJ2aWNlVGVtcGxhdGVNaW5vclZlcnNpb24odGVtcGxhdGVOYW1lOiBzdHJpbmcsIG1ham9yVmVyc2lvbklkOiBzdHJpbmcsIG1pbm9yVmVyc2lvbklkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgUHJvdG9uLmRlZmF1bHRQYXJ0aXRpb24gfTpwcm90b246JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06c2VydmljZS10ZW1wbGF0ZS8keyB0ZW1wbGF0ZU5hbWUgfTokeyBtYWpvclZlcnNpb25JZCB9LiR7IG1pbm9yVmVyc2lvbklkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBlbnZpcm9ubWVudCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L2FkbWluZ3VpZGUvYWctZW52aXJvbm1lbnRzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIG5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgbmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkVudmlyb25tZW50KG5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTplbnZpcm9ubWVudC8keyBuYW1lIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzZXJ2aWNlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3Byb3Rvbi9sYXRlc3QvYWRtaW5ndWlkZS9hZy1zZXJ2aWNlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBuYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIG5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25TZXJ2aWNlKG5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpzZXJ2aWNlLyR7IG5hbWUgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHNlcnZpY2UtaW5zdGFuY2UgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9hZG1pbmd1aWRlL2FnLXNlcnZpY2VzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHNlcnZpY2VOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHNlcnZpY2VOYW1lLlxuICAgKiBAcGFyYW0gbmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBuYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uU2VydmljZUluc3RhbmNlKHNlcnZpY2VOYW1lOiBzdHJpbmcsIG5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBQcm90b24uZGVmYXVsdFBhcnRpdGlvbiB9OnByb3RvbjokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTpzZXJ2aWNlLyR7IHNlcnZpY2VOYW1lIH0vc2VydmljZS1pbnN0YW5jZS8keyBuYW1lIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBlbnZpcm9ubWVudC1hY2NvdW50LWNvbm5lY3Rpb24gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcHJvdG9uL2xhdGVzdC9hZG1pbmd1aWRlL2FnLWVudi1hY2NvdW50LWNvbm5lY3Rpb25zLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGlkIC0gSWRlbnRpZmllciBmb3IgdGhlIGlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRW52aXJvbm1lbnRBY2NvdW50Q29ubmVjdGlvbihpZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IFByb3Rvbi5kZWZhdWx0UGFydGl0aW9uIH06cHJvdG9uOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmVudmlyb25tZW50LWFjY291bnQtY29ubmVjdGlvbi8keyBpZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgcmVwb3NpdG9yeSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L2FkbWluZ3VpZGUvYWctcmVwb3NpdG9yaWVzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHByb3ZpZGVyIC0gSWRlbnRpZmllciBmb3IgdGhlIHByb3ZpZGVyLlxuICAgKiBAcGFyYW0gbmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBuYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uUmVwb3NpdG9yeShwcm92aWRlcjogc3RyaW5nLCBuYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgUHJvdG9uLmRlZmF1bHRQYXJ0aXRpb24gfTpwcm90b246JHsgcmVnaW9uIHx8ICcqJyB9OiR7IGFjY291bnQgfHwgJyonIH06cmVwb3NpdG9yeS8keyBwcm92aWRlciB9OiR7IG5hbWUgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGNvbXBvbmVudCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9wcm90b24vbGF0ZXN0L2FkbWluZ3VpZGUvYWctY29tcG9uZW50cy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBpZCAtIElkZW50aWZpZXIgZm9yIHRoZSBpZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkNvbXBvbmVudChpZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IFByb3Rvbi5kZWZhdWx0UGFydGl0aW9uIH06cHJvdG9uOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmNvbXBvbmVudC8keyBpZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogRmlsdGVycyBhY2Nlc3MgYnkgc3BlY2lmaWVkIGVudmlyb25tZW50IHRlbXBsYXRlIHJlbGF0ZWQgdG8gcmVzb3VyY2VcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19jb25kaXRpb24ta2V5cy5odG1sXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gYWN0aW9uczpcbiAgICogLSAudG9DYW5jZWxFbnZpcm9ubWVudERlcGxveW1lbnQoKVxuICAgKiAtIC50b0NyZWF0ZUVudmlyb25tZW50KClcbiAgICogLSAudG9EZWxldGVFbnZpcm9ubWVudCgpXG4gICAqIC0gLnRvVXBkYXRlRW52aXJvbm1lbnQoKVxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlKHMpIHRvIGNoZWNrXG4gICAqIEBwYXJhbSBvcGVyYXRvciBXb3JrcyB3aXRoIFtzdHJpbmcgb3BlcmF0b3JzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX2NvbmRpdGlvbl9vcGVyYXRvcnMuaHRtbCNDb25kaXRpb25zX1N0cmluZykuICoqRGVmYXVsdDoqKiBgU3RyaW5nTGlrZWBcbiAgICovXG4gIHB1YmxpYyBpZkVudmlyb25tZW50VGVtcGxhdGUodmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYEVudmlyb25tZW50VGVtcGxhdGVgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSBzcGVjaWZpZWQgc2VydmljZSB0ZW1wbGF0ZSByZWxhdGVkIHRvIHJlc291cmNlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfY29uZGl0aW9uLWtleXMuaHRtbFxuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvQ2FuY2VsU2VydmljZUluc3RhbmNlRGVwbG95bWVudCgpXG4gICAqIC0gLnRvQ2FuY2VsU2VydmljZVBpcGVsaW5lRGVwbG95bWVudCgpXG4gICAqIC0gLnRvQ3JlYXRlU2VydmljZSgpXG4gICAqIC0gLnRvQ3JlYXRlU2VydmljZUluc3RhbmNlKClcbiAgICogLSAudG9EZWxldGVTZXJ2aWNlKClcbiAgICogLSAudG9VcGRhdGVTZXJ2aWNlKClcbiAgICogLSAudG9VcGRhdGVTZXJ2aWNlSW5zdGFuY2UoKVxuICAgKiAtIC50b1VwZGF0ZVNlcnZpY2VQaXBlbGluZSgpXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmU2VydmljZVRlbXBsYXRlKHZhbHVlOiBzdHJpbmcgfCBzdHJpbmdbXSwgb3BlcmF0b3I/OiBPcGVyYXRvciB8IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLmlmKGBTZXJ2aWNlVGVtcGxhdGVgLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxufVxuIl19