"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmContacts = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SsmContacts extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ssm-contacts](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanagercontacts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ssm-contacts';
        this.accessLevelList = {
            Write: [
                'AcceptPage',
                'ActivateContactChannel',
                'CreateContact',
                'CreateContactChannel',
                'CreateRotation',
                'CreateRotationOverride',
                'DeactivateContactChannel',
                'DeleteContact',
                'DeleteContactChannel',
                'DeleteRotation',
                'DeleteRotationOverride',
                'PutContactPolicy',
                'SendActivationCode',
                'StartEngagement',
                'StopEngagement',
                'UpdateContact',
                'UpdateContactChannel',
                'UpdateRotation'
            ],
            'Permissions management': [
                'AssociateContact'
            ],
            Read: [
                'DescribeEngagement',
                'DescribePage',
                'GetContact',
                'GetContactChannel',
                'GetContactPolicy',
                'GetRotation',
                'GetRotationOverride',
                'ListTagsForResource'
            ],
            List: [
                'ListContactChannels',
                'ListContacts',
                'ListEngagements',
                'ListPageReceipts',
                'ListPagesByContact',
                'ListPagesByEngagement',
                'ListPreviewRotationShifts',
                'ListRotationOverrides',
                'ListRotationShifts',
                'ListRotations'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to accept a page
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_AcceptPage.html
     */
    toAcceptPage() {
        return this.to('AcceptPage');
    }
    /**
     * Grants permission to activate a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ActivateContactChannel.html
     */
    toActivateContactChannel() {
        return this.to('ActivateContactChannel');
    }
    /**
     * Grants permission to use a contact in an escalation plan
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/contacts.html
     */
    toAssociateContact() {
        return this.to('AssociateContact');
    }
    /**
     * Grants permission to create a contact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateContact.html
     */
    toCreateContact() {
        return this.to('CreateContact');
    }
    /**
     * Grants permission to create a contact channel for a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateContactChannel.html
     */
    toCreateContactChannel() {
        return this.to('CreateContactChannel');
    }
    /**
     * Grants permission to create a rotation in an on-call schedule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateRotation.html
     */
    toCreateRotation() {
        return this.to('CreateRotation');
    }
    /**
     * Grants permission to create an override for a rotation in an on-call schedule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_CreateRotationOverride.html
     */
    toCreateRotationOverride() {
        return this.to('CreateRotationOverride');
    }
    /**
     * Grants permission to deactivate a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeactivateContactChannel.html
     */
    toDeactivateContactChannel() {
        return this.to('DeactivateContactChannel');
    }
    /**
     * Grants permission to delete a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteContact.html
     */
    toDeleteContact() {
        return this.to('DeleteContact');
    }
    /**
     * Grants permission to delete a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteContactChannel.html
     */
    toDeleteContactChannel() {
        return this.to('DeleteContactChannel');
    }
    /**
     * Grants permission to delete a rotation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteRotation.html
     */
    toDeleteRotation() {
        return this.to('DeleteRotation');
    }
    /**
     * Grants permission to delete a rotation's rotation override
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DeleteRotationOverride.html
     */
    toDeleteRotationOverride() {
        return this.to('DeleteRotationOverride');
    }
    /**
     * Grants permission to describe an engagement
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DescribeEngagement.html
     */
    toDescribeEngagement() {
        return this.to('DescribeEngagement');
    }
    /**
     * Grants permission to describe a page
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_DescribePage.html
     */
    toDescribePage() {
        return this.to('DescribePage');
    }
    /**
     * Grants permission to get a contact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContact.html
     */
    toGetContact() {
        return this.to('GetContact');
    }
    /**
     * Grants permission to get a contact's contact channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContactChannel.html
     */
    toGetContactChannel() {
        return this.to('GetContactChannel');
    }
    /**
     * Grants permission to get a contact's resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetContactPolicy.html
     */
    toGetContactPolicy() {
        return this.to('GetContactPolicy');
    }
    /**
     * Grants permission to retrieve information about an on-call rotation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetRotation.html
     */
    toGetRotation() {
        return this.to('GetRotation');
    }
    /**
     * Grants permission to retrieve information about an override in an on-call rotation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_GetRotationOverride.html
     */
    toGetRotationOverride() {
        return this.to('GetRotationOverride');
    }
    /**
     * Grants permission to list all of a contact's contact channels
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListContactChannels.html
     */
    toListContactChannels() {
        return this.to('ListContactChannels');
    }
    /**
     * Grants permission to list all contacts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListContacts.html
     */
    toListContacts() {
        return this.to('ListContacts');
    }
    /**
     * Grants permission to list all engagements
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListEngagements.html
     */
    toListEngagements() {
        return this.to('ListEngagements');
    }
    /**
     * Grants permission to list all receipts of a page
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPageReceipts.html
     */
    toListPageReceipts() {
        return this.to('ListPageReceipts');
    }
    /**
     * Grants permission to list all pages sent to a contact
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPagesByContact.html
     */
    toListPagesByContact() {
        return this.to('ListPagesByContact');
    }
    /**
     * Grants permission to list all pages created in an engagement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPagesByEngagement.html
     */
    toListPagesByEngagement() {
        return this.to('ListPagesByEngagement');
    }
    /**
     * Grants permission to retrieve a list of shifts based on rotation configuration parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListPreviewRotationShifts.html
     */
    toListPreviewRotationShifts() {
        return this.to('ListPreviewRotationShifts');
    }
    /**
     * Grants permission to retrieve a list of overrides currently specified for an on-call rotation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListRotationOverrides.html
     */
    toListRotationOverrides() {
        return this.to('ListRotationOverrides');
    }
    /**
     * Grants permission to retrieve a list of rotation shifts in an on-call schedule
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListRotationShifts.html
     */
    toListRotationShifts() {
        return this.to('ListRotationShifts');
    }
    /**
     * Grants permission to retrieve a list of on-call rotations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListRotations.html
     */
    toListRotations() {
        return this.to('ListRotations');
    }
    /**
     * Grants permission to view a list of resource tags for a specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to add a resource policy to a contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_PutContactPolicy.html
     */
    toPutContactPolicy() {
        return this.to('PutContactPolicy');
    }
    /**
     * Grants permission to send the activation code of a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_SendActivationCode.html
     */
    toSendActivationCode() {
        return this.to('SendActivationCode');
    }
    /**
     * Grants permission to start an engagement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_StartEngagement.html
     */
    toStartEngagement() {
        return this.to('StartEngagement');
    }
    /**
     * Grants permission to stop an engagement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_StopEngagement.html
     */
    toStopEngagement() {
        return this.to('StopEngagement');
    }
    /**
     * Grants permission to add tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a contact
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ssm-contacts:AssociateContact
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateContact.html
     */
    toUpdateContact() {
        return this.to('UpdateContact');
    }
    /**
     * Grants permission to update a contact's contact channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateContactChannel.html
     */
    toUpdateContactChannel() {
        return this.to('UpdateContactChannel');
    }
    /**
     * Grants permission to update the information specified for an on-call rotation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_UpdateRotation.html
     */
    toUpdateRotation() {
        return this.to('UpdateRotation');
    }
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContact(contactAlias, account, region, partition) {
        return this.on(`arn:${partition || SsmContacts.defaultPartition}:ssm-contacts:${region || '*'}:${account || '*'}:contact/${contactAlias}`);
    }
    /**
     * Adds a resource of type contactchannel to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/contacts.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param contactChannelId - Identifier for the contactChannelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onContactchannel(contactAlias, contactChannelId, account, region, partition) {
        return this.on(`arn:${partition || SsmContacts.defaultPartition}:ssm-contacts:${region || '*'}:${account || '*'}:contactchannel/${contactAlias}/${contactChannelId}`);
    }
    /**
     * Adds a resource of type engagement to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/escalation.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param engagementId - Identifier for the engagementId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEngagement(contactAlias, engagementId, account, region, partition) {
        return this.on(`arn:${partition || SsmContacts.defaultPartition}:ssm-contacts:${region || '*'}:${account || '*'}:engagement/${contactAlias}/${engagementId}`);
    }
    /**
     * Adds a resource of type page to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/escalation.html
     *
     * @param contactAlias - Identifier for the contactAlias.
     * @param pageId - Identifier for the pageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPage(contactAlias, pageId, account, region, partition) {
        return this.on(`arn:${partition || SsmContacts.defaultPartition}:ssm-contacts:${region || '*'}:${account || '*'}:page/${contactAlias}/${pageId}`);
    }
    /**
     * Adds a resource of type rotation to the statement
     *
     * https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-on-call-schedule.html
     *
     * @param rotationId - Identifier for the rotationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRotation(rotationId, account, region, partition) {
        return this.on(`arn:${partition || SsmContacts.defaultPartition}:ssm-contacts:${region || '*'}:${account || '*'}:rotation/${rotationId}`);
    }
}
exports.SsmContacts = SsmContacts;
_a = JSII_RTTI_SYMBOL_1;
SsmContacts[_a] = { fqn: "iam-floyd.SsmContacts", version: "0.504.0" };
//# sourceMappingURL=data:application/json;base64,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