"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Provider = exports.ProviderBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const DEFAULTS = {
    issuer: 'token.actions.githubusercontent.com',
    thumbprint: 'a031c46782e6e6c662c2c87c76da9aa62ccabd8e',
};
class ProviderBase extends aws_cdk_lib_1.Resource {
    /**
     *
     * @param repo a list of repositories
     * @returns a list of subjects
     */
    formatSubject(repo) {
        return repo.map(r => `repo:${r.owner}/${r.repo}:${r.filter ?? '*'}`);
    }
    createRole(id, repo, roleProps) {
        if (repo.length == 0) {
            throw new Error('Error - at least one repository is required');
        }
        const role = new aws_cdk_lib_1.aws_iam.Role(this, id, {
            ...roleProps,
            assumedBy: new aws_cdk_lib_1.aws_iam.OpenIdConnectPrincipal(this.openIdConnectProvider, {
                StringLike: {
                    [`${DEFAULTS.issuer}:sub`]: this.formatSubject(repo),
                },
            }),
        });
        return role;
    }
}
exports.ProviderBase = ProviderBase;
_a = JSII_RTTI_SYMBOL_1;
ProviderBase[_a] = { fqn: "@pahud/cdk-github-oidc.ProviderBase", version: "0.0.207" };
/**
 * The Github OpenID Connect Provider
 */
class Provider extends ProviderBase {
    constructor(scope, id) {
        super(scope, id);
        this.issuer = DEFAULTS.issuer;
        this.openIdConnectProvider = new aws_cdk_lib_1.aws_iam.OpenIdConnectProvider(this, `Provider${id}`, {
            url: `https://${DEFAULTS.issuer}`,
            clientIds: ['sts.amazonaws.com'],
            thumbprints: [`${DEFAULTS.thumbprint}`],
        });
    }
    /**
     * import the existing provider
     */
    static fromAccount(scope, id) {
        class Import extends ProviderBase {
            constructor(s, i) {
                super(s, i);
                // arn:aws:iam::xxxxxxxxxxxx:oidc-provider/token.actions.githubusercontent.com
                const arn = aws_cdk_lib_1.Stack.of(scope).formatArn({
                    resource: 'oidc-provider',
                    service: 'iam',
                    region: '',
                    resourceName: DEFAULTS.issuer,
                });
                this.openIdConnectProvider = aws_cdk_lib_1.aws_iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(scope, `Provider${id}`, arn);
            }
        }
        return new Import(scope, id);
    }
}
exports.Provider = Provider;
_b = JSII_RTTI_SYMBOL_1;
Provider[_b] = { fqn: "@pahud/cdk-github-oidc.Provider", version: "0.0.207" };
//# sourceMappingURL=data:application/json;base64,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