# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr
from typing import Any, List, Optional
from typing_extensions import Annotated
from legit_api_client.models.collaborator_dto import CollaboratorDto
from legit_api_client.models.collaborator_repository_permission import CollaboratorRepositoryPermission
from legit_api_client.models.repository_visibility import RepositoryVisibility

from legit_api_client.api_client import ApiClient, RequestSerialized
from legit_api_client.api_response import ApiResponse
from legit_api_client.rest import RESTResponseType


class CollaboratorsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v10_collaborators_get(
        self,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        is_admin: Optional[StrictBool] = None,
        is_external_to_all: Optional[StrictBool] = None,
        is_ai_assistant_user: Optional[StrictBool] = None,
        is_owner: Optional[StrictBool] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CollaboratorDto]:
        """Get all collaborators


        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param integration_ids:
        :type integration_ids: List[str]
        :param is_admin:
        :type is_admin: bool
        :param is_external_to_all:
        :type is_external_to_all: bool
        :param is_ai_assistant_user:
        :type is_ai_assistant_user: bool
        :param is_owner:
        :type is_owner: bool
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_get_serialize(
            sort_column=sort_column,
            sort_direction=sort_direction,
            integration_ids=integration_ids,
            is_admin=is_admin,
            is_external_to_all=is_external_to_all,
            is_ai_assistant_user=is_ai_assistant_user,
            is_owner=is_owner,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorDto]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v10_collaborators_get_with_http_info(
        self,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        is_admin: Optional[StrictBool] = None,
        is_external_to_all: Optional[StrictBool] = None,
        is_ai_assistant_user: Optional[StrictBool] = None,
        is_owner: Optional[StrictBool] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CollaboratorDto]]:
        """Get all collaborators


        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param integration_ids:
        :type integration_ids: List[str]
        :param is_admin:
        :type is_admin: bool
        :param is_external_to_all:
        :type is_external_to_all: bool
        :param is_ai_assistant_user:
        :type is_ai_assistant_user: bool
        :param is_owner:
        :type is_owner: bool
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_get_serialize(
            sort_column=sort_column,
            sort_direction=sort_direction,
            integration_ids=integration_ids,
            is_admin=is_admin,
            is_external_to_all=is_external_to_all,
            is_ai_assistant_user=is_ai_assistant_user,
            is_owner=is_owner,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorDto]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v10_collaborators_get_without_preload_content(
        self,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        is_admin: Optional[StrictBool] = None,
        is_external_to_all: Optional[StrictBool] = None,
        is_ai_assistant_user: Optional[StrictBool] = None,
        is_owner: Optional[StrictBool] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all collaborators


        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param integration_ids:
        :type integration_ids: List[str]
        :param is_admin:
        :type is_admin: bool
        :param is_external_to_all:
        :type is_external_to_all: bool
        :param is_ai_assistant_user:
        :type is_ai_assistant_user: bool
        :param is_owner:
        :type is_owner: bool
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_get_serialize(
            sort_column=sort_column,
            sort_direction=sort_direction,
            integration_ids=integration_ids,
            is_admin=is_admin,
            is_external_to_all=is_external_to_all,
            is_ai_assistant_user=is_ai_assistant_user,
            is_owner=is_owner,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorDto]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v10_collaborators_get_serialize(
        self,
        sort_column,
        sort_direction,
        integration_ids,
        is_admin,
        is_external_to_all,
        is_ai_assistant_user,
        is_owner,
        page_number,
        page_size,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'integrationIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sort_column is not None:
            
            _query_params.append(('sortColumn', sort_column))
            
        if sort_direction is not None:
            
            _query_params.append(('sortDirection', sort_direction.value))
            
        if integration_ids is not None:
            
            _query_params.append(('integrationIds', integration_ids))
            
        if is_admin is not None:
            
            _query_params.append(('isAdmin', is_admin))
            
        if is_external_to_all is not None:
            
            _query_params.append(('isExternalToAll', is_external_to_all))
            
        if is_ai_assistant_user is not None:
            
            _query_params.append(('isAiAssistantUser', is_ai_assistant_user))
            
        if is_owner is not None:
            
            _query_params.append(('isOwner', is_owner))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1.0/collaborators',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v10_collaborators_id_get(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CollaboratorDto:
        """Get collaborator by id


        :param id: (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CollaboratorDto",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v10_collaborators_id_get_with_http_info(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CollaboratorDto]:
        """Get collaborator by id


        :param id: (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CollaboratorDto",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v10_collaborators_id_get_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get collaborator by id


        :param id: (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_get_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CollaboratorDto",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v10_collaborators_id_get_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1.0/collaborators/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v10_collaborators_id_permissions_get(
        self,
        id: StrictStr,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        is_active: Optional[StrictBool] = None,
        is_archived: Optional[StrictBool] = None,
        repository_visibilities: Optional[List[RepositoryVisibility]] = None,
        product_unit_ids: Optional[List[StrictStr]] = None,
        any_product_units: Optional[StrictBool] = None,
        tag_ids: Optional[List[StrictStr]] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        owner_ids: Optional[List[StrictStr]] = None,
        workspace_ids: Optional[List[StrictStr]] = None,
        repository_groups_ids: Optional[List[StrictStr]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CollaboratorRepositoryPermission]:
        """Get collaborator permissions


        :param id: (required)
        :type id: str
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param is_active:
        :type is_active: bool
        :param is_archived:
        :type is_archived: bool
        :param repository_visibilities:
        :type repository_visibilities: List[RepositoryVisibility]
        :param product_unit_ids:
        :type product_unit_ids: List[str]
        :param any_product_units:
        :type any_product_units: bool
        :param tag_ids:
        :type tag_ids: List[str]
        :param integration_ids:
        :type integration_ids: List[str]
        :param owner_ids:
        :type owner_ids: List[str]
        :param workspace_ids:
        :type workspace_ids: List[str]
        :param repository_groups_ids:
        :type repository_groups_ids: List[str]
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_permissions_get_serialize(
            id=id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            is_active=is_active,
            is_archived=is_archived,
            repository_visibilities=repository_visibilities,
            product_unit_ids=product_unit_ids,
            any_product_units=any_product_units,
            tag_ids=tag_ids,
            integration_ids=integration_ids,
            owner_ids=owner_ids,
            workspace_ids=workspace_ids,
            repository_groups_ids=repository_groups_ids,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorRepositoryPermission]",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v10_collaborators_id_permissions_get_with_http_info(
        self,
        id: StrictStr,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        is_active: Optional[StrictBool] = None,
        is_archived: Optional[StrictBool] = None,
        repository_visibilities: Optional[List[RepositoryVisibility]] = None,
        product_unit_ids: Optional[List[StrictStr]] = None,
        any_product_units: Optional[StrictBool] = None,
        tag_ids: Optional[List[StrictStr]] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        owner_ids: Optional[List[StrictStr]] = None,
        workspace_ids: Optional[List[StrictStr]] = None,
        repository_groups_ids: Optional[List[StrictStr]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CollaboratorRepositoryPermission]]:
        """Get collaborator permissions


        :param id: (required)
        :type id: str
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param is_active:
        :type is_active: bool
        :param is_archived:
        :type is_archived: bool
        :param repository_visibilities:
        :type repository_visibilities: List[RepositoryVisibility]
        :param product_unit_ids:
        :type product_unit_ids: List[str]
        :param any_product_units:
        :type any_product_units: bool
        :param tag_ids:
        :type tag_ids: List[str]
        :param integration_ids:
        :type integration_ids: List[str]
        :param owner_ids:
        :type owner_ids: List[str]
        :param workspace_ids:
        :type workspace_ids: List[str]
        :param repository_groups_ids:
        :type repository_groups_ids: List[str]
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_permissions_get_serialize(
            id=id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            is_active=is_active,
            is_archived=is_archived,
            repository_visibilities=repository_visibilities,
            product_unit_ids=product_unit_ids,
            any_product_units=any_product_units,
            tag_ids=tag_ids,
            integration_ids=integration_ids,
            owner_ids=owner_ids,
            workspace_ids=workspace_ids,
            repository_groups_ids=repository_groups_ids,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorRepositoryPermission]",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v10_collaborators_id_permissions_get_without_preload_content(
        self,
        id: StrictStr,
        sort_column: Optional[StrictStr] = None,
        sort_direction: Optional[Any] = None,
        is_active: Optional[StrictBool] = None,
        is_archived: Optional[StrictBool] = None,
        repository_visibilities: Optional[List[RepositoryVisibility]] = None,
        product_unit_ids: Optional[List[StrictStr]] = None,
        any_product_units: Optional[StrictBool] = None,
        tag_ids: Optional[List[StrictStr]] = None,
        integration_ids: Optional[List[StrictStr]] = None,
        owner_ids: Optional[List[StrictStr]] = None,
        workspace_ids: Optional[List[StrictStr]] = None,
        repository_groups_ids: Optional[List[StrictStr]] = None,
        page_number: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=1)]] = None,
        page_size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None,
        search: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get collaborator permissions


        :param id: (required)
        :type id: str
        :param sort_column:
        :type sort_column: str
        :param sort_direction:
        :type sort_direction: ListSortDirection
        :param is_active:
        :type is_active: bool
        :param is_archived:
        :type is_archived: bool
        :param repository_visibilities:
        :type repository_visibilities: List[RepositoryVisibility]
        :param product_unit_ids:
        :type product_unit_ids: List[str]
        :param any_product_units:
        :type any_product_units: bool
        :param tag_ids:
        :type tag_ids: List[str]
        :param integration_ids:
        :type integration_ids: List[str]
        :param owner_ids:
        :type owner_ids: List[str]
        :param workspace_ids:
        :type workspace_ids: List[str]
        :param repository_groups_ids:
        :type repository_groups_ids: List[str]
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param search:
        :type search: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v10_collaborators_id_permissions_get_serialize(
            id=id,
            sort_column=sort_column,
            sort_direction=sort_direction,
            is_active=is_active,
            is_archived=is_archived,
            repository_visibilities=repository_visibilities,
            product_unit_ids=product_unit_ids,
            any_product_units=any_product_units,
            tag_ids=tag_ids,
            integration_ids=integration_ids,
            owner_ids=owner_ids,
            workspace_ids=workspace_ids,
            repository_groups_ids=repository_groups_ids,
            page_number=page_number,
            page_size=page_size,
            search=search,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CollaboratorRepositoryPermission]",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v10_collaborators_id_permissions_get_serialize(
        self,
        id,
        sort_column,
        sort_direction,
        is_active,
        is_archived,
        repository_visibilities,
        product_unit_ids,
        any_product_units,
        tag_ids,
        integration_ids,
        owner_ids,
        workspace_ids,
        repository_groups_ids,
        page_number,
        page_size,
        search,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'repositoryVisibilities': 'multi',
            'productUnitIds': 'multi',
            'tagIds': 'multi',
            'integrationIds': 'multi',
            'ownerIds': 'multi',
            'workspaceIds': 'multi',
            'repositoryGroupsIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if sort_column is not None:
            
            _query_params.append(('sortColumn', sort_column))
            
        if sort_direction is not None:
            
            _query_params.append(('sortDirection', sort_direction.value))
            
        if is_active is not None:
            
            _query_params.append(('isActive', is_active))
            
        if is_archived is not None:
            
            _query_params.append(('isArchived', is_archived))
            
        if repository_visibilities is not None:
            
            _query_params.append(('repositoryVisibilities', repository_visibilities))
            
        if product_unit_ids is not None:
            
            _query_params.append(('productUnitIds', product_unit_ids))
            
        if any_product_units is not None:
            
            _query_params.append(('anyProductUnits', any_product_units))
            
        if tag_ids is not None:
            
            _query_params.append(('tagIds', tag_ids))
            
        if integration_ids is not None:
            
            _query_params.append(('integrationIds', integration_ids))
            
        if owner_ids is not None:
            
            _query_params.append(('ownerIds', owner_ids))
            
        if workspace_ids is not None:
            
            _query_params.append(('workspaceIds', workspace_ids))
            
        if repository_groups_ids is not None:
            
            _query_params.append(('repositoryGroupsIds', repository_groups_ids))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1.0/collaborators/{id}/permissions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


