# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from legit_api_client.models.product_unit_type import ProductUnitType
from legit_api_client.models.repository_directory import RepositoryDirectory
from typing import Optional, Set
from typing_extensions import Self

class CreateProductUnitDto(BaseModel):
    """
    CreateProductUnitDto
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    description: Optional[StrictStr] = None
    workspace_id: Optional[StrictStr] = Field(default=None, alias="workspaceId")
    type: Optional[ProductUnitType] = None
    repository_ids: Optional[List[StrictStr]] = Field(default=None, alias="repositoryIds")
    repository_group_ids: Optional[List[StrictStr]] = Field(default=None, alias="repositoryGroupIds")
    integration_ids: Optional[List[StrictStr]] = Field(default=None, alias="integrationIds")
    repository_directories: Optional[List[RepositoryDirectory]] = Field(default=None, alias="repositoryDirectories")
    nested_product_ids: Optional[List[StrictStr]] = Field(default=None, alias="nestedProductIds")
    __properties: ClassVar[List[str]] = ["name", "description", "workspaceId", "type", "repositoryIds", "repositoryGroupIds", "integrationIds", "repositoryDirectories", "nestedProductIds"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[\w\s!@#$%\^&*()={}:;<>+\'-\/]{1,60}$", value):
            raise ValueError(r"must validate the regular expression /^[\w\s!@#$%\^&*()={}:;<>+'-\/]{1,60}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateProductUnitDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in repository_directories (list)
        _items = []
        if self.repository_directories:
            for _item_repository_directories in self.repository_directories:
                if _item_repository_directories:
                    _items.append(_item_repository_directories.to_dict())
            _dict['repositoryDirectories'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if workspace_id (nullable) is None
        # and model_fields_set contains the field
        if self.workspace_id is None and "workspace_id" in self.model_fields_set:
            _dict['workspaceId'] = None

        # set to None if repository_ids (nullable) is None
        # and model_fields_set contains the field
        if self.repository_ids is None and "repository_ids" in self.model_fields_set:
            _dict['repositoryIds'] = None

        # set to None if repository_group_ids (nullable) is None
        # and model_fields_set contains the field
        if self.repository_group_ids is None and "repository_group_ids" in self.model_fields_set:
            _dict['repositoryGroupIds'] = None

        # set to None if integration_ids (nullable) is None
        # and model_fields_set contains the field
        if self.integration_ids is None and "integration_ids" in self.model_fields_set:
            _dict['integrationIds'] = None

        # set to None if repository_directories (nullable) is None
        # and model_fields_set contains the field
        if self.repository_directories is None and "repository_directories" in self.model_fields_set:
            _dict['repositoryDirectories'] = None

        # set to None if nested_product_ids (nullable) is None
        # and model_fields_set contains the field
        if self.nested_product_ids is None and "nested_product_ids" in self.model_fields_set:
            _dict['nestedProductIds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateProductUnitDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "workspaceId": obj.get("workspaceId"),
            "type": obj.get("type"),
            "repositoryIds": obj.get("repositoryIds"),
            "repositoryGroupIds": obj.get("repositoryGroupIds"),
            "integrationIds": obj.get("integrationIds"),
            "repositoryDirectories": [RepositoryDirectory.from_dict(_item) for _item in obj["repositoryDirectories"]] if obj.get("repositoryDirectories") is not None else None,
            "nestedProductIds": obj.get("nestedProductIds")
        })
        return _obj


