# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.ai_validation_result import AiValidationResult
from legit_api_client.models.dast_confidence_level import DastConfidenceLevel
from legit_api_client.models.dependency_fix_type import DependencyFixType
from legit_api_client.models.integration_dto import IntegrationDto
from legit_api_client.models.issue_closing_location_dto import IssueClosingLocationDto
from legit_api_client.models.issue_comment_dto import IssueCommentDto
from legit_api_client.models.issue_ignoring_reason_dto import IssueIgnoringReasonDto
from legit_api_client.models.issue_origin_dto import IssueOriginDto
from legit_api_client.models.issue_status import IssueStatus
from legit_api_client.models.issue_tag_dto import IssueTagDto
from legit_api_client.models.issue_ticketing_dto import IssueTicketingDto
from legit_api_client.models.issue_type import IssueType
from legit_api_client.models.secret_issue_validity_status import SecretIssueValidityStatus
from legit_api_client.models.severity import Severity
from legit_api_client.models.snoozed_type import SnoozedType
from legit_api_client.models.user_dto import UserDto
from typing import Optional, Set
from typing_extensions import Self

class IssueDto(BaseModel):
    """
    IssueDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    policy_name: Optional[StrictStr] = Field(default=None, alias="policyName")
    title: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    related_action_id: Optional[StrictStr] = Field(default=None, alias="relatedActionId")
    origin: Optional[IssueOriginDto] = None
    ticketing: Optional[IssueTicketingDto] = None
    product_units: Optional[List[StrictStr]] = Field(default=None, alias="productUnits")
    detected_at: Optional[datetime] = Field(default=None, alias="detectedAt")
    last_closed_at: Optional[datetime] = Field(default=None, alias="lastClosedAt")
    status: Optional[IssueStatus] = None
    type: Optional[IssueType] = None
    severity: Optional[Severity] = None
    policy_severity: Optional[Severity] = Field(default=None, alias="policySeverity")
    payload: Optional[Any] = None
    integration: Optional[IntegrationDto] = None
    score: Optional[Union[StrictFloat, StrictInt]] = None
    epss_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="epssScore")
    assigned_user: Optional[UserDto] = Field(default=None, alias="assignedUser")
    comments: Optional[List[IssueCommentDto]] = None
    last_update_time: Optional[datetime] = Field(default=None, alias="lastUpdateTime")
    ignoring_reason: Optional[IssueIgnoringReasonDto] = Field(default=None, alias="ignoringReason")
    closing_location: Optional[IssueClosingLocationDto] = Field(default=None, alias="closingLocation")
    tags: Optional[List[IssueTagDto]] = None
    status_changed_note: Optional[StrictStr] = Field(default=None, alias="statusChangedNote")
    remediation_steps: Optional[List[StrictStr]] = Field(default=None, alias="remediationSteps")
    snoozed_type: Optional[SnoozedType] = Field(default=None, alias="snoozedType")
    snoozed_until: Optional[datetime] = Field(default=None, alias="snoozedUntil")
    ai_validation_result: Optional[AiValidationResult] = Field(default=None, alias="aiValidationResult")
    dast_confidence_level: Optional[DastConfidenceLevel] = Field(default=None, alias="dastConfidenceLevel")
    validity_status: Optional[SecretIssueValidityStatus] = Field(default=None, alias="validityStatus")
    dependency_fix_type: Optional[DependencyFixType] = Field(default=None, alias="dependencyFixType")
    __properties: ClassVar[List[str]] = ["id", "policyName", "title", "description", "relatedActionId", "origin", "ticketing", "productUnits", "detectedAt", "lastClosedAt", "status", "type", "severity", "policySeverity", "payload", "integration", "score", "epssScore", "assignedUser", "comments", "lastUpdateTime", "ignoringReason", "closingLocation", "tags", "statusChangedNote", "remediationSteps", "snoozedType", "snoozedUntil", "aiValidationResult", "dastConfidenceLevel", "validityStatus", "dependencyFixType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IssueDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "payload",
            "assigned_user",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of origin
        if self.origin:
            _dict['origin'] = self.origin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ticketing
        if self.ticketing:
            _dict['ticketing'] = self.ticketing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict['integration'] = self.integration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of assigned_user
        if self.assigned_user:
            _dict['assignedUser'] = self.assigned_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item_comments in self.comments:
                if _item_comments:
                    _items.append(_item_comments.to_dict())
            _dict['comments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if policy_name (nullable) is None
        # and model_fields_set contains the field
        if self.policy_name is None and "policy_name" in self.model_fields_set:
            _dict['policyName'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if related_action_id (nullable) is None
        # and model_fields_set contains the field
        if self.related_action_id is None and "related_action_id" in self.model_fields_set:
            _dict['relatedActionId'] = None

        # set to None if origin (nullable) is None
        # and model_fields_set contains the field
        if self.origin is None and "origin" in self.model_fields_set:
            _dict['origin'] = None

        # set to None if ticketing (nullable) is None
        # and model_fields_set contains the field
        if self.ticketing is None and "ticketing" in self.model_fields_set:
            _dict['ticketing'] = None

        # set to None if product_units (nullable) is None
        # and model_fields_set contains the field
        if self.product_units is None and "product_units" in self.model_fields_set:
            _dict['productUnits'] = None

        # set to None if last_closed_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_closed_at is None and "last_closed_at" in self.model_fields_set:
            _dict['lastClosedAt'] = None

        # set to None if payload (nullable) is None
        # and model_fields_set contains the field
        if self.payload is None and "payload" in self.model_fields_set:
            _dict['payload'] = None

        # set to None if integration (nullable) is None
        # and model_fields_set contains the field
        if self.integration is None and "integration" in self.model_fields_set:
            _dict['integration'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if epss_score (nullable) is None
        # and model_fields_set contains the field
        if self.epss_score is None and "epss_score" in self.model_fields_set:
            _dict['epssScore'] = None

        # set to None if assigned_user (nullable) is None
        # and model_fields_set contains the field
        if self.assigned_user is None and "assigned_user" in self.model_fields_set:
            _dict['assignedUser'] = None

        # set to None if comments (nullable) is None
        # and model_fields_set contains the field
        if self.comments is None and "comments" in self.model_fields_set:
            _dict['comments'] = None

        # set to None if ignoring_reason (nullable) is None
        # and model_fields_set contains the field
        if self.ignoring_reason is None and "ignoring_reason" in self.model_fields_set:
            _dict['ignoringReason'] = None

        # set to None if closing_location (nullable) is None
        # and model_fields_set contains the field
        if self.closing_location is None and "closing_location" in self.model_fields_set:
            _dict['closingLocation'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if status_changed_note (nullable) is None
        # and model_fields_set contains the field
        if self.status_changed_note is None and "status_changed_note" in self.model_fields_set:
            _dict['statusChangedNote'] = None

        # set to None if remediation_steps (nullable) is None
        # and model_fields_set contains the field
        if self.remediation_steps is None and "remediation_steps" in self.model_fields_set:
            _dict['remediationSteps'] = None

        # set to None if snoozed_type (nullable) is None
        # and model_fields_set contains the field
        if self.snoozed_type is None and "snoozed_type" in self.model_fields_set:
            _dict['snoozedType'] = None

        # set to None if snoozed_until (nullable) is None
        # and model_fields_set contains the field
        if self.snoozed_until is None and "snoozed_until" in self.model_fields_set:
            _dict['snoozedUntil'] = None

        # set to None if ai_validation_result (nullable) is None
        # and model_fields_set contains the field
        if self.ai_validation_result is None and "ai_validation_result" in self.model_fields_set:
            _dict['aiValidationResult'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IssueDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "policyName": obj.get("policyName"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "relatedActionId": obj.get("relatedActionId"),
            "origin": IssueOriginDto.from_dict(obj["origin"]) if obj.get("origin") is not None else None,
            "ticketing": IssueTicketingDto.from_dict(obj["ticketing"]) if obj.get("ticketing") is not None else None,
            "productUnits": obj.get("productUnits"),
            "detectedAt": obj.get("detectedAt"),
            "lastClosedAt": obj.get("lastClosedAt"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "severity": obj.get("severity"),
            "policySeverity": obj.get("policySeverity"),
            "payload": obj.get("payload"),
            "integration": IntegrationDto.from_dict(obj["integration"]) if obj.get("integration") is not None else None,
            "score": obj.get("score"),
            "epssScore": obj.get("epssScore"),
            "assignedUser": UserDto.from_dict(obj["assignedUser"]) if obj.get("assignedUser") is not None else None,
            "comments": [IssueCommentDto.from_dict(_item) for _item in obj["comments"]] if obj.get("comments") is not None else None,
            "lastUpdateTime": obj.get("lastUpdateTime"),
            "ignoringReason": obj.get("ignoringReason"),
            "closingLocation": obj.get("closingLocation"),
            "tags": [IssueTagDto.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "statusChangedNote": obj.get("statusChangedNote"),
            "remediationSteps": obj.get("remediationSteps"),
            "snoozedType": obj.get("snoozedType"),
            "snoozedUntil": obj.get("snoozedUntil"),
            "aiValidationResult": obj.get("aiValidationResult"),
            "dastConfidenceLevel": obj.get("dastConfidenceLevel"),
            "validityStatus": obj.get("validityStatus"),
            "dependencyFixType": obj.get("dependencyFixType")
        })
        return _obj


