# coding: utf-8

"""
    Inventory

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from legit_api_client.models.business_impact import BusinessImpact
from legit_api_client.models.product_tree_node_dto import ProductTreeNodeDto
from legit_api_client.models.product_unit_dto_custom_fields_value import ProductUnitDtoCustomFieldsValue
from legit_api_client.models.product_unit_environment import ProductUnitEnvironment
from legit_api_client.models.product_unit_type import ProductUnitType
from typing import Optional, Set
from typing_extensions import Self

class ProductUnitDto(BaseModel):
    """
    ProductUnitDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[ProductUnitType] = None
    workspace_id: Optional[StrictStr] = Field(default=None, alias="workspaceId")
    score: Optional[Union[StrictFloat, StrictInt]] = None
    repositories_count: Optional[StrictInt] = Field(default=None, alias="repositoriesCount")
    environment: Optional[ProductUnitEnvironment] = None
    description: Optional[StrictStr] = None
    security_champion_id: Optional[StrictStr] = Field(default=None, alias="securityChampionId")
    business_impact: Optional[BusinessImpact] = Field(default=None, alias="businessImpact")
    issues_count: Optional[StrictInt] = Field(default=None, alias="issuesCount")
    name: Optional[StrictStr] = None
    score_out_of100: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scoreOutOf100")
    score_goal: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scoreGoal")
    nested_product_units: Optional[List[ProductTreeNodeDto]] = Field(default=None, alias="nestedProductUnits")
    custom_fields: Optional[Dict[str, Optional[ProductUnitDtoCustomFieldsValue]]] = Field(default=None, alias="customFields")
    __properties: ClassVar[List[str]] = ["id", "type", "workspaceId", "score", "repositoriesCount", "environment", "description", "securityChampionId", "businessImpact", "issuesCount", "name", "scoreOutOf100", "scoreGoal", "nestedProductUnits", "customFields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProductUnitDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "score_out_of100",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nested_product_units (list)
        _items = []
        if self.nested_product_units:
            for _item_nested_product_units in self.nested_product_units:
                if _item_nested_product_units:
                    _items.append(_item_nested_product_units.to_dict())
            _dict['nestedProductUnits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in custom_fields (dict)
        _field_dict = {}
        if self.custom_fields:
            for _key_custom_fields in self.custom_fields:
                if self.custom_fields[_key_custom_fields]:
                    _field_dict[_key_custom_fields] = self.custom_fields[_key_custom_fields].to_dict()
            _dict['customFields'] = _field_dict
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if workspace_id (nullable) is None
        # and model_fields_set contains the field
        if self.workspace_id is None and "workspace_id" in self.model_fields_set:
            _dict['workspaceId'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if repositories_count (nullable) is None
        # and model_fields_set contains the field
        if self.repositories_count is None and "repositories_count" in self.model_fields_set:
            _dict['repositoriesCount'] = None

        # set to None if environment (nullable) is None
        # and model_fields_set contains the field
        if self.environment is None and "environment" in self.model_fields_set:
            _dict['environment'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if security_champion_id (nullable) is None
        # and model_fields_set contains the field
        if self.security_champion_id is None and "security_champion_id" in self.model_fields_set:
            _dict['securityChampionId'] = None

        # set to None if business_impact (nullable) is None
        # and model_fields_set contains the field
        if self.business_impact is None and "business_impact" in self.model_fields_set:
            _dict['businessImpact'] = None

        # set to None if issues_count (nullable) is None
        # and model_fields_set contains the field
        if self.issues_count is None and "issues_count" in self.model_fields_set:
            _dict['issuesCount'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if score_out_of100 (nullable) is None
        # and model_fields_set contains the field
        if self.score_out_of100 is None and "score_out_of100" in self.model_fields_set:
            _dict['scoreOutOf100'] = None

        # set to None if score_goal (nullable) is None
        # and model_fields_set contains the field
        if self.score_goal is None and "score_goal" in self.model_fields_set:
            _dict['scoreGoal'] = None

        # set to None if nested_product_units (nullable) is None
        # and model_fields_set contains the field
        if self.nested_product_units is None and "nested_product_units" in self.model_fields_set:
            _dict['nestedProductUnits'] = None

        # set to None if custom_fields (nullable) is None
        # and model_fields_set contains the field
        if self.custom_fields is None and "custom_fields" in self.model_fields_set:
            _dict['customFields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProductUnitDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "workspaceId": obj.get("workspaceId"),
            "score": obj.get("score"),
            "repositoriesCount": obj.get("repositoriesCount"),
            "environment": obj.get("environment"),
            "description": obj.get("description"),
            "securityChampionId": obj.get("securityChampionId"),
            "businessImpact": obj.get("businessImpact"),
            "issuesCount": obj.get("issuesCount"),
            "name": obj.get("name"),
            "scoreOutOf100": obj.get("scoreOutOf100"),
            "scoreGoal": obj.get("scoreGoal"),
            "nestedProductUnits": [ProductTreeNodeDto.from_dict(_item) for _item in obj["nestedProductUnits"]] if obj.get("nestedProductUnits") is not None else None,
            "customFields": dict(
                (_k, ProductUnitDtoCustomFieldsValue.from_dict(_v))
                for _k, _v in obj["customFields"].items()
            )
            if obj.get("customFields") is not None
            else None
        })
        return _obj


