/*
Copyright (c) 2022 Uber Technologies, Inc.

 <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 except in compliance with the License. You may obtain a copy of the License at
 <p>http://www.apache.org/licenses/LICENSE-2.0

 <p>Unless required by applicable law or agreed to in writing, software distributed under the
 License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied. See the License for the specific language governing permissions and
 limitations under the License.
*/

use super::{initialize, run_match_test, run_rewrite_test};

static LANGUAGE: &str = "python";

#[test]
fn test_python_delete_modify_str_literal_from_list() {
  initialize();
  run_rewrite_test(
    &format!("{}/{}", LANGUAGE, "delete_cleanup_str_in_list"),
    1,
  );
}

#[test]
fn test_python_match_only() {
  initialize();
  run_match_test(&format!("{}/{}", LANGUAGE, "structural_find"), 3);
}
