export interface IAuthProviderParams {
    region: string;
    apiGW: string;
}
export interface IotaCredentials {
    readonly credentials: Credentials;
    readonly connectionClientId: string;
}
export interface Credentials {
    readonly accessKeyId?: string;
    readonly secretKey?: string;
    readonly sessionToken?: string;
    readonly expiration?: Date;
}
export interface IdentityCredentials {
    readonly identityId: string;
    readonly token: string;
}
export declare class IotaAuthProvider {
    region: string;
    apiGW: string;
    constructor(param?: {
        [key: string]: any;
    });
    limitedTokenToIotaCredentials(limitedToken: string): Promise<IotaCredentials>;
    exchangeIdentityCredentials(identityCredentials: IdentityCredentials): Promise<Credentials>;
}
