"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotaAuthProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("@affinidi-tdk/common");
const iota_client_1 = require("@affinidi-tdk/iota-client");
const client_cognito_identity_1 = require("@aws-sdk/client-cognito-identity");
class IotaAuthProvider {
    constructor(param) {
        this.region = param?.region ?? common_1.EnvironmentUtils.fetchRegion();
        this.apiGW = param?.apiGW ?? common_1.EnvironmentUtils.fetchApiGwUrl();
    }
    async limitedTokenToIotaCredentials(limitedToken) {
        const iotaAPIClient = new iota_client_1.IotaApi(new iota_client_1.Configuration({ basePath: `${this.apiGW}/ais` }));
        const response = await iotaAPIClient.awsExchangeCredentials({
            assertion: limitedToken,
        });
        const { connectionClientId, credentials: identityCredentials } = response.data;
        const credentials = await this.exchangeIdentityCredentials(identityCredentials);
        return {
            credentials,
            connectionClientId,
        };
    }
    async exchangeIdentityCredentials(identityCredentials) {
        const cognitoIdentityClient = new client_cognito_identity_1.CognitoIdentityClient({
            region: this.region,
        });
        const responseCmd = await cognitoIdentityClient.send(new client_cognito_identity_1.GetCredentialsForIdentityCommand({
            IdentityId: identityCredentials.identityId,
            Logins: {
                'cognito-identity.amazonaws.com': identityCredentials.token,
            },
        }));
        const credentials = responseCmd.Credentials;
        if (!credentials) {
            throw new Error('Error fetching credentials');
        }
        return {
            accessKeyId: credentials.AccessKeyId,
            secretKey: credentials.SecretKey,
            sessionToken: credentials.SessionToken,
            expiration: credentials.Expiration,
        };
    }
}
exports.IotaAuthProvider = IotaAuthProvider;
_a = JSII_RTTI_SYMBOL_1;
IotaAuthProvider[_a] = { fqn: "@affinidi-tdk/iota-core.IotaAuthProvider", version: "1.16.0" };
//# sourceMappingURL=data:application/json;base64,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