"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
const environment_1 = require("./environment");
class Logger {
    static debug(message, ...optionalParams) {
        if (this.isDebugEnabled) {
            console.log(`TDK: ${message}`, ...optionalParams);
        }
    }
}
exports.Logger = Logger;
Logger.isDebugEnabled = environment_1.EnvironmentUtils.fetchEnvironment() !== environment_1.Environment.PRODUCTION;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9nZ2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibG9nZ2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtDQUE2RDtBQUU3RCxNQUFhLE1BQU07SUFJakIsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFlLEVBQUUsR0FBRyxjQUFxQjtRQUNwRCxJQUFJLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUN4QixPQUFPLENBQUMsR0FBRyxDQUFDLFFBQVEsT0FBTyxFQUFFLEVBQUUsR0FBRyxjQUFjLENBQUMsQ0FBQTtRQUNuRCxDQUFDO0lBQ0gsQ0FBQzs7QUFSSCx3QkFTQztBQVJnQixxQkFBYyxHQUMzQiw4QkFBZ0IsQ0FBQyxnQkFBZ0IsRUFBRSxLQUFLLHlCQUFXLENBQUMsVUFBVSxDQUFBIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRW52aXJvbm1lbnQsIEVudmlyb25tZW50VXRpbHMgfSBmcm9tICcuL2Vudmlyb25tZW50J1xuXG5leHBvcnQgY2xhc3MgTG9nZ2VyIHtcbiAgcHJpdmF0ZSBzdGF0aWMgaXNEZWJ1Z0VuYWJsZWQ6IGJvb2xlYW4gPVxuICAgIEVudmlyb25tZW50VXRpbHMuZmV0Y2hFbnZpcm9ubWVudCgpICE9PSBFbnZpcm9ubWVudC5QUk9EVUNUSU9OXG5cbiAgc3RhdGljIGRlYnVnKG1lc3NhZ2U6IHN0cmluZywgLi4ub3B0aW9uYWxQYXJhbXM6IGFueVtdKTogdm9pZCB7XG4gICAgaWYgKHRoaXMuaXNEZWJ1Z0VuYWJsZWQpIHtcbiAgICAgIGNvbnNvbGUubG9nKGBUREs6ICR7bWVzc2FnZX1gLCAuLi5vcHRpb25hbFBhcmFtcylcbiAgICB9XG4gIH1cbn1cbiJdfQ==