/* tslint:disable */
/* eslint-disable */
/**
 * IotaService
 * Affinidi IotaService Structure
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@affinidi.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import type { Configuration } from './configuration'
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios'
import globalAxios from 'axios'
// Some imports not used depending on template conditions
// @ts-ignore
import {
  DUMMY_BASE_URL,
  assertParamExists,
  setApiKeyToObject,
  setBasicAuthToObject,
  setBearerAuthToObject,
  setOAuthToObject,
  setSearchParams,
  serializeDataIfNeeded,
  toPathString,
  createRequestFunction,
} from './common'
import type { RequestArgs } from './base'
// @ts-ignore
import {
  BASE_PATH,
  COLLECTION_FORMATS,
  BaseAPI,
  RequiredError,
  operationServerMap,
} from './base'

/**
 *
 * @export
 * @interface AlreadyExistsError
 */
export interface AlreadyExistsError {
  /**
   *
   * @type {string}
   * @memberof AlreadyExistsError
   */
  name: AlreadyExistsErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof AlreadyExistsError
   */
  message: AlreadyExistsErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof AlreadyExistsError
   */
  httpStatusCode: AlreadyExistsErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof AlreadyExistsError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof AlreadyExistsError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const AlreadyExistsErrorNameEnum = {
  AlreadyExistsError: 'AlreadyExistsError',
} as const

export type AlreadyExistsErrorNameEnum =
  (typeof AlreadyExistsErrorNameEnum)[keyof typeof AlreadyExistsErrorNameEnum]
export const AlreadyExistsErrorMessageEnum = {
  AlreadyExistsParam: 'Already exists: ${param}.',
} as const

export type AlreadyExistsErrorMessageEnum =
  (typeof AlreadyExistsErrorMessageEnum)[keyof typeof AlreadyExistsErrorMessageEnum]
export const AlreadyExistsErrorHttpStatusCodeEnum = {
  NUMBER_409: 409,
} as const

export type AlreadyExistsErrorHttpStatusCodeEnum =
  (typeof AlreadyExistsErrorHttpStatusCodeEnum)[keyof typeof AlreadyExistsErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface AwsExchangeCredentials
 */
export interface AwsExchangeCredentials {
  /**
   * JWT signed with a machine token used to secure the web socket connection
   * @type {string}
   * @memberof AwsExchangeCredentials
   */
  assertion: string
}
/**
 *
 * @export
 * @interface AwsExchangeCredentialsOK
 */
export interface AwsExchangeCredentialsOK {
  /**
   *
   * @type {string}
   * @memberof AwsExchangeCredentialsOK
   */
  connectionClientId: string
  /**
   *
   * @type {AwsExchangeCredentialsOKCredentials}
   * @memberof AwsExchangeCredentialsOK
   */
  credentials: AwsExchangeCredentialsOKCredentials
}
/**
 *
 * @export
 * @interface AwsExchangeCredentialsOKCredentials
 */
export interface AwsExchangeCredentialsOKCredentials {
  /**
   *
   * @type {string}
   * @memberof AwsExchangeCredentialsOKCredentials
   */
  identityId: string
  /**
   *
   * @type {string}
   * @memberof AwsExchangeCredentialsOKCredentials
   */
  token: string
}
/**
 *
 * @export
 * @interface CallbackInput
 */
export interface CallbackInput {
  /**
   * A string that must be a valid UUID (version 1-5).
   * @type {string}
   * @memberof CallbackInput
   */
  state: string
  /**
   * A string that must be a valid JSON object. The structure of presentation submission should follow OID4VP standard.
   * @type {string}
   * @memberof CallbackInput
   */
  presentation_submission?: string
  /**
   * A string that must be a valid JSON object. Ensure to escape special characters properly..
   * @type {string}
   * @memberof CallbackInput
   */
  vp_token?: string
  /**
   * The error should follow the OAuth2 error format (e.g. invalid_request, login_required). Defaults to access_denied
   * @type {string}
   * @memberof CallbackInput
   */
  error?: string
  /**
   * Description of the error in a human readable format
   * @type {string}
   * @memberof CallbackInput
   */
  error_description?: string
}
/**
 *
 * @export
 * @interface ConsentDto
 */
export interface ConsentDto {
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  projectId: string
  /**
   * id of the record
   * @type {string}
   * @memberof ConsentDto
   */
  id: string
  /**
   * unique identifier of the user
   * @type {string}
   * @memberof ConsentDto
   */
  userId: string
  /**
   * VC type of shared vc. If the actual VC has several VC types (excluding base types as VerifiableCredential) then for each of the a separate record will be added
   * @type {string}
   * @memberof ConsentDto
   */
  vcType: string
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  status: ConsentDtoStatusEnum
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  modifiedAt: string
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  modifiedBy: string
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  createdAt: string
  /**
   *
   * @type {string}
   * @memberof ConsentDto
   */
  createdBy: string
}

export const ConsentDtoStatusEnum = {
  Given: 'GIVEN',
} as const

export type ConsentDtoStatusEnum =
  (typeof ConsentDtoStatusEnum)[keyof typeof ConsentDtoStatusEnum]

/**
 *
 * @export
 * @interface CorsAwsExchangeCredentialsOK
 */
export interface CorsAwsExchangeCredentialsOK {
  /**
   *
   * @type {string}
   * @memberof CorsAwsExchangeCredentialsOK
   */
  corsAwsExchangeCredentialsOk?: string
}
/**
 *
 * @export
 * @interface CorsIotOidc4vpcallbackOK
 */
export interface CorsIotOidc4vpcallbackOK {
  /**
   *
   * @type {string}
   * @memberof CorsIotOidc4vpcallbackOK
   */
  corsIotOidc4vpcallbackOk?: string
}
/**
 *
 * @export
 * @interface CreateIotaConfigurationInput
 */
export interface CreateIotaConfigurationInput {
  /**
   * The name of the configuration
   * @type {string}
   * @memberof CreateIotaConfigurationInput
   */
  name: string
  /**
   * Description of the configuration
   * @type {string}
   * @memberof CreateIotaConfigurationInput
   */
  description?: string
  /**
   * The wallet Ari that will be used to sign
   * @type {string}
   * @memberof CreateIotaConfigurationInput
   */
  walletAri: string
  /**
   * webhook to call when data is ready
   * @type {string}
   * @memberof CreateIotaConfigurationInput
   */
  iotaResponseWebhookURL?: string
  /**
   *
   * @type {boolean}
   * @memberof CreateIotaConfigurationInput
   */
  enableVerification: boolean
  /**
   *
   * @type {boolean}
   * @memberof CreateIotaConfigurationInput
   */
  enableConsentAuditLog: boolean
  /**
   * token time to live in seconds
   * @type {number}
   * @memberof CreateIotaConfigurationInput
   */
  tokenMaxAge?: number
  /**
   *
   * @type {IotaConfigurationDtoClientMetadata}
   * @memberof CreateIotaConfigurationInput
   */
  clientMetadata: IotaConfigurationDtoClientMetadata
}
/**
 *
 * @export
 * @interface CreatePexQueryInput
 */
export interface CreatePexQueryInput {
  /**
   *
   * @type {string}
   * @memberof CreatePexQueryInput
   */
  name: string
  /**
   * VP definition in JSON stringify format
   * @type {string}
   * @memberof CreatePexQueryInput
   */
  vpDefinition: string
  /**
   * Description of query
   * @type {string}
   * @memberof CreatePexQueryInput
   */
  description?: string
}
/**
 *
 * @export
 * @interface GetIotaConfigurationMetaDataOK
 */
export interface GetIotaConfigurationMetaDataOK {
  /**
   * application name that will be displayed in consent page
   * @type {string}
   * @memberof GetIotaConfigurationMetaDataOK
   */
  name: string
  /**
   * origin url that will be displayed in consent page
   * @type {string}
   * @memberof GetIotaConfigurationMetaDataOK
   */
  origin: string
  /**
   * logo url that will be displayed in consent page
   * @type {string}
   * @memberof GetIotaConfigurationMetaDataOK
   */
  logo: string
}
/**
 *
 * @export
 * @interface InvalidParameterError
 */
export interface InvalidParameterError {
  /**
   *
   * @type {string}
   * @memberof InvalidParameterError
   */
  name: InvalidParameterErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof InvalidParameterError
   */
  message: InvalidParameterErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof InvalidParameterError
   */
  httpStatusCode: InvalidParameterErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof InvalidParameterError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof InvalidParameterError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const InvalidParameterErrorNameEnum = {
  InvalidParameterError: 'InvalidParameterError',
} as const

export type InvalidParameterErrorNameEnum =
  (typeof InvalidParameterErrorNameEnum)[keyof typeof InvalidParameterErrorNameEnum]
export const InvalidParameterErrorMessageEnum = {
  InvalidParameterParam: 'Invalid parameter: ${param}.',
} as const

export type InvalidParameterErrorMessageEnum =
  (typeof InvalidParameterErrorMessageEnum)[keyof typeof InvalidParameterErrorMessageEnum]
export const InvalidParameterErrorHttpStatusCodeEnum = {
  NUMBER_400: 400,
} as const

export type InvalidParameterErrorHttpStatusCodeEnum =
  (typeof InvalidParameterErrorHttpStatusCodeEnum)[keyof typeof InvalidParameterErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface InvalidParameterErrorDetailsInner
 */
export interface InvalidParameterErrorDetailsInner {
  /**
   *
   * @type {string}
   * @memberof InvalidParameterErrorDetailsInner
   */
  issue: string
  /**
   *
   * @type {string}
   * @memberof InvalidParameterErrorDetailsInner
   */
  field?: string
  /**
   *
   * @type {string}
   * @memberof InvalidParameterErrorDetailsInner
   */
  value?: string
  /**
   *
   * @type {string}
   * @memberof InvalidParameterErrorDetailsInner
   */
  location?: string
}
/**
 *
 * @export
 * @interface IotaConfigurationDto
 */
export interface IotaConfigurationDto {
  /**
   * The ARI of the config
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  ari: string
  /**
   *
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  configurationId: string
  /**
   * The name of the config
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  projectId: string
  /**
   * The wallet Ari that will be used to sign
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  walletAri: string
  /**
   * token time to live in seconds
   * @type {number}
   * @memberof IotaConfigurationDto
   */
  tokenMaxAge: number
  /**
   * webhook to call when data is ready
   * @type {string}
   * @memberof IotaConfigurationDto
   */
  iotaResponseWebhookURL?: string
  /**
   *
   * @type {boolean}
   * @memberof IotaConfigurationDto
   */
  enableVerification: boolean
  /**
   *
   * @type {boolean}
   * @memberof IotaConfigurationDto
   */
  enableConsentAuditLog: boolean
  /**
   *
   * @type {IotaConfigurationDtoClientMetadata}
   * @memberof IotaConfigurationDto
   */
  clientMetadata: IotaConfigurationDtoClientMetadata
}
/**
 * iota configuration client metadata
 * @export
 * @interface IotaConfigurationDtoClientMetadata
 */
export interface IotaConfigurationDtoClientMetadata {
  [key: string]: any

  /**
   * application name that will be displayed in consent page
   * @type {string}
   * @memberof IotaConfigurationDtoClientMetadata
   */
  name: string
  /**
   * origin url that will be displayed in consent page
   * @type {string}
   * @memberof IotaConfigurationDtoClientMetadata
   */
  origin: string
  /**
   * logo url that will be displayed in consent page
   * @type {string}
   * @memberof IotaConfigurationDtoClientMetadata
   */
  logo: string
}
/**
 *
 * @export
 * @interface ListConfigurationOK
 */
export interface ListConfigurationOK {
  /**
   *
   * @type {Array<IotaConfigurationDto>}
   * @memberof ListConfigurationOK
   */
  configurations: Array<IotaConfigurationDto>
}
/**
 *
 * @export
 * @interface ListLoggedConsentsOK
 */
export interface ListLoggedConsentsOK {
  /**
   *
   * @type {Array<ConsentDto>}
   * @memberof ListLoggedConsentsOK
   */
  consents: Array<ConsentDto>
  /**
   *
   * @type {string}
   * @memberof ListLoggedConsentsOK
   */
  lastEvaluatedKey?: string
}
/**
 *
 * @export
 * @interface ListPexQueriesOK
 */
export interface ListPexQueriesOK {
  /**
   *
   * @type {Array<PexQueryDto>}
   * @memberof ListPexQueriesOK
   */
  pexQueries: Array<PexQueryDto>
  /**
   *
   * @type {string}
   * @memberof ListPexQueriesOK
   */
  lastEvaluatedKey?: string
}
/**
 *
 * @export
 * @interface MessagePublishingError
 */
export interface MessagePublishingError {
  /**
   *
   * @type {string}
   * @memberof MessagePublishingError
   */
  name: MessagePublishingErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof MessagePublishingError
   */
  message: MessagePublishingErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof MessagePublishingError
   */
  httpStatusCode: MessagePublishingErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof MessagePublishingError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof MessagePublishingError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const MessagePublishingErrorNameEnum = {
  MessagePublishingError: 'MessagePublishingError',
} as const

export type MessagePublishingErrorNameEnum =
  (typeof MessagePublishingErrorNameEnum)[keyof typeof MessagePublishingErrorNameEnum]
export const MessagePublishingErrorMessageEnum = {
  NotAbleToPublishMessagesToTopic: 'Not able to publish messages to topic',
} as const

export type MessagePublishingErrorMessageEnum =
  (typeof MessagePublishingErrorMessageEnum)[keyof typeof MessagePublishingErrorMessageEnum]
export const MessagePublishingErrorHttpStatusCodeEnum = {
  NUMBER_500: 500,
} as const

export type MessagePublishingErrorHttpStatusCodeEnum =
  (typeof MessagePublishingErrorHttpStatusCodeEnum)[keyof typeof MessagePublishingErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface NotFoundError
 */
export interface NotFoundError {
  /**
   *
   * @type {string}
   * @memberof NotFoundError
   */
  name: NotFoundErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof NotFoundError
   */
  message: NotFoundErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof NotFoundError
   */
  httpStatusCode: NotFoundErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof NotFoundError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof NotFoundError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const NotFoundErrorNameEnum = {
  NotFoundError: 'NotFoundError',
} as const

export type NotFoundErrorNameEnum =
  (typeof NotFoundErrorNameEnum)[keyof typeof NotFoundErrorNameEnum]
export const NotFoundErrorMessageEnum = {
  NotFoundParam: 'Not found: ${param}.',
} as const

export type NotFoundErrorMessageEnum =
  (typeof NotFoundErrorMessageEnum)[keyof typeof NotFoundErrorMessageEnum]
export const NotFoundErrorHttpStatusCodeEnum = {
  NUMBER_404: 404,
} as const

export type NotFoundErrorHttpStatusCodeEnum =
  (typeof NotFoundErrorHttpStatusCodeEnum)[keyof typeof NotFoundErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface OperationForbiddenError
 */
export interface OperationForbiddenError {
  /**
   *
   * @type {string}
   * @memberof OperationForbiddenError
   */
  name: OperationForbiddenErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof OperationForbiddenError
   */
  message: OperationForbiddenErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof OperationForbiddenError
   */
  httpStatusCode: OperationForbiddenErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof OperationForbiddenError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof OperationForbiddenError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const OperationForbiddenErrorNameEnum = {
  OperationForbiddenError: 'OperationForbiddenError',
} as const

export type OperationForbiddenErrorNameEnum =
  (typeof OperationForbiddenErrorNameEnum)[keyof typeof OperationForbiddenErrorNameEnum]
export const OperationForbiddenErrorMessageEnum = {
  OperationForbiddenParam: 'Operation forbidden: ${param}.',
} as const

export type OperationForbiddenErrorMessageEnum =
  (typeof OperationForbiddenErrorMessageEnum)[keyof typeof OperationForbiddenErrorMessageEnum]
export const OperationForbiddenErrorHttpStatusCodeEnum = {
  NUMBER_403: 403,
} as const

export type OperationForbiddenErrorHttpStatusCodeEnum =
  (typeof OperationForbiddenErrorHttpStatusCodeEnum)[keyof typeof OperationForbiddenErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface PexQueryDto
 */
export interface PexQueryDto {
  /**
   *
   * @type {string}
   * @memberof PexQueryDto
   */
  ari: string
  /**
   *
   * @type {string}
   * @memberof PexQueryDto
   */
  queryId: string
  /**
   *
   * @type {string}
   * @memberof PexQueryDto
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof PexQueryDto
   */
  description: string
  /**
   *
   * @type {string}
   * @memberof PexQueryDto
   */
  configurationAri: string
  /**
   * VP definition in JSON stringify format
   * @type {string}
   * @memberof PexQueryDto
   */
  vpDefinition: string
}
/**
 *
 * @export
 * @interface PrepareRequest
 */
export interface PrepareRequest {
  /**
   *
   * @type {string}
   * @memberof PrepareRequest
   */
  connectionClientId: string
  /**
   *
   * @type {string}
   * @memberof PrepareRequest
   */
  queryId: string
  /**
   *
   * @type {string}
   * @memberof PrepareRequest
   */
  correlationId: string
  /**
   * token time to live in seconds
   * @type {number}
   * @memberof PrepareRequest
   */
  tokenMaxAge?: number
  /**
   *
   * @type {string}
   * @memberof PrepareRequest
   */
  audience?: string
}
/**
 *
 * @export
 * @interface PrepareRequestCreated
 */
export interface PrepareRequestCreated {
  /**
   *
   * @type {PrepareRequestCreatedData}
   * @memberof PrepareRequestCreated
   */
  data: PrepareRequestCreatedData
}
/**
 *
 * @export
 * @interface PrepareRequestCreatedData
 */
export interface PrepareRequestCreatedData {
  /**
   *
   * @type {string}
   * @memberof PrepareRequestCreatedData
   */
  jwt: string
  /**
   *
   * @type {string}
   * @memberof PrepareRequestCreatedData
   */
  correlationId: string
}
/**
 *
 * @export
 * @interface ResourceLimitExceededError
 */
export interface ResourceLimitExceededError {
  /**
   *
   * @type {string}
   * @memberof ResourceLimitExceededError
   */
  name: ResourceLimitExceededErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof ResourceLimitExceededError
   */
  message: ResourceLimitExceededErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof ResourceLimitExceededError
   */
  httpStatusCode: ResourceLimitExceededErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof ResourceLimitExceededError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof ResourceLimitExceededError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const ResourceLimitExceededErrorNameEnum = {
  ResourceLimitExceededError: 'ResourceLimitExceededError',
} as const

export type ResourceLimitExceededErrorNameEnum =
  (typeof ResourceLimitExceededErrorNameEnum)[keyof typeof ResourceLimitExceededErrorNameEnum]
export const ResourceLimitExceededErrorMessageEnum = {
  ResourceLimitExceededParam: 'Resource limit exceeded: ${param}.',
} as const

export type ResourceLimitExceededErrorMessageEnum =
  (typeof ResourceLimitExceededErrorMessageEnum)[keyof typeof ResourceLimitExceededErrorMessageEnum]
export const ResourceLimitExceededErrorHttpStatusCodeEnum = {
  NUMBER_422: 422,
} as const

export type ResourceLimitExceededErrorHttpStatusCodeEnum =
  (typeof ResourceLimitExceededErrorHttpStatusCodeEnum)[keyof typeof ResourceLimitExceededErrorHttpStatusCodeEnum]

/**
 *
 * @export
 * @interface UpdateConfigurationByIdInput
 */
export interface UpdateConfigurationByIdInput {
  /**
   * The name of the config
   * @type {string}
   * @memberof UpdateConfigurationByIdInput
   */
  name?: string
  /**
   * The wallet Ari that will be used to sign
   * @type {string}
   * @memberof UpdateConfigurationByIdInput
   */
  walletAri?: string
  /**
   * webhook to call when data is ready
   * @type {string}
   * @memberof UpdateConfigurationByIdInput
   */
  iotaResponseWebhookURL?: string
  /**
   *
   * @type {boolean}
   * @memberof UpdateConfigurationByIdInput
   */
  enableVerification?: boolean
  /**
   *
   * @type {boolean}
   * @memberof UpdateConfigurationByIdInput
   */
  enableConsentAuditLog?: boolean
  /**
   * token time to live in seconds
   * @type {number}
   * @memberof UpdateConfigurationByIdInput
   */
  tokenMaxAge?: number
  /**
   * The description of the config
   * @type {string}
   * @memberof UpdateConfigurationByIdInput
   */
  description?: string
  /**
   *
   * @type {IotaConfigurationDtoClientMetadata}
   * @memberof UpdateConfigurationByIdInput
   */
  clientMetadata?: IotaConfigurationDtoClientMetadata
}
/**
 *
 * @export
 * @interface UpdateConfigurationByIdOK
 */
export interface UpdateConfigurationByIdOK {
  /**
   *
   * @type {string}
   * @memberof UpdateConfigurationByIdOK
   */
  updateConfigurationByIdOk?: string
}
/**
 *
 * @export
 * @interface UpdatePexQueryInput
 */
export interface UpdatePexQueryInput {
  /**
   * VP definition in JSON stringify format
   * @type {string}
   * @memberof UpdatePexQueryInput
   */
  vpDefinition?: string
  /**
   *
   * @type {string}
   * @memberof UpdatePexQueryInput
   */
  description?: string
}
/**
 *
 * @export
 * @interface VPTokenValidationError
 */
export interface VPTokenValidationError {
  /**
   *
   * @type {string}
   * @memberof VPTokenValidationError
   */
  name: VPTokenValidationErrorNameEnum
  /**
   *
   * @type {string}
   * @memberof VPTokenValidationError
   */
  message: VPTokenValidationErrorMessageEnum
  /**
   *
   * @type {number}
   * @memberof VPTokenValidationError
   */
  httpStatusCode: VPTokenValidationErrorHttpStatusCodeEnum
  /**
   *
   * @type {string}
   * @memberof VPTokenValidationError
   */
  traceId: string
  /**
   *
   * @type {Array<InvalidParameterErrorDetailsInner>}
   * @memberof VPTokenValidationError
   */
  details?: Array<InvalidParameterErrorDetailsInner>
}

export const VPTokenValidationErrorNameEnum = {
  VpTokenValidationError: 'VPTokenValidationError',
} as const

export type VPTokenValidationErrorNameEnum =
  (typeof VPTokenValidationErrorNameEnum)[keyof typeof VPTokenValidationErrorNameEnum]
export const VPTokenValidationErrorMessageEnum = {
  VpTokenValidationEndedWithAnError: 'VP token validation ended with an error',
} as const

export type VPTokenValidationErrorMessageEnum =
  (typeof VPTokenValidationErrorMessageEnum)[keyof typeof VPTokenValidationErrorMessageEnum]
export const VPTokenValidationErrorHttpStatusCodeEnum = {
  NUMBER_400: 400,
} as const

export type VPTokenValidationErrorHttpStatusCodeEnum =
  (typeof VPTokenValidationErrorHttpStatusCodeEnum)[keyof typeof VPTokenValidationErrorHttpStatusCodeEnum]

/**
 * CallbackApi - axios parameter creator
 * @export
 */
export const CallbackApiAxiosParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    iotOIDC4VPCallback: async (
      callbackInput: CallbackInput,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'callbackInput' is not null or undefined
      assertParamExists('iotOIDC4VPCallback', 'callbackInput', callbackInput)
      const localVarPath = `/v1/callback`
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'POST',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        callbackInput,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
  }
}

/**
 * CallbackApi - functional programming interface
 * @export
 */
export const CallbackApiFp = function (configuration?: Configuration) {
  const localVarAxiosParamCreator = CallbackApiAxiosParamCreator(configuration)
  return {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async iotOIDC4VPCallback(
      callbackInput: CallbackInput,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<object>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.iotOIDC4VPCallback(
          callbackInput,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['CallbackApi.iotOIDC4VPCallback']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
  }
}

/**
 * CallbackApi - factory interface
 * @export
 */
export const CallbackApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance,
) {
  const localVarFp = CallbackApiFp(configuration)
  return {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    iotOIDC4VPCallback(
      callbackInput: CallbackInput,
      options?: any,
    ): AxiosPromise<object> {
      return localVarFp
        .iotOIDC4VPCallback(callbackInput, options)
        .then((request) => request(axios, basePath))
    },
  }
}

/**
 * CallbackApi - object-oriented interface
 * @export
 * @class CallbackApi
 * @extends {BaseAPI}
 */
export class CallbackApi extends BaseAPI {
  /**
   * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
   * @summary Processes the callback for OIDC4VP flows
   * @param {CallbackInput} callbackInput CallbackRequestInput
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof CallbackApi
   */
  public iotOIDC4VPCallback(
    callbackInput: CallbackInput,
    options?: RawAxiosRequestConfig,
  ) {
    return CallbackApiFp(this.configuration)
      .iotOIDC4VPCallback(callbackInput, options)
      .then((request) => request(this.axios, this.basePath))
  }
}

/**
 * ConfigurationsApi - axios parameter creator
 * @export
 */
export const ConfigurationsApiAxiosParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createIotaConfiguration: async (
      createIotaConfigurationInput: CreateIotaConfigurationInput,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'createIotaConfigurationInput' is not null or undefined
      assertParamExists(
        'createIotaConfiguration',
        'createIotaConfigurationInput',
        createIotaConfigurationInput,
      )
      const localVarPath = `/v1/configurations`
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'POST',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        createIotaConfigurationInput,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteIotaConfigurationById: async (
      configurationId: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'deleteIotaConfigurationById',
        'configurationId',
        configurationId,
      )
      const localVarPath = `/v1/configurations/{configurationId}`.replace(
        `{${'configurationId'}}`,
        encodeURIComponent(String(configurationId)),
      )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'DELETE',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationById: async (
      configurationId: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'getIotaConfigurationById',
        'configurationId',
        configurationId,
      )
      const localVarPath = `/v1/configurations/{configurationId}`.replace(
        `{${'configurationId'}}`,
        encodeURIComponent(String(configurationId)),
      )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationMetaData: async (
      projectId: string,
      configurationId: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'projectId' is not null or undefined
      assertParamExists('getIotaConfigurationMetaData', 'projectId', projectId)
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'getIotaConfigurationMetaData',
        'configurationId',
        configurationId,
      )
      const localVarPath =
        `/v1/projects/{projectId}/configurations/{configurationId}/metadata`
          .replace(`{${'projectId'}}`, encodeURIComponent(String(projectId)))
          .replace(
            `{${'configurationId'}}`,
            encodeURIComponent(String(configurationId)),
          )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listIotaConfigurations: async (
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/configurations`
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateIotaConfigurationById: async (
      configurationId: string,
      updateConfigurationByIdInput: UpdateConfigurationByIdInput,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'updateIotaConfigurationById',
        'configurationId',
        configurationId,
      )
      // verify required parameter 'updateConfigurationByIdInput' is not null or undefined
      assertParamExists(
        'updateIotaConfigurationById',
        'updateConfigurationByIdInput',
        updateConfigurationByIdInput,
      )
      const localVarPath = `/v1/configurations/{configurationId}`.replace(
        `{${'configurationId'}}`,
        encodeURIComponent(String(configurationId)),
      )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'PATCH',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        updateConfigurationByIdInput,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
  }
}

/**
 * ConfigurationsApi - functional programming interface
 * @export
 */
export const ConfigurationsApiFp = function (configuration?: Configuration) {
  const localVarAxiosParamCreator =
    ConfigurationsApiAxiosParamCreator(configuration)
  return {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createIotaConfiguration(
      createIotaConfigurationInput: CreateIotaConfigurationInput,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<IotaConfigurationDto>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.createIotaConfiguration(
          createIotaConfigurationInput,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.createIotaConfiguration']?.[index]
          ?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deleteIotaConfigurationById(
      configurationId: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.deleteIotaConfigurationById(
          configurationId,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.deleteIotaConfigurationById']?.[
          index
        ]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getIotaConfigurationById(
      configurationId: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<IotaConfigurationDto>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.getIotaConfigurationById(
          configurationId,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.getIotaConfigurationById']?.[
          index
        ]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getIotaConfigurationMetaData(
      projectId: string,
      configurationId: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<GetIotaConfigurationMetaDataOK>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.getIotaConfigurationMetaData(
          projectId,
          configurationId,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.getIotaConfigurationMetaData']?.[
          index
        ]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listIotaConfigurations(
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<ListConfigurationOK>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.listIotaConfigurations(options)
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.listIotaConfigurations']?.[index]
          ?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updateIotaConfigurationById(
      configurationId: string,
      updateConfigurationByIdInput: UpdateConfigurationByIdInput,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<IotaConfigurationDto>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.updateIotaConfigurationById(
          configurationId,
          updateConfigurationByIdInput,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['ConfigurationsApi.updateIotaConfigurationById']?.[
          index
        ]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
  }
}

/**
 * ConfigurationsApi - factory interface
 * @export
 */
export const ConfigurationsApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance,
) {
  const localVarFp = ConfigurationsApiFp(configuration)
  return {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createIotaConfiguration(
      createIotaConfigurationInput: CreateIotaConfigurationInput,
      options?: any,
    ): AxiosPromise<IotaConfigurationDto> {
      return localVarFp
        .createIotaConfiguration(createIotaConfigurationInput, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteIotaConfigurationById(
      configurationId: string,
      options?: any,
    ): AxiosPromise<void> {
      return localVarFp
        .deleteIotaConfigurationById(configurationId, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationById(
      configurationId: string,
      options?: any,
    ): AxiosPromise<IotaConfigurationDto> {
      return localVarFp
        .getIotaConfigurationById(configurationId, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationMetaData(
      projectId: string,
      configurationId: string,
      options?: any,
    ): AxiosPromise<GetIotaConfigurationMetaDataOK> {
      return localVarFp
        .getIotaConfigurationMetaData(projectId, configurationId, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listIotaConfigurations(options?: any): AxiosPromise<ListConfigurationOK> {
      return localVarFp
        .listIotaConfigurations(options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateIotaConfigurationById(
      configurationId: string,
      updateConfigurationByIdInput: UpdateConfigurationByIdInput,
      options?: any,
    ): AxiosPromise<IotaConfigurationDto> {
      return localVarFp
        .updateIotaConfigurationById(
          configurationId,
          updateConfigurationByIdInput,
          options,
        )
        .then((request) => request(axios, basePath))
    },
  }
}

/**
 * ConfigurationsApi - object-oriented interface
 * @export
 * @class ConfigurationsApi
 * @extends {BaseAPI}
 */
export class ConfigurationsApi extends BaseAPI {
  /**
   *
   * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public createIotaConfiguration(
    createIotaConfigurationInput: CreateIotaConfigurationInput,
    options?: RawAxiosRequestConfig,
  ) {
    return ConfigurationsApiFp(this.configuration)
      .createIotaConfiguration(createIotaConfigurationInput, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public deleteIotaConfigurationById(
    configurationId: string,
    options?: RawAxiosRequestConfig,
  ) {
    return ConfigurationsApiFp(this.configuration)
      .deleteIotaConfigurationById(configurationId, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public getIotaConfigurationById(
    configurationId: string,
    options?: RawAxiosRequestConfig,
  ) {
    return ConfigurationsApiFp(this.configuration)
      .getIotaConfigurationById(configurationId, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} projectId project Id
   * @param {string} configurationId iotaConfiguration Id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public getIotaConfigurationMetaData(
    projectId: string,
    configurationId: string,
    options?: RawAxiosRequestConfig,
  ) {
    return ConfigurationsApiFp(this.configuration)
      .getIotaConfigurationMetaData(projectId, configurationId, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public listIotaConfigurations(options?: RawAxiosRequestConfig) {
    return ConfigurationsApiFp(this.configuration)
      .listIotaConfigurations(options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof ConfigurationsApi
   */
  public updateIotaConfigurationById(
    configurationId: string,
    updateConfigurationByIdInput: UpdateConfigurationByIdInput,
    options?: RawAxiosRequestConfig,
  ) {
    return ConfigurationsApiFp(this.configuration)
      .updateIotaConfigurationById(
        configurationId,
        updateConfigurationByIdInput,
        options,
      )
      .then((request) => request(this.axios, this.basePath))
  }
}

/**
 * DefaultApi - axios parameter creator
 * @export
 */
export const DefaultApiAxiosParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLoggedConsents: async (
      userId?: string,
      limit?: number,
      exclusiveStartKey?: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      const localVarPath = `/v1/logged-consents`
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      if (userId !== undefined) {
        localVarQueryParameter['userId'] = userId
      }

      if (limit !== undefined) {
        localVarQueryParameter['limit'] = limit
      }

      if (exclusiveStartKey !== undefined) {
        localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey
      }

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
  }
}

/**
 * DefaultApi - functional programming interface
 * @export
 */
export const DefaultApiFp = function (configuration?: Configuration) {
  const localVarAxiosParamCreator = DefaultApiAxiosParamCreator(configuration)
  return {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listLoggedConsents(
      userId?: string,
      limit?: number,
      exclusiveStartKey?: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<ListLoggedConsentsOK>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.listLoggedConsents(
          userId,
          limit,
          exclusiveStartKey,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['DefaultApi.listLoggedConsents']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
  }
}

/**
 * DefaultApi - factory interface
 * @export
 */
export const DefaultApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance,
) {
  const localVarFp = DefaultApiFp(configuration)
  return {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLoggedConsents(
      userId?: string,
      limit?: number,
      exclusiveStartKey?: string,
      options?: any,
    ): AxiosPromise<ListLoggedConsentsOK> {
      return localVarFp
        .listLoggedConsents(userId, limit, exclusiveStartKey, options)
        .then((request) => request(axios, basePath))
    },
  }
}

/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export class DefaultApi extends BaseAPI {
  /**
   * returns a list of logged consents for the project
   * @param {string} [userId]
   * @param {number} [limit] Maximum number of records to fetch in a list
   * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public listLoggedConsents(
    userId?: string,
    limit?: number,
    exclusiveStartKey?: string,
    options?: RawAxiosRequestConfig,
  ) {
    return DefaultApiFp(this.configuration)
      .listLoggedConsents(userId, limit, exclusiveStartKey, options)
      .then((request) => request(this.axios, this.basePath))
  }
}

/**
 * IotaApi - axios parameter creator
 * @export
 */
export const IotaApiAxiosParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    awsExchangeCredentials: async (
      awsExchangeCredentials: AwsExchangeCredentials,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'awsExchangeCredentials' is not null or undefined
      assertParamExists(
        'awsExchangeCredentials',
        'awsExchangeCredentials',
        awsExchangeCredentials,
      )
      const localVarPath = `/v1/aws-exchange-credentials`
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'POST',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        awsExchangeCredentials,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
  }
}

/**
 * IotaApi - functional programming interface
 * @export
 */
export const IotaApiFp = function (configuration?: Configuration) {
  const localVarAxiosParamCreator = IotaApiAxiosParamCreator(configuration)
  return {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async awsExchangeCredentials(
      awsExchangeCredentials: AwsExchangeCredentials,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<AwsExchangeCredentialsOK>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.awsExchangeCredentials(
          awsExchangeCredentials,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['IotaApi.awsExchangeCredentials']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
  }
}

/**
 * IotaApi - factory interface
 * @export
 */
export const IotaApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance,
) {
  const localVarFp = IotaApiFp(configuration)
  return {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    awsExchangeCredentials(
      awsExchangeCredentials: AwsExchangeCredentials,
      options?: any,
    ): AxiosPromise<AwsExchangeCredentialsOK> {
      return localVarFp
        .awsExchangeCredentials(awsExchangeCredentials, options)
        .then((request) => request(axios, basePath))
    },
  }
}

/**
 * IotaApi - object-oriented interface
 * @export
 * @class IotaApi
 * @extends {BaseAPI}
 */
export class IotaApi extends BaseAPI {
  /**
   * It exchanges limited token into cognito
   * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof IotaApi
   */
  public awsExchangeCredentials(
    awsExchangeCredentials: AwsExchangeCredentials,
    options?: RawAxiosRequestConfig,
  ) {
    return IotaApiFp(this.configuration)
      .awsExchangeCredentials(awsExchangeCredentials, options)
      .then((request) => request(this.axios, this.basePath))
  }
}

/**
 * PexQueryApi - axios parameter creator
 * @export
 */
export const PexQueryApiAxiosParamCreator = function (
  configuration?: Configuration,
) {
  return {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPexQuery: async (
      configurationId: string,
      createPexQueryInput: CreatePexQueryInput,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists('createPexQuery', 'configurationId', configurationId)
      // verify required parameter 'createPexQueryInput' is not null or undefined
      assertParamExists(
        'createPexQuery',
        'createPexQueryInput',
        createPexQueryInput,
      )
      const localVarPath =
        `/v1/configurations/{configurationId}/pex-queries`.replace(
          `{${'configurationId'}}`,
          encodeURIComponent(String(configurationId)),
        )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'POST',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        createPexQueryInput,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePexQueryById: async (
      configurationId: string,
      queryId: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'deletePexQueryById',
        'configurationId',
        configurationId,
      )
      // verify required parameter 'queryId' is not null or undefined
      assertParamExists('deletePexQueryById', 'queryId', queryId)
      const localVarPath =
        `/v1/configurations/{configurationId}/pex-queries/{queryId}`
          .replace(
            `{${'configurationId'}}`,
            encodeURIComponent(String(configurationId)),
          )
          .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)))
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'DELETE',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPexQueryById: async (
      configurationId: string,
      queryId: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists('getPexQueryById', 'configurationId', configurationId)
      // verify required parameter 'queryId' is not null or undefined
      assertParamExists('getPexQueryById', 'queryId', queryId)
      const localVarPath =
        `/v1/configurations/{configurationId}/pex-queries/{queryId}`
          .replace(
            `{${'configurationId'}}`,
            encodeURIComponent(String(configurationId)),
          )
          .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)))
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPexQueries: async (
      configurationId: string,
      limit?: number,
      exclusiveStartKey?: string,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists('listPexQueries', 'configurationId', configurationId)
      const localVarPath =
        `/v1/configurations/{configurationId}/pex-queries`.replace(
          `{${'configurationId'}}`,
          encodeURIComponent(String(configurationId)),
        )
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'GET',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      if (limit !== undefined) {
        localVarQueryParameter['limit'] = limit
      }

      if (exclusiveStartKey !== undefined) {
        localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey
      }

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePexQueryById: async (
      configurationId: string,
      queryId: string,
      updatePexQueryInput: UpdatePexQueryInput,
      options: RawAxiosRequestConfig = {},
    ): Promise<RequestArgs> => {
      // verify required parameter 'configurationId' is not null or undefined
      assertParamExists(
        'updatePexQueryById',
        'configurationId',
        configurationId,
      )
      // verify required parameter 'queryId' is not null or undefined
      assertParamExists('updatePexQueryById', 'queryId', queryId)
      // verify required parameter 'updatePexQueryInput' is not null or undefined
      assertParamExists(
        'updatePexQueryById',
        'updatePexQueryInput',
        updatePexQueryInput,
      )
      const localVarPath =
        `/v1/configurations/{configurationId}/pex-queries/{queryId}`
          .replace(
            `{${'configurationId'}}`,
            encodeURIComponent(String(configurationId)),
          )
          .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)))
      // use dummy base URL string because the URL constructor only accepts absolute URLs.
      const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL)
      let baseOptions
      if (configuration) {
        baseOptions = configuration.baseOptions
      }

      const localVarRequestOptions = {
        method: 'PATCH',
        ...baseOptions,
        ...options,
      }
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      // authentication ProjectTokenAuth required
      await setApiKeyToObject(
        localVarHeaderParameter,
        'authorization',
        configuration,
      )

      localVarHeaderParameter['Content-Type'] = 'application/json'

      setSearchParams(localVarUrlObj, localVarQueryParameter)
      let headersFromBaseOptions =
        baseOptions && baseOptions.headers ? baseOptions.headers : {}
      localVarRequestOptions.headers = {
        ...localVarHeaderParameter,
        ...headersFromBaseOptions,
        ...options.headers,
      }
      localVarRequestOptions.data = serializeDataIfNeeded(
        updatePexQueryInput,
        localVarRequestOptions,
        configuration,
      )

      return {
        url: toPathString(localVarUrlObj),
        options: localVarRequestOptions,
      }
    },
  }
}

/**
 * PexQueryApi - functional programming interface
 * @export
 */
export const PexQueryApiFp = function (configuration?: Configuration) {
  const localVarAxiosParamCreator = PexQueryApiAxiosParamCreator(configuration)
  return {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async createPexQuery(
      configurationId: string,
      createPexQueryInput: CreatePexQueryInput,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>
    > {
      const localVarAxiosArgs = await localVarAxiosParamCreator.createPexQuery(
        configurationId,
        createPexQueryInput,
        options,
      )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['PexQueryApi.createPexQuery']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async deletePexQueryById(
      configurationId: string,
      queryId: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.deletePexQueryById(
          configurationId,
          queryId,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['PexQueryApi.deletePexQueryById']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async getPexQueryById(
      configurationId: string,
      queryId: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>
    > {
      const localVarAxiosArgs = await localVarAxiosParamCreator.getPexQueryById(
        configurationId,
        queryId,
        options,
      )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['PexQueryApi.getPexQueryById']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async listPexQueries(
      configurationId: string,
      limit?: number,
      exclusiveStartKey?: string,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (
        axios?: AxiosInstance,
        basePath?: string,
      ) => AxiosPromise<ListPexQueriesOK>
    > {
      const localVarAxiosArgs = await localVarAxiosParamCreator.listPexQueries(
        configurationId,
        limit,
        exclusiveStartKey,
        options,
      )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['PexQueryApi.listPexQueries']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    async updatePexQueryById(
      configurationId: string,
      queryId: string,
      updatePexQueryInput: UpdatePexQueryInput,
      options?: RawAxiosRequestConfig,
    ): Promise<
      (axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>
    > {
      const localVarAxiosArgs =
        await localVarAxiosParamCreator.updatePexQueryById(
          configurationId,
          queryId,
          updatePexQueryInput,
          options,
        )
      const index = configuration?.serverIndex ?? 0
      const operationBasePath =
        operationServerMap['PexQueryApi.updatePexQueryById']?.[index]?.url
      return (axios, basePath) =>
        createRequestFunction(
          localVarAxiosArgs,
          globalAxios,
          BASE_PATH,
          configuration,
        )(axios, operationBasePath || basePath)
    },
  }
}

/**
 * PexQueryApi - factory interface
 * @export
 */
export const PexQueryApiFactory = function (
  configuration?: Configuration,
  basePath?: string,
  axios?: AxiosInstance,
) {
  const localVarFp = PexQueryApiFp(configuration)
  return {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPexQuery(
      configurationId: string,
      createPexQueryInput: CreatePexQueryInput,
      options?: any,
    ): AxiosPromise<PexQueryDto> {
      return localVarFp
        .createPexQuery(configurationId, createPexQueryInput, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePexQueryById(
      configurationId: string,
      queryId: string,
      options?: any,
    ): AxiosPromise<void> {
      return localVarFp
        .deletePexQueryById(configurationId, queryId, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPexQueryById(
      configurationId: string,
      queryId: string,
      options?: any,
    ): AxiosPromise<PexQueryDto> {
      return localVarFp
        .getPexQueryById(configurationId, queryId, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPexQueries(
      configurationId: string,
      limit?: number,
      exclusiveStartKey?: string,
      options?: any,
    ): AxiosPromise<ListPexQueriesOK> {
      return localVarFp
        .listPexQueries(configurationId, limit, exclusiveStartKey, options)
        .then((request) => request(axios, basePath))
    },
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePexQueryById(
      configurationId: string,
      queryId: string,
      updatePexQueryInput: UpdatePexQueryInput,
      options?: any,
    ): AxiosPromise<PexQueryDto> {
      return localVarFp
        .updatePexQueryById(
          configurationId,
          queryId,
          updatePexQueryInput,
          options,
        )
        .then((request) => request(axios, basePath))
    },
  }
}

/**
 * PexQueryApi - object-oriented interface
 * @export
 * @class PexQueryApi
 * @extends {BaseAPI}
 */
export class PexQueryApi extends BaseAPI {
  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PexQueryApi
   */
  public createPexQuery(
    configurationId: string,
    createPexQueryInput: CreatePexQueryInput,
    options?: RawAxiosRequestConfig,
  ) {
    return PexQueryApiFp(this.configuration)
      .createPexQuery(configurationId, createPexQueryInput, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {string} queryId pex-query Id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PexQueryApi
   */
  public deletePexQueryById(
    configurationId: string,
    queryId: string,
    options?: RawAxiosRequestConfig,
  ) {
    return PexQueryApiFp(this.configuration)
      .deletePexQueryById(configurationId, queryId, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {string} queryId pex-query Id
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PexQueryApi
   */
  public getPexQueryById(
    configurationId: string,
    queryId: string,
    options?: RawAxiosRequestConfig,
  ) {
    return PexQueryApiFp(this.configuration)
      .getPexQueryById(configurationId, queryId, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {number} [limit] Maximum number of records to fetch in a list
   * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PexQueryApi
   */
  public listPexQueries(
    configurationId: string,
    limit?: number,
    exclusiveStartKey?: string,
    options?: RawAxiosRequestConfig,
  ) {
    return PexQueryApiFp(this.configuration)
      .listPexQueries(configurationId, limit, exclusiveStartKey, options)
      .then((request) => request(this.axios, this.basePath))
  }

  /**
   *
   * @param {string} configurationId iotaConfiguration Id
   * @param {string} queryId pex-query Id
   * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PexQueryApi
   */
  public updatePexQueryById(
    configurationId: string,
    queryId: string,
    updatePexQueryInput: UpdatePexQueryInput,
    options?: RawAxiosRequestConfig,
  ) {
    return PexQueryApiFp(this.configuration)
      .updatePexQueryById(
        configurationId,
        queryId,
        updatePexQueryInput,
        options,
      )
      .then((request) => request(this.axios, this.basePath))
  }
}
