/**
 * IotaService
 * Affinidi IotaService Structure
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@affinidi.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import type { Configuration } from './configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import type { RequestArgs } from './base';
import { BaseAPI } from './base';
/**
 *
 * @export
 * @interface AlreadyExistsError
 */
export interface AlreadyExistsError {
    /**
     *
     * @type {string}
     * @memberof AlreadyExistsError
     */
    name: AlreadyExistsErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof AlreadyExistsError
     */
    message: AlreadyExistsErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof AlreadyExistsError
     */
    httpStatusCode: AlreadyExistsErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof AlreadyExistsError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof AlreadyExistsError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const AlreadyExistsErrorNameEnum: {
    readonly AlreadyExistsError: "AlreadyExistsError";
};
export type AlreadyExistsErrorNameEnum = (typeof AlreadyExistsErrorNameEnum)[keyof typeof AlreadyExistsErrorNameEnum];
export declare const AlreadyExistsErrorMessageEnum: {
    readonly AlreadyExistsParam: "Already exists: ${param}.";
};
export type AlreadyExistsErrorMessageEnum = (typeof AlreadyExistsErrorMessageEnum)[keyof typeof AlreadyExistsErrorMessageEnum];
export declare const AlreadyExistsErrorHttpStatusCodeEnum: {
    readonly NUMBER_409: 409;
};
export type AlreadyExistsErrorHttpStatusCodeEnum = (typeof AlreadyExistsErrorHttpStatusCodeEnum)[keyof typeof AlreadyExistsErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface AwsExchangeCredentials
 */
export interface AwsExchangeCredentials {
    /**
     * JWT signed with a machine token used to secure the web socket connection
     * @type {string}
     * @memberof AwsExchangeCredentials
     */
    assertion: string;
}
/**
 *
 * @export
 * @interface AwsExchangeCredentialsOK
 */
export interface AwsExchangeCredentialsOK {
    /**
     *
     * @type {string}
     * @memberof AwsExchangeCredentialsOK
     */
    connectionClientId: string;
    /**
     *
     * @type {AwsExchangeCredentialsOKCredentials}
     * @memberof AwsExchangeCredentialsOK
     */
    credentials: AwsExchangeCredentialsOKCredentials;
}
/**
 *
 * @export
 * @interface AwsExchangeCredentialsOKCredentials
 */
export interface AwsExchangeCredentialsOKCredentials {
    /**
     *
     * @type {string}
     * @memberof AwsExchangeCredentialsOKCredentials
     */
    identityId: string;
    /**
     *
     * @type {string}
     * @memberof AwsExchangeCredentialsOKCredentials
     */
    token: string;
}
/**
 *
 * @export
 * @interface CallbackInput
 */
export interface CallbackInput {
    /**
     * A string that must be a valid UUID (version 1-5).
     * @type {string}
     * @memberof CallbackInput
     */
    state: string;
    /**
     * A string that must be a valid JSON object. The structure of presentation submission should follow OID4VP standard.
     * @type {string}
     * @memberof CallbackInput
     */
    presentation_submission?: string;
    /**
     * A string that must be a valid JSON object. Ensure to escape special characters properly..
     * @type {string}
     * @memberof CallbackInput
     */
    vp_token?: string;
    /**
     * The error should follow the OAuth2 error format (e.g. invalid_request, login_required). Defaults to access_denied
     * @type {string}
     * @memberof CallbackInput
     */
    error?: string;
    /**
     * Description of the error in a human readable format
     * @type {string}
     * @memberof CallbackInput
     */
    error_description?: string;
}
/**
 *
 * @export
 * @interface ConsentDto
 */
export interface ConsentDto {
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    projectId: string;
    /**
     * id of the record
     * @type {string}
     * @memberof ConsentDto
     */
    id: string;
    /**
     * unique identifier of the user
     * @type {string}
     * @memberof ConsentDto
     */
    userId: string;
    /**
     * VC type of shared vc. If the actual VC has several VC types (excluding base types as VerifiableCredential) then for each of the a separate record will be added
     * @type {string}
     * @memberof ConsentDto
     */
    vcType: string;
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    status: ConsentDtoStatusEnum;
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    modifiedAt: string;
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    modifiedBy: string;
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    createdAt: string;
    /**
     *
     * @type {string}
     * @memberof ConsentDto
     */
    createdBy: string;
}
export declare const ConsentDtoStatusEnum: {
    readonly Given: "GIVEN";
};
export type ConsentDtoStatusEnum = (typeof ConsentDtoStatusEnum)[keyof typeof ConsentDtoStatusEnum];
/**
 *
 * @export
 * @interface CorsAwsExchangeCredentialsOK
 */
export interface CorsAwsExchangeCredentialsOK {
    /**
     *
     * @type {string}
     * @memberof CorsAwsExchangeCredentialsOK
     */
    corsAwsExchangeCredentialsOk?: string;
}
/**
 *
 * @export
 * @interface CorsIotOidc4vpcallbackOK
 */
export interface CorsIotOidc4vpcallbackOK {
    /**
     *
     * @type {string}
     * @memberof CorsIotOidc4vpcallbackOK
     */
    corsIotOidc4vpcallbackOk?: string;
}
/**
 *
 * @export
 * @interface CreateIotaConfigurationInput
 */
export interface CreateIotaConfigurationInput {
    /**
     * The name of the configuration
     * @type {string}
     * @memberof CreateIotaConfigurationInput
     */
    name: string;
    /**
     * Description of the configuration
     * @type {string}
     * @memberof CreateIotaConfigurationInput
     */
    description?: string;
    /**
     * The wallet Ari that will be used to sign
     * @type {string}
     * @memberof CreateIotaConfigurationInput
     */
    walletAri: string;
    /**
     * webhook to call when data is ready
     * @type {string}
     * @memberof CreateIotaConfigurationInput
     */
    iotaResponseWebhookURL?: string;
    /**
     *
     * @type {boolean}
     * @memberof CreateIotaConfigurationInput
     */
    enableVerification: boolean;
    /**
     *
     * @type {boolean}
     * @memberof CreateIotaConfigurationInput
     */
    enableConsentAuditLog: boolean;
    /**
     * token time to live in seconds
     * @type {number}
     * @memberof CreateIotaConfigurationInput
     */
    tokenMaxAge?: number;
    /**
     *
     * @type {IotaConfigurationDtoClientMetadata}
     * @memberof CreateIotaConfigurationInput
     */
    clientMetadata: IotaConfigurationDtoClientMetadata;
}
/**
 *
 * @export
 * @interface CreatePexQueryInput
 */
export interface CreatePexQueryInput {
    /**
     *
     * @type {string}
     * @memberof CreatePexQueryInput
     */
    name: string;
    /**
     * VP definition in JSON stringify format
     * @type {string}
     * @memberof CreatePexQueryInput
     */
    vpDefinition: string;
    /**
     * Description of query
     * @type {string}
     * @memberof CreatePexQueryInput
     */
    description?: string;
}
/**
 *
 * @export
 * @interface GetIotaConfigurationMetaDataOK
 */
export interface GetIotaConfigurationMetaDataOK {
    /**
     * application name that will be displayed in consent page
     * @type {string}
     * @memberof GetIotaConfigurationMetaDataOK
     */
    name: string;
    /**
     * origin url that will be displayed in consent page
     * @type {string}
     * @memberof GetIotaConfigurationMetaDataOK
     */
    origin: string;
    /**
     * logo url that will be displayed in consent page
     * @type {string}
     * @memberof GetIotaConfigurationMetaDataOK
     */
    logo: string;
}
/**
 *
 * @export
 * @interface InvalidParameterError
 */
export interface InvalidParameterError {
    /**
     *
     * @type {string}
     * @memberof InvalidParameterError
     */
    name: InvalidParameterErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof InvalidParameterError
     */
    message: InvalidParameterErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof InvalidParameterError
     */
    httpStatusCode: InvalidParameterErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof InvalidParameterError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof InvalidParameterError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const InvalidParameterErrorNameEnum: {
    readonly InvalidParameterError: "InvalidParameterError";
};
export type InvalidParameterErrorNameEnum = (typeof InvalidParameterErrorNameEnum)[keyof typeof InvalidParameterErrorNameEnum];
export declare const InvalidParameterErrorMessageEnum: {
    readonly InvalidParameterParam: "Invalid parameter: ${param}.";
};
export type InvalidParameterErrorMessageEnum = (typeof InvalidParameterErrorMessageEnum)[keyof typeof InvalidParameterErrorMessageEnum];
export declare const InvalidParameterErrorHttpStatusCodeEnum: {
    readonly NUMBER_400: 400;
};
export type InvalidParameterErrorHttpStatusCodeEnum = (typeof InvalidParameterErrorHttpStatusCodeEnum)[keyof typeof InvalidParameterErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface InvalidParameterErrorDetailsInner
 */
export interface InvalidParameterErrorDetailsInner {
    /**
     *
     * @type {string}
     * @memberof InvalidParameterErrorDetailsInner
     */
    issue: string;
    /**
     *
     * @type {string}
     * @memberof InvalidParameterErrorDetailsInner
     */
    field?: string;
    /**
     *
     * @type {string}
     * @memberof InvalidParameterErrorDetailsInner
     */
    value?: string;
    /**
     *
     * @type {string}
     * @memberof InvalidParameterErrorDetailsInner
     */
    location?: string;
}
/**
 *
 * @export
 * @interface IotaConfigurationDto
 */
export interface IotaConfigurationDto {
    /**
     * The ARI of the config
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    ari: string;
    /**
     *
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    configurationId: string;
    /**
     * The name of the config
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    name: string;
    /**
     *
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    projectId: string;
    /**
     * The wallet Ari that will be used to sign
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    walletAri: string;
    /**
     * token time to live in seconds
     * @type {number}
     * @memberof IotaConfigurationDto
     */
    tokenMaxAge: number;
    /**
     * webhook to call when data is ready
     * @type {string}
     * @memberof IotaConfigurationDto
     */
    iotaResponseWebhookURL?: string;
    /**
     *
     * @type {boolean}
     * @memberof IotaConfigurationDto
     */
    enableVerification: boolean;
    /**
     *
     * @type {boolean}
     * @memberof IotaConfigurationDto
     */
    enableConsentAuditLog: boolean;
    /**
     *
     * @type {IotaConfigurationDtoClientMetadata}
     * @memberof IotaConfigurationDto
     */
    clientMetadata: IotaConfigurationDtoClientMetadata;
}
/**
 * iota configuration client metadata
 * @export
 * @interface IotaConfigurationDtoClientMetadata
 */
export interface IotaConfigurationDtoClientMetadata {
    [key: string]: any;
    /**
     * application name that will be displayed in consent page
     * @type {string}
     * @memberof IotaConfigurationDtoClientMetadata
     */
    name: string;
    /**
     * origin url that will be displayed in consent page
     * @type {string}
     * @memberof IotaConfigurationDtoClientMetadata
     */
    origin: string;
    /**
     * logo url that will be displayed in consent page
     * @type {string}
     * @memberof IotaConfigurationDtoClientMetadata
     */
    logo: string;
}
/**
 *
 * @export
 * @interface ListConfigurationOK
 */
export interface ListConfigurationOK {
    /**
     *
     * @type {Array<IotaConfigurationDto>}
     * @memberof ListConfigurationOK
     */
    configurations: Array<IotaConfigurationDto>;
}
/**
 *
 * @export
 * @interface ListLoggedConsentsOK
 */
export interface ListLoggedConsentsOK {
    /**
     *
     * @type {Array<ConsentDto>}
     * @memberof ListLoggedConsentsOK
     */
    consents: Array<ConsentDto>;
    /**
     *
     * @type {string}
     * @memberof ListLoggedConsentsOK
     */
    lastEvaluatedKey?: string;
}
/**
 *
 * @export
 * @interface ListPexQueriesOK
 */
export interface ListPexQueriesOK {
    /**
     *
     * @type {Array<PexQueryDto>}
     * @memberof ListPexQueriesOK
     */
    pexQueries: Array<PexQueryDto>;
    /**
     *
     * @type {string}
     * @memberof ListPexQueriesOK
     */
    lastEvaluatedKey?: string;
}
/**
 *
 * @export
 * @interface MessagePublishingError
 */
export interface MessagePublishingError {
    /**
     *
     * @type {string}
     * @memberof MessagePublishingError
     */
    name: MessagePublishingErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof MessagePublishingError
     */
    message: MessagePublishingErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof MessagePublishingError
     */
    httpStatusCode: MessagePublishingErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof MessagePublishingError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof MessagePublishingError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const MessagePublishingErrorNameEnum: {
    readonly MessagePublishingError: "MessagePublishingError";
};
export type MessagePublishingErrorNameEnum = (typeof MessagePublishingErrorNameEnum)[keyof typeof MessagePublishingErrorNameEnum];
export declare const MessagePublishingErrorMessageEnum: {
    readonly NotAbleToPublishMessagesToTopic: "Not able to publish messages to topic";
};
export type MessagePublishingErrorMessageEnum = (typeof MessagePublishingErrorMessageEnum)[keyof typeof MessagePublishingErrorMessageEnum];
export declare const MessagePublishingErrorHttpStatusCodeEnum: {
    readonly NUMBER_500: 500;
};
export type MessagePublishingErrorHttpStatusCodeEnum = (typeof MessagePublishingErrorHttpStatusCodeEnum)[keyof typeof MessagePublishingErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface NotFoundError
 */
export interface NotFoundError {
    /**
     *
     * @type {string}
     * @memberof NotFoundError
     */
    name: NotFoundErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof NotFoundError
     */
    message: NotFoundErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof NotFoundError
     */
    httpStatusCode: NotFoundErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof NotFoundError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof NotFoundError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const NotFoundErrorNameEnum: {
    readonly NotFoundError: "NotFoundError";
};
export type NotFoundErrorNameEnum = (typeof NotFoundErrorNameEnum)[keyof typeof NotFoundErrorNameEnum];
export declare const NotFoundErrorMessageEnum: {
    readonly NotFoundParam: "Not found: ${param}.";
};
export type NotFoundErrorMessageEnum = (typeof NotFoundErrorMessageEnum)[keyof typeof NotFoundErrorMessageEnum];
export declare const NotFoundErrorHttpStatusCodeEnum: {
    readonly NUMBER_404: 404;
};
export type NotFoundErrorHttpStatusCodeEnum = (typeof NotFoundErrorHttpStatusCodeEnum)[keyof typeof NotFoundErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface OperationForbiddenError
 */
export interface OperationForbiddenError {
    /**
     *
     * @type {string}
     * @memberof OperationForbiddenError
     */
    name: OperationForbiddenErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof OperationForbiddenError
     */
    message: OperationForbiddenErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof OperationForbiddenError
     */
    httpStatusCode: OperationForbiddenErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof OperationForbiddenError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof OperationForbiddenError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const OperationForbiddenErrorNameEnum: {
    readonly OperationForbiddenError: "OperationForbiddenError";
};
export type OperationForbiddenErrorNameEnum = (typeof OperationForbiddenErrorNameEnum)[keyof typeof OperationForbiddenErrorNameEnum];
export declare const OperationForbiddenErrorMessageEnum: {
    readonly OperationForbiddenParam: "Operation forbidden: ${param}.";
};
export type OperationForbiddenErrorMessageEnum = (typeof OperationForbiddenErrorMessageEnum)[keyof typeof OperationForbiddenErrorMessageEnum];
export declare const OperationForbiddenErrorHttpStatusCodeEnum: {
    readonly NUMBER_403: 403;
};
export type OperationForbiddenErrorHttpStatusCodeEnum = (typeof OperationForbiddenErrorHttpStatusCodeEnum)[keyof typeof OperationForbiddenErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface PexQueryDto
 */
export interface PexQueryDto {
    /**
     *
     * @type {string}
     * @memberof PexQueryDto
     */
    ari: string;
    /**
     *
     * @type {string}
     * @memberof PexQueryDto
     */
    queryId: string;
    /**
     *
     * @type {string}
     * @memberof PexQueryDto
     */
    name: string;
    /**
     *
     * @type {string}
     * @memberof PexQueryDto
     */
    description: string;
    /**
     *
     * @type {string}
     * @memberof PexQueryDto
     */
    configurationAri: string;
    /**
     * VP definition in JSON stringify format
     * @type {string}
     * @memberof PexQueryDto
     */
    vpDefinition: string;
}
/**
 *
 * @export
 * @interface PrepareRequest
 */
export interface PrepareRequest {
    /**
     *
     * @type {string}
     * @memberof PrepareRequest
     */
    connectionClientId: string;
    /**
     *
     * @type {string}
     * @memberof PrepareRequest
     */
    queryId: string;
    /**
     *
     * @type {string}
     * @memberof PrepareRequest
     */
    correlationId: string;
    /**
     * token time to live in seconds
     * @type {number}
     * @memberof PrepareRequest
     */
    tokenMaxAge?: number;
    /**
     *
     * @type {string}
     * @memberof PrepareRequest
     */
    audience?: string;
}
/**
 *
 * @export
 * @interface PrepareRequestCreated
 */
export interface PrepareRequestCreated {
    /**
     *
     * @type {PrepareRequestCreatedData}
     * @memberof PrepareRequestCreated
     */
    data: PrepareRequestCreatedData;
}
/**
 *
 * @export
 * @interface PrepareRequestCreatedData
 */
export interface PrepareRequestCreatedData {
    /**
     *
     * @type {string}
     * @memberof PrepareRequestCreatedData
     */
    jwt: string;
    /**
     *
     * @type {string}
     * @memberof PrepareRequestCreatedData
     */
    correlationId: string;
}
/**
 *
 * @export
 * @interface ResourceLimitExceededError
 */
export interface ResourceLimitExceededError {
    /**
     *
     * @type {string}
     * @memberof ResourceLimitExceededError
     */
    name: ResourceLimitExceededErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof ResourceLimitExceededError
     */
    message: ResourceLimitExceededErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof ResourceLimitExceededError
     */
    httpStatusCode: ResourceLimitExceededErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof ResourceLimitExceededError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof ResourceLimitExceededError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const ResourceLimitExceededErrorNameEnum: {
    readonly ResourceLimitExceededError: "ResourceLimitExceededError";
};
export type ResourceLimitExceededErrorNameEnum = (typeof ResourceLimitExceededErrorNameEnum)[keyof typeof ResourceLimitExceededErrorNameEnum];
export declare const ResourceLimitExceededErrorMessageEnum: {
    readonly ResourceLimitExceededParam: "Resource limit exceeded: ${param}.";
};
export type ResourceLimitExceededErrorMessageEnum = (typeof ResourceLimitExceededErrorMessageEnum)[keyof typeof ResourceLimitExceededErrorMessageEnum];
export declare const ResourceLimitExceededErrorHttpStatusCodeEnum: {
    readonly NUMBER_422: 422;
};
export type ResourceLimitExceededErrorHttpStatusCodeEnum = (typeof ResourceLimitExceededErrorHttpStatusCodeEnum)[keyof typeof ResourceLimitExceededErrorHttpStatusCodeEnum];
/**
 *
 * @export
 * @interface UpdateConfigurationByIdInput
 */
export interface UpdateConfigurationByIdInput {
    /**
     * The name of the config
     * @type {string}
     * @memberof UpdateConfigurationByIdInput
     */
    name?: string;
    /**
     * The wallet Ari that will be used to sign
     * @type {string}
     * @memberof UpdateConfigurationByIdInput
     */
    walletAri?: string;
    /**
     * webhook to call when data is ready
     * @type {string}
     * @memberof UpdateConfigurationByIdInput
     */
    iotaResponseWebhookURL?: string;
    /**
     *
     * @type {boolean}
     * @memberof UpdateConfigurationByIdInput
     */
    enableVerification?: boolean;
    /**
     *
     * @type {boolean}
     * @memberof UpdateConfigurationByIdInput
     */
    enableConsentAuditLog?: boolean;
    /**
     * token time to live in seconds
     * @type {number}
     * @memberof UpdateConfigurationByIdInput
     */
    tokenMaxAge?: number;
    /**
     * The description of the config
     * @type {string}
     * @memberof UpdateConfigurationByIdInput
     */
    description?: string;
    /**
     *
     * @type {IotaConfigurationDtoClientMetadata}
     * @memberof UpdateConfigurationByIdInput
     */
    clientMetadata?: IotaConfigurationDtoClientMetadata;
}
/**
 *
 * @export
 * @interface UpdateConfigurationByIdOK
 */
export interface UpdateConfigurationByIdOK {
    /**
     *
     * @type {string}
     * @memberof UpdateConfigurationByIdOK
     */
    updateConfigurationByIdOk?: string;
}
/**
 *
 * @export
 * @interface UpdatePexQueryInput
 */
export interface UpdatePexQueryInput {
    /**
     * VP definition in JSON stringify format
     * @type {string}
     * @memberof UpdatePexQueryInput
     */
    vpDefinition?: string;
    /**
     *
     * @type {string}
     * @memberof UpdatePexQueryInput
     */
    description?: string;
}
/**
 *
 * @export
 * @interface VPTokenValidationError
 */
export interface VPTokenValidationError {
    /**
     *
     * @type {string}
     * @memberof VPTokenValidationError
     */
    name: VPTokenValidationErrorNameEnum;
    /**
     *
     * @type {string}
     * @memberof VPTokenValidationError
     */
    message: VPTokenValidationErrorMessageEnum;
    /**
     *
     * @type {number}
     * @memberof VPTokenValidationError
     */
    httpStatusCode: VPTokenValidationErrorHttpStatusCodeEnum;
    /**
     *
     * @type {string}
     * @memberof VPTokenValidationError
     */
    traceId: string;
    /**
     *
     * @type {Array<InvalidParameterErrorDetailsInner>}
     * @memberof VPTokenValidationError
     */
    details?: Array<InvalidParameterErrorDetailsInner>;
}
export declare const VPTokenValidationErrorNameEnum: {
    readonly VpTokenValidationError: "VPTokenValidationError";
};
export type VPTokenValidationErrorNameEnum = (typeof VPTokenValidationErrorNameEnum)[keyof typeof VPTokenValidationErrorNameEnum];
export declare const VPTokenValidationErrorMessageEnum: {
    readonly VpTokenValidationEndedWithAnError: "VP token validation ended with an error";
};
export type VPTokenValidationErrorMessageEnum = (typeof VPTokenValidationErrorMessageEnum)[keyof typeof VPTokenValidationErrorMessageEnum];
export declare const VPTokenValidationErrorHttpStatusCodeEnum: {
    readonly NUMBER_400: 400;
};
export type VPTokenValidationErrorHttpStatusCodeEnum = (typeof VPTokenValidationErrorHttpStatusCodeEnum)[keyof typeof VPTokenValidationErrorHttpStatusCodeEnum];
/**
 * CallbackApi - axios parameter creator
 * @export
 */
export declare const CallbackApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    iotOIDC4VPCallback: (callbackInput: CallbackInput, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * CallbackApi - functional programming interface
 * @export
 */
export declare const CallbackApiFp: (configuration?: Configuration) => {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    iotOIDC4VPCallback(callbackInput: CallbackInput, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<object>>;
};
/**
 * CallbackApi - factory interface
 * @export
 */
export declare const CallbackApiFactory: (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) => {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    iotOIDC4VPCallback(callbackInput: CallbackInput, options?: any): AxiosPromise<object>;
};
/**
 * CallbackApi - object-oriented interface
 * @export
 * @class CallbackApi
 * @extends {BaseAPI}
 */
export declare class CallbackApi extends BaseAPI {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CallbackApi
     */
    iotOIDC4VPCallback(callbackInput: CallbackInput, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<object, any>>;
}
/**
 * ConfigurationsApi - axios parameter creator
 * @export
 */
export declare const ConfigurationsApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createIotaConfiguration: (createIotaConfigurationInput: CreateIotaConfigurationInput, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteIotaConfigurationById: (configurationId: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationById: (configurationId: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationMetaData: (projectId: string, configurationId: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listIotaConfigurations: (options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateIotaConfigurationById: (configurationId: string, updateConfigurationByIdInput: UpdateConfigurationByIdInput, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * ConfigurationsApi - functional programming interface
 * @export
 */
export declare const ConfigurationsApiFp: (configuration?: Configuration) => {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createIotaConfiguration(createIotaConfigurationInput: CreateIotaConfigurationInput, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<IotaConfigurationDto>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteIotaConfigurationById(configurationId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationById(configurationId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<IotaConfigurationDto>>;
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationMetaData(projectId: string, configurationId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<GetIotaConfigurationMetaDataOK>>;
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listIotaConfigurations(options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListConfigurationOK>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateIotaConfigurationById(configurationId: string, updateConfigurationByIdInput: UpdateConfigurationByIdInput, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<IotaConfigurationDto>>;
};
/**
 * ConfigurationsApi - factory interface
 * @export
 */
export declare const ConfigurationsApiFactory: (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) => {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createIotaConfiguration(createIotaConfigurationInput: CreateIotaConfigurationInput, options?: any): AxiosPromise<IotaConfigurationDto>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteIotaConfigurationById(configurationId: string, options?: any): AxiosPromise<void>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationById(configurationId: string, options?: any): AxiosPromise<IotaConfigurationDto>;
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getIotaConfigurationMetaData(projectId: string, configurationId: string, options?: any): AxiosPromise<GetIotaConfigurationMetaDataOK>;
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listIotaConfigurations(options?: any): AxiosPromise<ListConfigurationOK>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updateIotaConfigurationById(configurationId: string, updateConfigurationByIdInput: UpdateConfigurationByIdInput, options?: any): AxiosPromise<IotaConfigurationDto>;
};
/**
 * ConfigurationsApi - object-oriented interface
 * @export
 * @class ConfigurationsApi
 * @extends {BaseAPI}
 */
export declare class ConfigurationsApi extends BaseAPI {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    createIotaConfiguration(createIotaConfigurationInput: CreateIotaConfigurationInput, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<IotaConfigurationDto, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    deleteIotaConfigurationById(configurationId: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<void, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationById(configurationId: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<IotaConfigurationDto, any>>;
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationMetaData(projectId: string, configurationId: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<GetIotaConfigurationMetaDataOK, any>>;
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    listIotaConfigurations(options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<ListConfigurationOK, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    updateIotaConfigurationById(configurationId: string, updateConfigurationByIdInput: UpdateConfigurationByIdInput, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<IotaConfigurationDto, any>>;
}
/**
 * DefaultApi - axios parameter creator
 * @export
 */
export declare const DefaultApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLoggedConsents: (userId?: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * DefaultApi - functional programming interface
 * @export
 */
export declare const DefaultApiFp: (configuration?: Configuration) => {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLoggedConsents(userId?: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListLoggedConsentsOK>>;
};
/**
 * DefaultApi - factory interface
 * @export
 */
export declare const DefaultApiFactory: (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) => {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listLoggedConsents(userId?: string, limit?: number, exclusiveStartKey?: string, options?: any): AxiosPromise<ListLoggedConsentsOK>;
};
/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export declare class DefaultApi extends BaseAPI {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    listLoggedConsents(userId?: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<ListLoggedConsentsOK, any>>;
}
/**
 * IotaApi - axios parameter creator
 * @export
 */
export declare const IotaApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    awsExchangeCredentials: (awsExchangeCredentials: AwsExchangeCredentials, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * IotaApi - functional programming interface
 * @export
 */
export declare const IotaApiFp: (configuration?: Configuration) => {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    awsExchangeCredentials(awsExchangeCredentials: AwsExchangeCredentials, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<AwsExchangeCredentialsOK>>;
};
/**
 * IotaApi - factory interface
 * @export
 */
export declare const IotaApiFactory: (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) => {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    awsExchangeCredentials(awsExchangeCredentials: AwsExchangeCredentials, options?: any): AxiosPromise<AwsExchangeCredentialsOK>;
};
/**
 * IotaApi - object-oriented interface
 * @export
 * @class IotaApi
 * @extends {BaseAPI}
 */
export declare class IotaApi extends BaseAPI {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof IotaApi
     */
    awsExchangeCredentials(awsExchangeCredentials: AwsExchangeCredentials, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<AwsExchangeCredentialsOK, any>>;
}
/**
 * PexQueryApi - axios parameter creator
 * @export
 */
export declare const PexQueryApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPexQuery: (configurationId: string, createPexQueryInput: CreatePexQueryInput, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePexQueryById: (configurationId: string, queryId: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPexQueryById: (configurationId: string, queryId: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPexQueries: (configurationId: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePexQueryById: (configurationId: string, queryId: string, updatePexQueryInput: UpdatePexQueryInput, options?: RawAxiosRequestConfig) => Promise<RequestArgs>;
};
/**
 * PexQueryApi - functional programming interface
 * @export
 */
export declare const PexQueryApiFp: (configuration?: Configuration) => {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPexQuery(configurationId: string, createPexQueryInput: CreatePexQueryInput, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePexQueryById(configurationId: string, queryId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<void>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPexQueryById(configurationId: string, queryId: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPexQueries(configurationId: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<ListPexQueriesOK>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePexQueryById(configurationId: string, queryId: string, updatePexQueryInput: UpdatePexQueryInput, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PexQueryDto>>;
};
/**
 * PexQueryApi - factory interface
 * @export
 */
export declare const PexQueryApiFactory: (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) => {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPexQuery(configurationId: string, createPexQueryInput: CreatePexQueryInput, options?: any): AxiosPromise<PexQueryDto>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePexQueryById(configurationId: string, queryId: string, options?: any): AxiosPromise<void>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPexQueryById(configurationId: string, queryId: string, options?: any): AxiosPromise<PexQueryDto>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPexQueries(configurationId: string, limit?: number, exclusiveStartKey?: string, options?: any): AxiosPromise<ListPexQueriesOK>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePexQueryById(configurationId: string, queryId: string, updatePexQueryInput: UpdatePexQueryInput, options?: any): AxiosPromise<PexQueryDto>;
};
/**
 * PexQueryApi - object-oriented interface
 * @export
 * @class PexQueryApi
 * @extends {BaseAPI}
 */
export declare class PexQueryApi extends BaseAPI {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    createPexQuery(configurationId: string, createPexQueryInput: CreatePexQueryInput, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<PexQueryDto, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    deletePexQueryById(configurationId: string, queryId: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<void, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    getPexQueryById(configurationId: string, queryId: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<PexQueryDto, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    listPexQueries(configurationId: string, limit?: number, exclusiveStartKey?: string, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<ListPexQueriesOK, any>>;
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    updatePexQueryById(configurationId: string, queryId: string, updatePexQueryInput: UpdatePexQueryInput, options?: RawAxiosRequestConfig): Promise<import("axios").AxiosResponse<PexQueryDto, any>>;
}
