"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * IotaService
 * Affinidi IotaService Structure
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@affinidi.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PexQueryApi = exports.PexQueryApiFactory = exports.PexQueryApiFp = exports.PexQueryApiAxiosParamCreator = exports.IotaApi = exports.IotaApiFactory = exports.IotaApiFp = exports.IotaApiAxiosParamCreator = exports.DefaultApi = exports.DefaultApiFactory = exports.DefaultApiFp = exports.DefaultApiAxiosParamCreator = exports.ConfigurationsApi = exports.ConfigurationsApiFactory = exports.ConfigurationsApiFp = exports.ConfigurationsApiAxiosParamCreator = exports.CallbackApi = exports.CallbackApiFactory = exports.CallbackApiFp = exports.CallbackApiAxiosParamCreator = exports.VPTokenValidationErrorHttpStatusCodeEnum = exports.VPTokenValidationErrorMessageEnum = exports.VPTokenValidationErrorNameEnum = exports.ResourceLimitExceededErrorHttpStatusCodeEnum = exports.ResourceLimitExceededErrorMessageEnum = exports.ResourceLimitExceededErrorNameEnum = exports.OperationForbiddenErrorHttpStatusCodeEnum = exports.OperationForbiddenErrorMessageEnum = exports.OperationForbiddenErrorNameEnum = exports.NotFoundErrorHttpStatusCodeEnum = exports.NotFoundErrorMessageEnum = exports.NotFoundErrorNameEnum = exports.MessagePublishingErrorHttpStatusCodeEnum = exports.MessagePublishingErrorMessageEnum = exports.MessagePublishingErrorNameEnum = exports.InvalidParameterErrorHttpStatusCodeEnum = exports.InvalidParameterErrorMessageEnum = exports.InvalidParameterErrorNameEnum = exports.ConsentDtoStatusEnum = exports.AlreadyExistsErrorHttpStatusCodeEnum = exports.AlreadyExistsErrorMessageEnum = exports.AlreadyExistsErrorNameEnum = void 0;
const axios_1 = __importDefault(require("axios"));
// Some imports not used depending on template conditions
// @ts-ignore
const common_1 = require("./common");
// @ts-ignore
const base_1 = require("./base");
exports.AlreadyExistsErrorNameEnum = {
    AlreadyExistsError: 'AlreadyExistsError',
};
exports.AlreadyExistsErrorMessageEnum = {
    AlreadyExistsParam: 'Already exists: ${param}.',
};
exports.AlreadyExistsErrorHttpStatusCodeEnum = {
    NUMBER_409: 409,
};
exports.ConsentDtoStatusEnum = {
    Given: 'GIVEN',
};
exports.InvalidParameterErrorNameEnum = {
    InvalidParameterError: 'InvalidParameterError',
};
exports.InvalidParameterErrorMessageEnum = {
    InvalidParameterParam: 'Invalid parameter: ${param}.',
};
exports.InvalidParameterErrorHttpStatusCodeEnum = {
    NUMBER_400: 400,
};
exports.MessagePublishingErrorNameEnum = {
    MessagePublishingError: 'MessagePublishingError',
};
exports.MessagePublishingErrorMessageEnum = {
    NotAbleToPublishMessagesToTopic: 'Not able to publish messages to topic',
};
exports.MessagePublishingErrorHttpStatusCodeEnum = {
    NUMBER_500: 500,
};
exports.NotFoundErrorNameEnum = {
    NotFoundError: 'NotFoundError',
};
exports.NotFoundErrorMessageEnum = {
    NotFoundParam: 'Not found: ${param}.',
};
exports.NotFoundErrorHttpStatusCodeEnum = {
    NUMBER_404: 404,
};
exports.OperationForbiddenErrorNameEnum = {
    OperationForbiddenError: 'OperationForbiddenError',
};
exports.OperationForbiddenErrorMessageEnum = {
    OperationForbiddenParam: 'Operation forbidden: ${param}.',
};
exports.OperationForbiddenErrorHttpStatusCodeEnum = {
    NUMBER_403: 403,
};
exports.ResourceLimitExceededErrorNameEnum = {
    ResourceLimitExceededError: 'ResourceLimitExceededError',
};
exports.ResourceLimitExceededErrorMessageEnum = {
    ResourceLimitExceededParam: 'Resource limit exceeded: ${param}.',
};
exports.ResourceLimitExceededErrorHttpStatusCodeEnum = {
    NUMBER_422: 422,
};
exports.VPTokenValidationErrorNameEnum = {
    VpTokenValidationError: 'VPTokenValidationError',
};
exports.VPTokenValidationErrorMessageEnum = {
    VpTokenValidationEndedWithAnError: 'VP token validation ended with an error',
};
exports.VPTokenValidationErrorHttpStatusCodeEnum = {
    NUMBER_400: 400,
};
/**
 * CallbackApi - axios parameter creator
 * @export
 */
const CallbackApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback: (callbackInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'callbackInput' is not null or undefined
            (0, common_1.assertParamExists)('iotOIDC4VPCallback', 'callbackInput', callbackInput);
            const localVarPath = `/v1/callback`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(callbackInput, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
exports.CallbackApiAxiosParamCreator = CallbackApiAxiosParamCreator;
/**
 * CallbackApi - functional programming interface
 * @export
 */
const CallbackApiFp = function (configuration) {
    const localVarAxiosParamCreator = (0, exports.CallbackApiAxiosParamCreator)(configuration);
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback(callbackInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.iotOIDC4VPCallback(callbackInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['CallbackApi.iotOIDC4VPCallback']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
exports.CallbackApiFp = CallbackApiFp;
/**
 * CallbackApi - factory interface
 * @export
 */
const CallbackApiFactory = function (configuration, basePath, axios) {
    const localVarFp = (0, exports.CallbackApiFp)(configuration);
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback(callbackInput, options) {
            return localVarFp
                .iotOIDC4VPCallback(callbackInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
exports.CallbackApiFactory = CallbackApiFactory;
/**
 * CallbackApi - object-oriented interface
 * @export
 * @class CallbackApi
 * @extends {BaseAPI}
 */
class CallbackApi extends base_1.BaseAPI {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CallbackApi
     */
    iotOIDC4VPCallback(callbackInput, options) {
        return (0, exports.CallbackApiFp)(this.configuration)
            .iotOIDC4VPCallback(callbackInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
exports.CallbackApi = CallbackApi;
/**
 * ConfigurationsApi - axios parameter creator
 * @export
 */
const ConfigurationsApiAxiosParamCreator = function (configuration) {
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration: (createIotaConfigurationInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'createIotaConfigurationInput' is not null or undefined
            (0, common_1.assertParamExists)('createIotaConfiguration', 'createIotaConfigurationInput', createIotaConfigurationInput);
            const localVarPath = `/v1/configurations`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(createIotaConfigurationInput, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById: (configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('deleteIotaConfigurationById', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'DELETE' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById: (configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('getIotaConfigurationById', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData: (projectId, configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'projectId' is not null or undefined
            (0, common_1.assertParamExists)('getIotaConfigurationMetaData', 'projectId', projectId);
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('getIotaConfigurationMetaData', 'configurationId', configurationId);
            const localVarPath = `/v1/projects/{projectId}/configurations/{configurationId}/metadata`
                .replace(`{${'projectId'}}`, encodeURIComponent(String(projectId)))
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations: (options = {}) => __awaiter(this, void 0, void 0, function* () {
            const localVarPath = `/v1/configurations`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById: (configurationId, updateConfigurationByIdInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('updateIotaConfigurationById', 'configurationId', configurationId);
            // verify required parameter 'updateConfigurationByIdInput' is not null or undefined
            (0, common_1.assertParamExists)('updateIotaConfigurationById', 'updateConfigurationByIdInput', updateConfigurationByIdInput);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'PATCH' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(updateConfigurationByIdInput, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
exports.ConfigurationsApiAxiosParamCreator = ConfigurationsApiAxiosParamCreator;
/**
 * ConfigurationsApi - functional programming interface
 * @export
 */
const ConfigurationsApiFp = function (configuration) {
    const localVarAxiosParamCreator = (0, exports.ConfigurationsApiAxiosParamCreator)(configuration);
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration(createIotaConfigurationInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.createIotaConfiguration(createIotaConfigurationInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.createIotaConfiguration']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById(configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.deleteIotaConfigurationById(configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.deleteIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById(configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getIotaConfigurationById(configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.getIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData(projectId, configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getIotaConfigurationMetaData(projectId, configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.getIotaConfigurationMetaData']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations(options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listIotaConfigurations(options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.listIotaConfigurations']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['ConfigurationsApi.updateIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
exports.ConfigurationsApiFp = ConfigurationsApiFp;
/**
 * ConfigurationsApi - factory interface
 * @export
 */
const ConfigurationsApiFactory = function (configuration, basePath, axios) {
    const localVarFp = (0, exports.ConfigurationsApiFp)(configuration);
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration(createIotaConfigurationInput, options) {
            return localVarFp
                .createIotaConfiguration(createIotaConfigurationInput, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById(configurationId, options) {
            return localVarFp
                .deleteIotaConfigurationById(configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById(configurationId, options) {
            return localVarFp
                .getIotaConfigurationById(configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData(projectId, configurationId, options) {
            return localVarFp
                .getIotaConfigurationMetaData(projectId, configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations(options) {
            return localVarFp
                .listIotaConfigurations(options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
            return localVarFp
                .updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
exports.ConfigurationsApiFactory = ConfigurationsApiFactory;
/**
 * ConfigurationsApi - object-oriented interface
 * @export
 * @class ConfigurationsApi
 * @extends {BaseAPI}
 */
class ConfigurationsApi extends base_1.BaseAPI {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    createIotaConfiguration(createIotaConfigurationInput, options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .createIotaConfiguration(createIotaConfigurationInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    deleteIotaConfigurationById(configurationId, options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .deleteIotaConfigurationById(configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationById(configurationId, options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .getIotaConfigurationById(configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationMetaData(projectId, configurationId, options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .getIotaConfigurationMetaData(projectId, configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    listIotaConfigurations(options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .listIotaConfigurations(options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
        return (0, exports.ConfigurationsApiFp)(this.configuration)
            .updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
exports.ConfigurationsApi = ConfigurationsApi;
/**
 * DefaultApi - axios parameter creator
 * @export
 */
const DefaultApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents: (userId, limit, exclusiveStartKey, options = {}) => __awaiter(this, void 0, void 0, function* () {
            const localVarPath = `/v1/logged-consents`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            if (userId !== undefined) {
                localVarQueryParameter['userId'] = userId;
            }
            if (limit !== undefined) {
                localVarQueryParameter['limit'] = limit;
            }
            if (exclusiveStartKey !== undefined) {
                localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey;
            }
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
exports.DefaultApiAxiosParamCreator = DefaultApiAxiosParamCreator;
/**
 * DefaultApi - functional programming interface
 * @export
 */
const DefaultApiFp = function (configuration) {
    const localVarAxiosParamCreator = (0, exports.DefaultApiAxiosParamCreator)(configuration);
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents(userId, limit, exclusiveStartKey, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listLoggedConsents(userId, limit, exclusiveStartKey, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['DefaultApi.listLoggedConsents']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
exports.DefaultApiFp = DefaultApiFp;
/**
 * DefaultApi - factory interface
 * @export
 */
const DefaultApiFactory = function (configuration, basePath, axios) {
    const localVarFp = (0, exports.DefaultApiFp)(configuration);
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents(userId, limit, exclusiveStartKey, options) {
            return localVarFp
                .listLoggedConsents(userId, limit, exclusiveStartKey, options)
                .then((request) => request(axios, basePath));
        },
    };
};
exports.DefaultApiFactory = DefaultApiFactory;
/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
class DefaultApi extends base_1.BaseAPI {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    listLoggedConsents(userId, limit, exclusiveStartKey, options) {
        return (0, exports.DefaultApiFp)(this.configuration)
            .listLoggedConsents(userId, limit, exclusiveStartKey, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
exports.DefaultApi = DefaultApi;
/**
 * IotaApi - axios parameter creator
 * @export
 */
const IotaApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials: (awsExchangeCredentials, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'awsExchangeCredentials' is not null or undefined
            (0, common_1.assertParamExists)('awsExchangeCredentials', 'awsExchangeCredentials', awsExchangeCredentials);
            const localVarPath = `/v1/aws-exchange-credentials`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(awsExchangeCredentials, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
exports.IotaApiAxiosParamCreator = IotaApiAxiosParamCreator;
/**
 * IotaApi - functional programming interface
 * @export
 */
const IotaApiFp = function (configuration) {
    const localVarAxiosParamCreator = (0, exports.IotaApiAxiosParamCreator)(configuration);
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials(awsExchangeCredentials, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.awsExchangeCredentials(awsExchangeCredentials, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['IotaApi.awsExchangeCredentials']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
exports.IotaApiFp = IotaApiFp;
/**
 * IotaApi - factory interface
 * @export
 */
const IotaApiFactory = function (configuration, basePath, axios) {
    const localVarFp = (0, exports.IotaApiFp)(configuration);
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials(awsExchangeCredentials, options) {
            return localVarFp
                .awsExchangeCredentials(awsExchangeCredentials, options)
                .then((request) => request(axios, basePath));
        },
    };
};
exports.IotaApiFactory = IotaApiFactory;
/**
 * IotaApi - object-oriented interface
 * @export
 * @class IotaApi
 * @extends {BaseAPI}
 */
class IotaApi extends base_1.BaseAPI {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof IotaApi
     */
    awsExchangeCredentials(awsExchangeCredentials, options) {
        return (0, exports.IotaApiFp)(this.configuration)
            .awsExchangeCredentials(awsExchangeCredentials, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
exports.IotaApi = IotaApi;
/**
 * PexQueryApi - axios parameter creator
 * @export
 */
const PexQueryApiAxiosParamCreator = function (configuration) {
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery: (configurationId, createPexQueryInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('createPexQuery', 'configurationId', configurationId);
            // verify required parameter 'createPexQueryInput' is not null or undefined
            (0, common_1.assertParamExists)('createPexQuery', 'createPexQueryInput', createPexQueryInput);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(createPexQueryInput, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById: (configurationId, queryId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('deletePexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            (0, common_1.assertParamExists)('deletePexQueryById', 'queryId', queryId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'DELETE' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById: (configurationId, queryId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('getPexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            (0, common_1.assertParamExists)('getPexQueryById', 'queryId', queryId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries: (configurationId, limit, exclusiveStartKey, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('listPexQueries', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            if (limit !== undefined) {
                localVarQueryParameter['limit'] = limit;
            }
            if (exclusiveStartKey !== undefined) {
                localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey;
            }
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById: (configurationId, queryId, updatePexQueryInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            (0, common_1.assertParamExists)('updatePexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            (0, common_1.assertParamExists)('updatePexQueryById', 'queryId', queryId);
            // verify required parameter 'updatePexQueryInput' is not null or undefined
            (0, common_1.assertParamExists)('updatePexQueryById', 'updatePexQueryInput', updatePexQueryInput);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, common_1.DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'PATCH' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield (0, common_1.setApiKeyToObject)(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            (0, common_1.setSearchParams)(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = (0, common_1.serializeDataIfNeeded)(updatePexQueryInput, localVarRequestOptions, configuration);
            return {
                url: (0, common_1.toPathString)(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
exports.PexQueryApiAxiosParamCreator = PexQueryApiAxiosParamCreator;
/**
 * PexQueryApi - functional programming interface
 * @export
 */
const PexQueryApiFp = function (configuration) {
    const localVarAxiosParamCreator = (0, exports.PexQueryApiAxiosParamCreator)(configuration);
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery(configurationId, createPexQueryInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.createPexQuery(configurationId, createPexQueryInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['PexQueryApi.createPexQuery']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById(configurationId, queryId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.deletePexQueryById(configurationId, queryId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['PexQueryApi.deletePexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById(configurationId, queryId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getPexQueryById(configurationId, queryId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['PexQueryApi.getPexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries(configurationId, limit, exclusiveStartKey, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listPexQueries(configurationId, limit, exclusiveStartKey, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['PexQueryApi.listPexQueries']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.updatePexQueryById(configurationId, queryId, updatePexQueryInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = base_1.operationServerMap['PexQueryApi.updatePexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => (0, common_1.createRequestFunction)(localVarAxiosArgs, axios_1.default, base_1.BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
exports.PexQueryApiFp = PexQueryApiFp;
/**
 * PexQueryApi - factory interface
 * @export
 */
const PexQueryApiFactory = function (configuration, basePath, axios) {
    const localVarFp = (0, exports.PexQueryApiFp)(configuration);
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery(configurationId, createPexQueryInput, options) {
            return localVarFp
                .createPexQuery(configurationId, createPexQueryInput, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById(configurationId, queryId, options) {
            return localVarFp
                .deletePexQueryById(configurationId, queryId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById(configurationId, queryId, options) {
            return localVarFp
                .getPexQueryById(configurationId, queryId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries(configurationId, limit, exclusiveStartKey, options) {
            return localVarFp
                .listPexQueries(configurationId, limit, exclusiveStartKey, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
            return localVarFp
                .updatePexQueryById(configurationId, queryId, updatePexQueryInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
exports.PexQueryApiFactory = PexQueryApiFactory;
/**
 * PexQueryApi - object-oriented interface
 * @export
 * @class PexQueryApi
 * @extends {BaseAPI}
 */
class PexQueryApi extends base_1.BaseAPI {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    createPexQuery(configurationId, createPexQueryInput, options) {
        return (0, exports.PexQueryApiFp)(this.configuration)
            .createPexQuery(configurationId, createPexQueryInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    deletePexQueryById(configurationId, queryId, options) {
        return (0, exports.PexQueryApiFp)(this.configuration)
            .deletePexQueryById(configurationId, queryId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    getPexQueryById(configurationId, queryId, options) {
        return (0, exports.PexQueryApiFp)(this.configuration)
            .getPexQueryById(configurationId, queryId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    listPexQueries(configurationId, limit, exclusiveStartKey, options) {
        return (0, exports.PexQueryApiFp)(this.configuration)
            .listPexQueries(configurationId, limit, exclusiveStartKey, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
        return (0, exports.PexQueryApiFp)(this.configuration)
            .updatePexQueryById(configurationId, queryId, updatePexQueryInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
exports.PexQueryApi = PexQueryApi;
