/* tslint:disable */
/* eslint-disable */
/**
 * IotaService
 * Affinidi IotaService Structure
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@affinidi.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction, } from './common';
// @ts-ignore
import { BASE_PATH, BaseAPI, operationServerMap, } from './base';
export const AlreadyExistsErrorNameEnum = {
    AlreadyExistsError: 'AlreadyExistsError',
};
export const AlreadyExistsErrorMessageEnum = {
    AlreadyExistsParam: 'Already exists: ${param}.',
};
export const AlreadyExistsErrorHttpStatusCodeEnum = {
    NUMBER_409: 409,
};
export const ConsentDtoStatusEnum = {
    Given: 'GIVEN',
};
export const InvalidParameterErrorNameEnum = {
    InvalidParameterError: 'InvalidParameterError',
};
export const InvalidParameterErrorMessageEnum = {
    InvalidParameterParam: 'Invalid parameter: ${param}.',
};
export const InvalidParameterErrorHttpStatusCodeEnum = {
    NUMBER_400: 400,
};
export const MessagePublishingErrorNameEnum = {
    MessagePublishingError: 'MessagePublishingError',
};
export const MessagePublishingErrorMessageEnum = {
    NotAbleToPublishMessagesToTopic: 'Not able to publish messages to topic',
};
export const MessagePublishingErrorHttpStatusCodeEnum = {
    NUMBER_500: 500,
};
export const NotFoundErrorNameEnum = {
    NotFoundError: 'NotFoundError',
};
export const NotFoundErrorMessageEnum = {
    NotFoundParam: 'Not found: ${param}.',
};
export const NotFoundErrorHttpStatusCodeEnum = {
    NUMBER_404: 404,
};
export const OperationForbiddenErrorNameEnum = {
    OperationForbiddenError: 'OperationForbiddenError',
};
export const OperationForbiddenErrorMessageEnum = {
    OperationForbiddenParam: 'Operation forbidden: ${param}.',
};
export const OperationForbiddenErrorHttpStatusCodeEnum = {
    NUMBER_403: 403,
};
export const ResourceLimitExceededErrorNameEnum = {
    ResourceLimitExceededError: 'ResourceLimitExceededError',
};
export const ResourceLimitExceededErrorMessageEnum = {
    ResourceLimitExceededParam: 'Resource limit exceeded: ${param}.',
};
export const ResourceLimitExceededErrorHttpStatusCodeEnum = {
    NUMBER_422: 422,
};
export const VPTokenValidationErrorNameEnum = {
    VpTokenValidationError: 'VPTokenValidationError',
};
export const VPTokenValidationErrorMessageEnum = {
    VpTokenValidationEndedWithAnError: 'VP token validation ended with an error',
};
export const VPTokenValidationErrorHttpStatusCodeEnum = {
    NUMBER_400: 400,
};
/**
 * CallbackApi - axios parameter creator
 * @export
 */
export const CallbackApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback: (callbackInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'callbackInput' is not null or undefined
            assertParamExists('iotOIDC4VPCallback', 'callbackInput', callbackInput);
            const localVarPath = `/v1/callback`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(callbackInput, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
/**
 * CallbackApi - functional programming interface
 * @export
 */
export const CallbackApiFp = function (configuration) {
    const localVarAxiosParamCreator = CallbackApiAxiosParamCreator(configuration);
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback(callbackInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.iotOIDC4VPCallback(callbackInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['CallbackApi.iotOIDC4VPCallback']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
/**
 * CallbackApi - factory interface
 * @export
 */
export const CallbackApiFactory = function (configuration, basePath, axios) {
    const localVarFp = CallbackApiFp(configuration);
    return {
        /**
         * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
         * @summary Processes the callback for OIDC4VP flows
         * @param {CallbackInput} callbackInput CallbackRequestInput
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        iotOIDC4VPCallback(callbackInput, options) {
            return localVarFp
                .iotOIDC4VPCallback(callbackInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
/**
 * CallbackApi - object-oriented interface
 * @export
 * @class CallbackApi
 * @extends {BaseAPI}
 */
export class CallbackApi extends BaseAPI {
    /**
     * This endpoint handles callbacks from clients with data from OIDC4VP transactions, including state, presentation submission, and verification tokens. It updates the flow status based on the provided state and communicates the outcome through MQTT, ensuring the transaction\'s completion or notifying of any errors.
     * @summary Processes the callback for OIDC4VP flows
     * @param {CallbackInput} callbackInput CallbackRequestInput
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof CallbackApi
     */
    iotOIDC4VPCallback(callbackInput, options) {
        return CallbackApiFp(this.configuration)
            .iotOIDC4VPCallback(callbackInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
/**
 * ConfigurationsApi - axios parameter creator
 * @export
 */
export const ConfigurationsApiAxiosParamCreator = function (configuration) {
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration: (createIotaConfigurationInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'createIotaConfigurationInput' is not null or undefined
            assertParamExists('createIotaConfiguration', 'createIotaConfigurationInput', createIotaConfigurationInput);
            const localVarPath = `/v1/configurations`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(createIotaConfigurationInput, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById: (configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('deleteIotaConfigurationById', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'DELETE' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById: (configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('getIotaConfigurationById', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData: (projectId, configurationId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'projectId' is not null or undefined
            assertParamExists('getIotaConfigurationMetaData', 'projectId', projectId);
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('getIotaConfigurationMetaData', 'configurationId', configurationId);
            const localVarPath = `/v1/projects/{projectId}/configurations/{configurationId}/metadata`
                .replace(`{${'projectId'}}`, encodeURIComponent(String(projectId)))
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations: (options = {}) => __awaiter(this, void 0, void 0, function* () {
            const localVarPath = `/v1/configurations`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById: (configurationId, updateConfigurationByIdInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('updateIotaConfigurationById', 'configurationId', configurationId);
            // verify required parameter 'updateConfigurationByIdInput' is not null or undefined
            assertParamExists('updateIotaConfigurationById', 'updateConfigurationByIdInput', updateConfigurationByIdInput);
            const localVarPath = `/v1/configurations/{configurationId}`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'PATCH' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(updateConfigurationByIdInput, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
/**
 * ConfigurationsApi - functional programming interface
 * @export
 */
export const ConfigurationsApiFp = function (configuration) {
    const localVarAxiosParamCreator = ConfigurationsApiAxiosParamCreator(configuration);
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration(createIotaConfigurationInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.createIotaConfiguration(createIotaConfigurationInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.createIotaConfiguration']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById(configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.deleteIotaConfigurationById(configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.deleteIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById(configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getIotaConfigurationById(configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.getIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData(projectId, configurationId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getIotaConfigurationMetaData(projectId, configurationId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.getIotaConfigurationMetaData']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations(options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listIotaConfigurations(options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.listIotaConfigurations']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['ConfigurationsApi.updateIotaConfigurationById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
/**
 * ConfigurationsApi - factory interface
 * @export
 */
export const ConfigurationsApiFactory = function (configuration, basePath, axios) {
    const localVarFp = ConfigurationsApiFp(configuration);
    return {
        /**
         *
         * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createIotaConfiguration(createIotaConfigurationInput, options) {
            return localVarFp
                .createIotaConfiguration(createIotaConfigurationInput, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteIotaConfigurationById(configurationId, options) {
            return localVarFp
                .deleteIotaConfigurationById(configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationById(configurationId, options) {
            return localVarFp
                .getIotaConfigurationById(configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} projectId project Id
         * @param {string} configurationId iotaConfiguration Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getIotaConfigurationMetaData(projectId, configurationId, options) {
            return localVarFp
                .getIotaConfigurationMetaData(projectId, configurationId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listIotaConfigurations(options) {
            return localVarFp
                .listIotaConfigurations(options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
            return localVarFp
                .updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
/**
 * ConfigurationsApi - object-oriented interface
 * @export
 * @class ConfigurationsApi
 * @extends {BaseAPI}
 */
export class ConfigurationsApi extends BaseAPI {
    /**
     *
     * @param {CreateIotaConfigurationInput} createIotaConfigurationInput CreateConfiguration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    createIotaConfiguration(createIotaConfigurationInput, options) {
        return ConfigurationsApiFp(this.configuration)
            .createIotaConfiguration(createIotaConfigurationInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    deleteIotaConfigurationById(configurationId, options) {
        return ConfigurationsApiFp(this.configuration)
            .deleteIotaConfigurationById(configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationById(configurationId, options) {
        return ConfigurationsApiFp(this.configuration)
            .getIotaConfigurationById(configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} projectId project Id
     * @param {string} configurationId iotaConfiguration Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    getIotaConfigurationMetaData(projectId, configurationId, options) {
        return ConfigurationsApiFp(this.configuration)
            .getIotaConfigurationMetaData(projectId, configurationId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    listIotaConfigurations(options) {
        return ConfigurationsApiFp(this.configuration)
            .listIotaConfigurations(options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {UpdateConfigurationByIdInput} updateConfigurationByIdInput UpdateConfigurationById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ConfigurationsApi
     */
    updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options) {
        return ConfigurationsApiFp(this.configuration)
            .updateIotaConfigurationById(configurationId, updateConfigurationByIdInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
/**
 * DefaultApi - axios parameter creator
 * @export
 */
export const DefaultApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents: (userId, limit, exclusiveStartKey, options = {}) => __awaiter(this, void 0, void 0, function* () {
            const localVarPath = `/v1/logged-consents`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            if (userId !== undefined) {
                localVarQueryParameter['userId'] = userId;
            }
            if (limit !== undefined) {
                localVarQueryParameter['limit'] = limit;
            }
            if (exclusiveStartKey !== undefined) {
                localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey;
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
/**
 * DefaultApi - functional programming interface
 * @export
 */
export const DefaultApiFp = function (configuration) {
    const localVarAxiosParamCreator = DefaultApiAxiosParamCreator(configuration);
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents(userId, limit, exclusiveStartKey, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listLoggedConsents(userId, limit, exclusiveStartKey, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['DefaultApi.listLoggedConsents']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
/**
 * DefaultApi - factory interface
 * @export
 */
export const DefaultApiFactory = function (configuration, basePath, axios) {
    const localVarFp = DefaultApiFp(configuration);
    return {
        /**
         * returns a list of logged consents for the project
         * @param {string} [userId]
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listLoggedConsents(userId, limit, exclusiveStartKey, options) {
            return localVarFp
                .listLoggedConsents(userId, limit, exclusiveStartKey, options)
                .then((request) => request(axios, basePath));
        },
    };
};
/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export class DefaultApi extends BaseAPI {
    /**
     * returns a list of logged consents for the project
     * @param {string} [userId]
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApi
     */
    listLoggedConsents(userId, limit, exclusiveStartKey, options) {
        return DefaultApiFp(this.configuration)
            .listLoggedConsents(userId, limit, exclusiveStartKey, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
/**
 * IotaApi - axios parameter creator
 * @export
 */
export const IotaApiAxiosParamCreator = function (configuration) {
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials: (awsExchangeCredentials, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'awsExchangeCredentials' is not null or undefined
            assertParamExists('awsExchangeCredentials', 'awsExchangeCredentials', awsExchangeCredentials);
            const localVarPath = `/v1/aws-exchange-credentials`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(awsExchangeCredentials, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
/**
 * IotaApi - functional programming interface
 * @export
 */
export const IotaApiFp = function (configuration) {
    const localVarAxiosParamCreator = IotaApiAxiosParamCreator(configuration);
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials(awsExchangeCredentials, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.awsExchangeCredentials(awsExchangeCredentials, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['IotaApi.awsExchangeCredentials']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
/**
 * IotaApi - factory interface
 * @export
 */
export const IotaApiFactory = function (configuration, basePath, axios) {
    const localVarFp = IotaApiFp(configuration);
    return {
        /**
         * It exchanges limited token into cognito
         * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        awsExchangeCredentials(awsExchangeCredentials, options) {
            return localVarFp
                .awsExchangeCredentials(awsExchangeCredentials, options)
                .then((request) => request(axios, basePath));
        },
    };
};
/**
 * IotaApi - object-oriented interface
 * @export
 * @class IotaApi
 * @extends {BaseAPI}
 */
export class IotaApi extends BaseAPI {
    /**
     * It exchanges limited token into cognito
     * @param {AwsExchangeCredentials} awsExchangeCredentials AwsExchangeCredentials
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof IotaApi
     */
    awsExchangeCredentials(awsExchangeCredentials, options) {
        return IotaApiFp(this.configuration)
            .awsExchangeCredentials(awsExchangeCredentials, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
/**
 * PexQueryApi - axios parameter creator
 * @export
 */
export const PexQueryApiAxiosParamCreator = function (configuration) {
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery: (configurationId, createPexQueryInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('createPexQuery', 'configurationId', configurationId);
            // verify required parameter 'createPexQueryInput' is not null or undefined
            assertParamExists('createPexQuery', 'createPexQueryInput', createPexQueryInput);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'POST' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(createPexQueryInput, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById: (configurationId, queryId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('deletePexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            assertParamExists('deletePexQueryById', 'queryId', queryId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'DELETE' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById: (configurationId, queryId, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('getPexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            assertParamExists('getPexQueryById', 'queryId', queryId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries: (configurationId, limit, exclusiveStartKey, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('listPexQueries', 'configurationId', configurationId);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries`.replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'GET' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            if (limit !== undefined) {
                localVarQueryParameter['limit'] = limit;
            }
            if (exclusiveStartKey !== undefined) {
                localVarQueryParameter['exclusiveStartKey'] = exclusiveStartKey;
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById: (configurationId, queryId, updatePexQueryInput, options = {}) => __awaiter(this, void 0, void 0, function* () {
            // verify required parameter 'configurationId' is not null or undefined
            assertParamExists('updatePexQueryById', 'configurationId', configurationId);
            // verify required parameter 'queryId' is not null or undefined
            assertParamExists('updatePexQueryById', 'queryId', queryId);
            // verify required parameter 'updatePexQueryInput' is not null or undefined
            assertParamExists('updatePexQueryById', 'updatePexQueryInput', updatePexQueryInput);
            const localVarPath = `/v1/configurations/{configurationId}/pex-queries/{queryId}`
                .replace(`{${'configurationId'}}`, encodeURIComponent(String(configurationId)))
                .replace(`{${'queryId'}}`, encodeURIComponent(String(queryId)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }
            const localVarRequestOptions = Object.assign(Object.assign({ method: 'PATCH' }, baseOptions), options);
            const localVarHeaderParameter = {};
            const localVarQueryParameter = {};
            // authentication ProjectTokenAuth required
            yield setApiKeyToObject(localVarHeaderParameter, 'authorization', configuration);
            localVarHeaderParameter['Content-Type'] = 'application/json';
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = Object.assign(Object.assign(Object.assign({}, localVarHeaderParameter), headersFromBaseOptions), options.headers);
            localVarRequestOptions.data = serializeDataIfNeeded(updatePexQueryInput, localVarRequestOptions, configuration);
            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        }),
    };
};
/**
 * PexQueryApi - functional programming interface
 * @export
 */
export const PexQueryApiFp = function (configuration) {
    const localVarAxiosParamCreator = PexQueryApiAxiosParamCreator(configuration);
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery(configurationId, createPexQueryInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.createPexQuery(configurationId, createPexQueryInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['PexQueryApi.createPexQuery']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById(configurationId, queryId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.deletePexQueryById(configurationId, queryId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['PexQueryApi.deletePexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById(configurationId, queryId, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.getPexQueryById(configurationId, queryId, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['PexQueryApi.getPexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries(configurationId, limit, exclusiveStartKey, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.listPexQueries(configurationId, limit, exclusiveStartKey, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['PexQueryApi.listPexQueries']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
            var _a, _b, _c;
            return __awaiter(this, void 0, void 0, function* () {
                const localVarAxiosArgs = yield localVarAxiosParamCreator.updatePexQueryById(configurationId, queryId, updatePexQueryInput, options);
                const index = (_a = configuration === null || configuration === void 0 ? void 0 : configuration.serverIndex) !== null && _a !== void 0 ? _a : 0;
                const operationBasePath = (_c = (_b = operationServerMap['PexQueryApi.updatePexQueryById']) === null || _b === void 0 ? void 0 : _b[index]) === null || _c === void 0 ? void 0 : _c.url;
                return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, operationBasePath || basePath);
            });
        },
    };
};
/**
 * PexQueryApi - factory interface
 * @export
 */
export const PexQueryApiFactory = function (configuration, basePath, axios) {
    const localVarFp = PexQueryApiFp(configuration);
    return {
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createPexQuery(configurationId, createPexQueryInput, options) {
            return localVarFp
                .createPexQuery(configurationId, createPexQueryInput, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePexQueryById(configurationId, queryId, options) {
            return localVarFp
                .deletePexQueryById(configurationId, queryId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getPexQueryById(configurationId, queryId, options) {
            return localVarFp
                .getPexQueryById(configurationId, queryId, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {number} [limit] Maximum number of records to fetch in a list
         * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        listPexQueries(configurationId, limit, exclusiveStartKey, options) {
            return localVarFp
                .listPexQueries(configurationId, limit, exclusiveStartKey, options)
                .then((request) => request(axios, basePath));
        },
        /**
         *
         * @param {string} configurationId iotaConfiguration Id
         * @param {string} queryId pex-query Id
         * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
            return localVarFp
                .updatePexQueryById(configurationId, queryId, updatePexQueryInput, options)
                .then((request) => request(axios, basePath));
        },
    };
};
/**
 * PexQueryApi - object-oriented interface
 * @export
 * @class PexQueryApi
 * @extends {BaseAPI}
 */
export class PexQueryApi extends BaseAPI {
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {CreatePexQueryInput} createPexQueryInput CreatePexQuery
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    createPexQuery(configurationId, createPexQueryInput, options) {
        return PexQueryApiFp(this.configuration)
            .createPexQuery(configurationId, createPexQueryInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    deletePexQueryById(configurationId, queryId, options) {
        return PexQueryApiFp(this.configuration)
            .deletePexQueryById(configurationId, queryId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    getPexQueryById(configurationId, queryId, options) {
        return PexQueryApiFp(this.configuration)
            .getPexQueryById(configurationId, queryId, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {number} [limit] Maximum number of records to fetch in a list
     * @param {string} [exclusiveStartKey] The base64url encoded key of the first item that this operation will evaluate (it is not returned). Use the value that was returned in the previous operation.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    listPexQueries(configurationId, limit, exclusiveStartKey, options) {
        return PexQueryApiFp(this.configuration)
            .listPexQueries(configurationId, limit, exclusiveStartKey, options)
            .then((request) => request(this.axios, this.basePath));
    }
    /**
     *
     * @param {string} configurationId iotaConfiguration Id
     * @param {string} queryId pex-query Id
     * @param {UpdatePexQueryInput} updatePexQueryInput UpdatePexQueryById
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof PexQueryApi
     */
    updatePexQueryById(configurationId, queryId, updatePexQueryInput, options) {
        return PexQueryApiFp(this.configuration)
            .updatePexQueryById(configurationId, queryId, updatePexQueryInput, options)
            .then((request) => request(this.axios, this.basePath));
    }
}
