from typing import Any, NamedTuple, Optional

from dagster.core.definitions.events import AssetKey


class ForeignAsset(NamedTuple):
    """A ForeignAsset represents an asset that is not generated by any Dagster op in the repository
    that it's referenced from."""

    key: AssetKey
    metadata: Optional[Any] = None
    io_manager_key: str = "io_manager"
