import { Construct } from "constructs";
/**
 * Represents a WAF V2 managed rule.
 */
export interface ManagedRule {
    /**
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify the rule group.
     */
    readonly vendor: string;
    /**
     * The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
     */
    readonly name: string;
}
/**
 * Properties to configure the web acl.
 */
export interface CloudFrontWebAclProps {
    /**
     * List of managed rules to apply to the web acl.
     */
    readonly managedRules: ManagedRule[];
}
/**
 * This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the
 * region of the parent cdk stack.
 */
export declare class CloudfrontWebAcl extends Construct {
    readonly webAclId: string;
    readonly webAclArn: string;
    readonly name: string;
    readonly region: string;
    constructor(scope: Construct, id: string, props: CloudFrontWebAclProps);
}
//# sourceMappingURL=cloudfront-web-acl.d.ts.map