"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontWebAcl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const ACL_REGION = "us-east-1";
const SCOPE = "CLOUDFRONT";
/**
 * This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the
 * region of the parent cdk stack.
 */
class CloudfrontWebAcl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.region = ACL_REGION;
        this.name = `${id.substring(0, 40)}_${aws_cdk_lib_1.Names.uniqueId(this)}`;
        // The parameters for creating the Web ACL
        const createWebACLRequest = {
            Name: this.name,
            DefaultAction: { Allow: {} },
            Scope: SCOPE,
            VisibilityConfig: {
                CloudWatchMetricsEnabled: true,
                MetricName: id,
                SampledRequestsEnabled: true,
            },
            Rules: props.managedRules
                .map((r) => ({ VendorName: r.vendor, Name: r.name }))
                .map((rule, Priority) => ({
                Name: `${rule.VendorName}-${rule.Name}`,
                Priority,
                Statement: { ManagedRuleGroupStatement: rule },
                OverrideAction: { None: {} },
                VisibilityConfig: {
                    MetricName: `${rule.VendorName}-${rule.Name}`,
                    CloudWatchMetricsEnabled: true,
                    SampledRequestsEnabled: true,
                },
            })),
        };
        // Create the Web ACL
        const createCustomResource = new custom_resources_1.AwsCustomResource(this, `Create`, {
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
            onCreate: {
                service: "WAFV2",
                action: "createWebACL",
                parameters: createWebACLRequest,
                region: this.region,
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse("Summary.Id"),
            },
        });
        this.webAclId = createCustomResource.getResponseField("Summary.Id");
        const getWebACLRequest = {
            Name: this.name,
            Scope: SCOPE,
            Id: this.webAclId,
        };
        // A second custom resource is used for managing the deletion of this construct, since both an Id and LockToken
        // are required for Web ACL Deletion
        new custom_resources_1.AwsCustomResource(this, `Delete`, {
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
            onCreate: {
                service: "WAFV2",
                action: "getWebACL",
                parameters: getWebACLRequest,
                region: this.region,
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse("LockToken"),
            },
            onDelete: {
                service: "WAFV2",
                action: "deleteWebACL",
                parameters: {
                    Name: this.name,
                    Scope: SCOPE,
                    Id: this.webAclId,
                    LockToken: new custom_resources_1.PhysicalResourceIdReference(),
                },
                region: this.region,
            },
        });
        this.webAclArn = `arn:aws:wafv2:${this.region}:${aws_cdk_lib_1.Stack.of(this).account}:global/webacl/${this.name}/${this.webAclId}`;
    }
}
exports.CloudfrontWebAcl = CloudfrontWebAcl;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontWebAcl[_a] = { fqn: "@aws-prototyping-sdk/static-website.CloudfrontWebAcl", version: "0.0.73" };
//# sourceMappingURL=data:application/json;base64,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