"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
 * (experimental) A new IVS Playback Key Pair.
 *
 * @experimental
 */
class PlaybackKeyPair extends PlaybackKeyPairBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {});
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs.PlaybackKeyPair", version: "1.104.0" };
//# sourceMappingURL=data:application/json;base64,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