# tcex - ThreatConnect Exchange App Framework

The ThreatConnect&trade; TcEx App Framework provides functionality for writing ThreatConnect Exchange Apps.

## Requirements

 * colorama (https://pypi.python.org/pypi/colorama)
 * future (https://pypi.org/project/future/)
 * hvac (https://pypi.python.org/pypi/hvac)
 * inflect (https://pypi.python.org/pypi/inflect)
 * jsonschema (https://pypi.python.org/pypi/jsonschema)
 * paho-mqtt (https://pypi.org/project/paho-mqtt/)
 * parsedatetime (https://pypi.python.org/pypi/parsedatetime)
 * python-dateutil (https://pypi.python.org/pypi/python-dateutil)
 * pytz (https://pypi.python.org/pypi/pytz)
 * redis (https://pypi.python.org/pypi/redis)
 * requests (http://docs.python-requests.org/en/latest)
 * six (https://pypi.python.org/pypi/six)
 * stdlib-list (https://pypi.org/project/stdlib-list/)
 * tzlocal (https://pypi.python.org/pypi/tzlocal)
 * wrapt (https://pypi.org/project/wrapt/)

### Development Requirements

 * black (https://pypi.org/project/black/)
 * CommonMark (https://pypi.org/project/commonmark/)
 * deepdiff (https://pypi.org/project/deepdiff/)
 * flake8 (https://pypi.org/project/flake8/)
 * jmespath (https://pypi.org/project/jmespath/)
 * mako (https://pypi.org/project/mako/)
 * pre-commit (https://pypi.org/project/pre-commit/)
 * pydocstyle (https://pypi.org/project/pydocstyle/)
 * pylint (https://pypi.org/project/pylint/)
 * pytest (https://pypi.org/project/pytest/)
 * pytest-cov (https://pypi.org/project/pytest-cov/)
 * pytest-html (https://pypi.org/project/pytest-html/)
 * pytest-xdist (https://pypi.org/project/pytest-xdist/)
 * recommonmark (https://pypi.org/project/recommonmark/)
 * reno (https://pypi.org/project/reno/)
 * sphinx (https://pypi.org/project/Sphinx/)
 * sphinx-rtd-theme (https://pypi.org/project/sphinx-rtd-theme/)

## Installation

**Using pip**

```
pip install tcex
pip install tcex[development]
```

**Manually**

```
cd tcex
python setup.py install --force
```

## Documentation

https://docs.threatconnect.com/en/latest/tcex/tcex.html

## Release Notes

https://docs.threatconnect.com/en/latest/tcex/release_notes.html

## Contact

If you have any questions, bugs, or requests please contact support@threatconnect.com
