"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketPrivacy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class BucketPrivacy {
    visit(node) {
        if (node instanceof aws_cdk_lib_1.aws_s3.CfnBucket) {
            const bucket = node;
            bucket.bucketEncryption = {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            kmsMasterKeyId: undefined,
                            sseAlgorithm: "AES256",
                        },
                    },
                ],
            };
            bucket.publicAccessBlockConfiguration = {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            };
        }
        if (node instanceof aws_cdk_lib_1.aws_s3.CfnBucketPolicy) {
            const bucketPolicy = node;
            console.log(bucketPolicy.policyDocument);
        }
    }
}
exports.BucketPrivacy = BucketPrivacy;
_a = JSII_RTTI_SYMBOL_1;
BucketPrivacy[_a] = { fqn: "@pepperize/cdk-private-bucket.BucketPrivacy", version: "0.0.335" };
//# sourceMappingURL=data:application/json;base64,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