# mypy-boto3-comprehend

[![PyPI - mypy-boto3-comprehend](https://img.shields.io/pypi/v/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-comprehend.svg?color=blue)](https://pypi.org/project/mypy-boto3-comprehend)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Comprehend 1.16.36](https://boto3.amazonaws.com/v1/documentation/api/1.16.36/reference/services/comprehend.html#Comprehend) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-comprehend](#mypy-boto3-comprehend)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Comprehend` service.

```bash
python -m pip install boto3-stubs[comprehend]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[comprehend]` in your environment: `python -m pip install 'boto3-stubs[comprehend]'`

Both type checking and auto-complete should work for `Comprehend` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[comprehend]` in your environment: `python -m pip install 'boto3-stubs[comprehend]'`

Both type checking and auto-complete should work for `Comprehend` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[comprehend]` in your environment: `python -m pip install 'boto3-stubs[comprehend]'`
- Run `mypy` as usual

Type checking should work for `Comprehend` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[comprehend]` in your environment: `python -m pip install 'boto3-stubs[comprehend]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Comprehend` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ComprehendClient` provides annotations for `boto3.client("comprehend")`.

```python
import boto3

from mypy_boto3_comprehend import ComprehendClient

client: ComprehendClient = boto3.client("comprehend")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ComprehendClient = session.client("comprehend")
```

### Paginators annotations

`mypy_boto3_comprehend.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_comprehend import ComprehendClient
from mypy_boto3_comprehend.paginator import (
    ListDocumentClassificationJobsPaginator,
    ListDocumentClassifiersPaginator,
    ListDominantLanguageDetectionJobsPaginator,
    ListEntitiesDetectionJobsPaginator,
    ListEntityRecognizersPaginator,
    ListKeyPhrasesDetectionJobsPaginator,
    ListSentimentDetectionJobsPaginator,
    ListTopicsDetectionJobsPaginator,
)

client: ComprehendClient = boto3.client("comprehend")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_document_classification_jobs_paginator: ListDocumentClassificationJobsPaginator = client.get_paginator("list_document_classification_jobs")
list_document_classifiers_paginator: ListDocumentClassifiersPaginator = client.get_paginator("list_document_classifiers")
list_dominant_language_detection_jobs_paginator: ListDominantLanguageDetectionJobsPaginator = client.get_paginator("list_dominant_language_detection_jobs")
list_entities_detection_jobs_paginator: ListEntitiesDetectionJobsPaginator = client.get_paginator("list_entities_detection_jobs")
list_entity_recognizers_paginator: ListEntityRecognizersPaginator = client.get_paginator("list_entity_recognizers")
list_key_phrases_detection_jobs_paginator: ListKeyPhrasesDetectionJobsPaginator = client.get_paginator("list_key_phrases_detection_jobs")
list_sentiment_detection_jobs_paginator: ListSentimentDetectionJobsPaginator = client.get_paginator("list_sentiment_detection_jobs")
list_topics_detection_jobs_paginator: ListTopicsDetectionJobsPaginator = client.get_paginator("list_topics_detection_jobs")
```







### Typed dictionations

`mypy_boto3_comprehend.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_comprehend.type_defs import (
    AugmentedManifestsListItemTypeDef,
    BatchDetectDominantLanguageItemResultTypeDef,
    BatchDetectDominantLanguageResponseTypeDef,
    BatchDetectEntitiesItemResultTypeDef,
    BatchDetectEntitiesResponseTypeDef,
    BatchDetectKeyPhrasesItemResultTypeDef,
    BatchDetectKeyPhrasesResponseTypeDef,
    BatchDetectSentimentItemResultTypeDef,
    BatchDetectSentimentResponseTypeDef,
    BatchDetectSyntaxItemResultTypeDef,
    BatchDetectSyntaxResponseTypeDef,
    BatchItemErrorTypeDef,
    ClassifierEvaluationMetricsTypeDef,
    ClassifierMetadataTypeDef,
    ClassifyDocumentResponseTypeDef,
    CreateDocumentClassifierResponseTypeDef,
    CreateEndpointResponseTypeDef,
    CreateEntityRecognizerResponseTypeDef,
    DescribeDocumentClassificationJobResponseTypeDef,
    DescribeDocumentClassifierResponseTypeDef,
    DescribeDominantLanguageDetectionJobResponseTypeDef,
    DescribeEndpointResponseTypeDef,
    DescribeEntitiesDetectionJobResponseTypeDef,
    DescribeEntityRecognizerResponseTypeDef,
    DescribeEventsDetectionJobResponseTypeDef,
    DescribeKeyPhrasesDetectionJobResponseTypeDef,
    DescribePiiEntitiesDetectionJobResponseTypeDef,
    DescribeSentimentDetectionJobResponseTypeDef,
    DescribeTopicsDetectionJobResponseTypeDef,
    DetectDominantLanguageResponseTypeDef,
    DetectEntitiesResponseTypeDef,
    DetectKeyPhrasesResponseTypeDef,
    DetectPiiEntitiesResponseTypeDef,
    DetectSentimentResponseTypeDef,
    DetectSyntaxResponseTypeDef,
    DocumentClassificationJobFilterTypeDef,
    DocumentClassificationJobPropertiesTypeDef,
    DocumentClassifierFilterTypeDef,
    DocumentClassifierInputDataConfigTypeDef,
    DocumentClassifierOutputDataConfigTypeDef,
    DocumentClassifierPropertiesTypeDef,
    DocumentClassTypeDef,
    DocumentLabelTypeDef,
    DominantLanguageDetectionJobFilterTypeDef,
    DominantLanguageDetectionJobPropertiesTypeDef,
    DominantLanguageTypeDef,
    EndpointFilterTypeDef,
    EndpointPropertiesTypeDef,
    EntitiesDetectionJobFilterTypeDef,
    EntitiesDetectionJobPropertiesTypeDef,
    EntityRecognizerAnnotationsTypeDef,
    EntityRecognizerDocumentsTypeDef,
    EntityRecognizerEntityListTypeDef,
    EntityRecognizerEvaluationMetricsTypeDef,
    EntityRecognizerFilterTypeDef,
    EntityRecognizerInputDataConfigTypeDef,
    EntityRecognizerMetadataEntityTypesListItemTypeDef,
    EntityRecognizerMetadataTypeDef,
    EntityRecognizerPropertiesTypeDef,
    EntityTypeDef,
    EntityTypesEvaluationMetricsTypeDef,
    EntityTypesListItemTypeDef,
    EventsDetectionJobFilterTypeDef,
    EventsDetectionJobPropertiesTypeDef,
    InputDataConfigTypeDef,
    KeyPhrasesDetectionJobFilterTypeDef,
    KeyPhrasesDetectionJobPropertiesTypeDef,
    KeyPhraseTypeDef,
    ListDocumentClassificationJobsResponseTypeDef,
    ListDocumentClassifiersResponseTypeDef,
    ListDominantLanguageDetectionJobsResponseTypeDef,
    ListEndpointsResponseTypeDef,
    ListEntitiesDetectionJobsResponseTypeDef,
    ListEntityRecognizersResponseTypeDef,
    ListEventsDetectionJobsResponseTypeDef,
    ListKeyPhrasesDetectionJobsResponseTypeDef,
    ListPiiEntitiesDetectionJobsResponseTypeDef,
    ListSentimentDetectionJobsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTopicsDetectionJobsResponseTypeDef,
    OutputDataConfigTypeDef,
    PaginatorConfigTypeDef,
    PartOfSpeechTagTypeDef,
    PiiEntitiesDetectionJobFilterTypeDef,
    PiiEntitiesDetectionJobPropertiesTypeDef,
    PiiEntityTypeDef,
    PiiOutputDataConfigTypeDef,
    RedactionConfigTypeDef,
    SentimentDetectionJobFilterTypeDef,
    SentimentDetectionJobPropertiesTypeDef,
    SentimentScoreTypeDef,
    StartDocumentClassificationJobResponseTypeDef,
    StartDominantLanguageDetectionJobResponseTypeDef,
    StartEntitiesDetectionJobResponseTypeDef,
    StartEventsDetectionJobResponseTypeDef,
    StartKeyPhrasesDetectionJobResponseTypeDef,
    StartPiiEntitiesDetectionJobResponseTypeDef,
    StartSentimentDetectionJobResponseTypeDef,
    StartTopicsDetectionJobResponseTypeDef,
    StopDominantLanguageDetectionJobResponseTypeDef,
    StopEntitiesDetectionJobResponseTypeDef,
    StopEventsDetectionJobResponseTypeDef,
    StopKeyPhrasesDetectionJobResponseTypeDef,
    StopPiiEntitiesDetectionJobResponseTypeDef,
    StopSentimentDetectionJobResponseTypeDef,
    SyntaxTokenTypeDef,
    TagTypeDef,
    TopicsDetectionJobFilterTypeDef,
    TopicsDetectionJobPropertiesTypeDef,
    VpcConfigTypeDef,
)

def get_structure() -> AugmentedManifestsListItemTypeDef:
    return {
      ...
    }
```
