import os
from unittest import TestCase

from musicscore.musicstream.streamvoice import SimpleFormat
from musicscore.musictree.treechordflags3 import NoiseFlag3
from musicscore.musictree.treescoretimewise import TreeScoreTimewise
from tests.score_templates.xml_test_score import TestScore

path = os.path.abspath(__file__).split('.')[0]


class Test(TestCase):
    def setUp(self) -> None:
        self.score = TreeScoreTimewise()

    def test_1(self):
        xml_path = path + '_test_1.xml'
        durations = [0.25, 0.75, 0.5, 0.5, 1, 1.25, 1.5, 2, 2.5, 3, 3.5, 4, 4.5]
        sf = SimpleFormat(durations=durations)
        for chord in sf.chords:
            chord.add_flag(NoiseFlag3())

        sf.to_stream_voice().add_to_score(self.score)
        self.score.write(xml_path)
        # TestScore().assert_template(xml_path)
