# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class DomainMapping(pulumi.CustomResource):
    domain_name: pulumi.Output[str]
    name: pulumi.Output[str]
    override_strategy: pulumi.Output[str]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    resource_records: pulumi.Output[list]
    ssl_settings: pulumi.Output[dict]
    def __init__(__self__, resource_name, opts=None, domain_name=None, override_strategy=None, project=None, ssl_settings=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a DomainMapping resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **ssl_settings** object supports the following:
        
          * `certificateId` (`pulumi.Input[str]`)
          * `pendingManagedCertificateId` (`pulumi.Input[str]`)
          * `sslManagementType` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/app_engine_domain_mapping.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if domain_name is None:
                raise TypeError("Missing required property 'domain_name'")
            __props__['domain_name'] = domain_name
            __props__['override_strategy'] = override_strategy
            __props__['project'] = project
            __props__['ssl_settings'] = ssl_settings
            __props__['name'] = None
            __props__['resource_records'] = None
        super(DomainMapping, __self__).__init__(
            'gcp:appengine/domainMapping:DomainMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, domain_name=None, name=None, override_strategy=None, project=None, resource_records=None, ssl_settings=None):
        """
        Get an existing DomainMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **resource_records** object supports the following:
        
          * `name` (`pulumi.Input[str]`)
          * `rrdata` (`pulumi.Input[str]`)
          * `type` (`pulumi.Input[str]`)
        
        The **ssl_settings** object supports the following:
        
          * `certificateId` (`pulumi.Input[str]`)
          * `pendingManagedCertificateId` (`pulumi.Input[str]`)
          * `sslManagementType` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/app_engine_domain_mapping.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["domain_name"] = domain_name
        __props__["name"] = name
        __props__["override_strategy"] = override_strategy
        __props__["project"] = project
        __props__["resource_records"] = resource_records
        __props__["ssl_settings"] = ssl_settings
        return DomainMapping(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

