# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Disk(pulumi.CustomResource):
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    disk_encryption_key: pulumi.Output[dict]
    image: pulumi.Output[str]
    label_fingerprint: pulumi.Output[str]
    labels: pulumi.Output[dict]
    last_attach_timestamp: pulumi.Output[str]
    last_detach_timestamp: pulumi.Output[str]
    name: pulumi.Output[str]
    physical_block_size_bytes: pulumi.Output[float]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    resource_policies: pulumi.Output[list]
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    size: pulumi.Output[float]
    snapshot: pulumi.Output[str]
    source_image_encryption_key: pulumi.Output[dict]
    source_image_id: pulumi.Output[str]
    source_snapshot_encryption_key: pulumi.Output[dict]
    source_snapshot_id: pulumi.Output[str]
    type: pulumi.Output[str]
    users: pulumi.Output[list]
    zone: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, disk_encryption_key=None, image=None, labels=None, name=None, physical_block_size_bytes=None, project=None, resource_policies=None, size=None, snapshot=None, source_image_encryption_key=None, source_snapshot_encryption_key=None, type=None, zone=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Disk resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **disk_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)
        
        The **source_image_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)
        
        The **source_snapshot_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_disk.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['disk_encryption_key'] = disk_encryption_key
            __props__['image'] = image
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['physical_block_size_bytes'] = physical_block_size_bytes
            __props__['project'] = project
            __props__['resource_policies'] = resource_policies
            __props__['size'] = size
            __props__['snapshot'] = snapshot
            __props__['source_image_encryption_key'] = source_image_encryption_key
            __props__['source_snapshot_encryption_key'] = source_snapshot_encryption_key
            __props__['type'] = type
            __props__['zone'] = zone
            __props__['creation_timestamp'] = None
            __props__['label_fingerprint'] = None
            __props__['last_attach_timestamp'] = None
            __props__['last_detach_timestamp'] = None
            __props__['self_link'] = None
            __props__['source_image_id'] = None
            __props__['source_snapshot_id'] = None
            __props__['users'] = None
        super(Disk, __self__).__init__(
            'gcp:compute/disk:Disk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, creation_timestamp=None, description=None, disk_encryption_key=None, image=None, label_fingerprint=None, labels=None, last_attach_timestamp=None, last_detach_timestamp=None, name=None, physical_block_size_bytes=None, project=None, resource_policies=None, self_link=None, size=None, snapshot=None, source_image_encryption_key=None, source_image_id=None, source_snapshot_encryption_key=None, source_snapshot_id=None, type=None, users=None, zone=None):
        """
        Get an existing Disk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        
        The **disk_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)
        
        The **source_image_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)
        
        The **source_snapshot_encryption_key** object supports the following:
        
          * `kmsKeySelfLink` (`pulumi.Input[str]`)
          * `rawKey` (`pulumi.Input[str]`)
          * `sha256` (`pulumi.Input[str]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_disk.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["creation_timestamp"] = creation_timestamp
        __props__["description"] = description
        __props__["disk_encryption_key"] = disk_encryption_key
        __props__["image"] = image
        __props__["label_fingerprint"] = label_fingerprint
        __props__["labels"] = labels
        __props__["last_attach_timestamp"] = last_attach_timestamp
        __props__["last_detach_timestamp"] = last_detach_timestamp
        __props__["name"] = name
        __props__["physical_block_size_bytes"] = physical_block_size_bytes
        __props__["project"] = project
        __props__["resource_policies"] = resource_policies
        __props__["self_link"] = self_link
        __props__["size"] = size
        __props__["snapshot"] = snapshot
        __props__["source_image_encryption_key"] = source_image_encryption_key
        __props__["source_image_id"] = source_image_id
        __props__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
        __props__["source_snapshot_id"] = source_snapshot_id
        __props__["type"] = type
        __props__["users"] = users
        __props__["zone"] = zone
        return Disk(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

