# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class RouterNat(pulumi.CustomResource):
    drain_nat_ips: pulumi.Output[list]
    icmp_idle_timeout_sec: pulumi.Output[float]
    log_config: pulumi.Output[dict]
    min_ports_per_vm: pulumi.Output[float]
    name: pulumi.Output[str]
    nat_ip_allocate_option: pulumi.Output[str]
    nat_ips: pulumi.Output[list]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    router: pulumi.Output[str]
    source_subnetwork_ip_ranges_to_nat: pulumi.Output[str]
    subnetworks: pulumi.Output[list]
    tcp_established_idle_timeout_sec: pulumi.Output[float]
    tcp_transitory_idle_timeout_sec: pulumi.Output[float]
    udp_idle_timeout_sec: pulumi.Output[float]
    def __init__(__self__, resource_name, opts=None, drain_nat_ips=None, icmp_idle_timeout_sec=None, log_config=None, min_ports_per_vm=None, name=None, nat_ip_allocate_option=None, nat_ips=None, project=None, region=None, router=None, source_subnetwork_ip_ranges_to_nat=None, subnetworks=None, tcp_established_idle_timeout_sec=None, tcp_transitory_idle_timeout_sec=None, udp_idle_timeout_sec=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a RouterNat resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **log_config** object supports the following:
        
          * `enable` (`pulumi.Input[bool]`)
          * `filter` (`pulumi.Input[str]`)
        
        The **subnetworks** object supports the following:
        
          * `name` (`pulumi.Input[str]`)
          * `secondaryIpRangeNames` (`pulumi.Input[list]`)
          * `sourceIpRangesToNats` (`pulumi.Input[list]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_router_nat.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['drain_nat_ips'] = drain_nat_ips
            __props__['icmp_idle_timeout_sec'] = icmp_idle_timeout_sec
            __props__['log_config'] = log_config
            __props__['min_ports_per_vm'] = min_ports_per_vm
            __props__['name'] = name
            if nat_ip_allocate_option is None:
                raise TypeError("Missing required property 'nat_ip_allocate_option'")
            __props__['nat_ip_allocate_option'] = nat_ip_allocate_option
            __props__['nat_ips'] = nat_ips
            __props__['project'] = project
            __props__['region'] = region
            if router is None:
                raise TypeError("Missing required property 'router'")
            __props__['router'] = router
            if source_subnetwork_ip_ranges_to_nat is None:
                raise TypeError("Missing required property 'source_subnetwork_ip_ranges_to_nat'")
            __props__['source_subnetwork_ip_ranges_to_nat'] = source_subnetwork_ip_ranges_to_nat
            __props__['subnetworks'] = subnetworks
            __props__['tcp_established_idle_timeout_sec'] = tcp_established_idle_timeout_sec
            __props__['tcp_transitory_idle_timeout_sec'] = tcp_transitory_idle_timeout_sec
            __props__['udp_idle_timeout_sec'] = udp_idle_timeout_sec
        super(RouterNat, __self__).__init__(
            'gcp:compute/routerNat:RouterNat',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, drain_nat_ips=None, icmp_idle_timeout_sec=None, log_config=None, min_ports_per_vm=None, name=None, nat_ip_allocate_option=None, nat_ips=None, project=None, region=None, router=None, source_subnetwork_ip_ranges_to_nat=None, subnetworks=None, tcp_established_idle_timeout_sec=None, tcp_transitory_idle_timeout_sec=None, udp_idle_timeout_sec=None):
        """
        Get an existing RouterNat resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.
        
        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        
        The **log_config** object supports the following:
        
          * `enable` (`pulumi.Input[bool]`)
          * `filter` (`pulumi.Input[str]`)
        
        The **subnetworks** object supports the following:
        
          * `name` (`pulumi.Input[str]`)
          * `secondaryIpRangeNames` (`pulumi.Input[list]`)
          * `sourceIpRangesToNats` (`pulumi.Input[list]`)

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_router_nat.html.markdown.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()
        __props__["drain_nat_ips"] = drain_nat_ips
        __props__["icmp_idle_timeout_sec"] = icmp_idle_timeout_sec
        __props__["log_config"] = log_config
        __props__["min_ports_per_vm"] = min_ports_per_vm
        __props__["name"] = name
        __props__["nat_ip_allocate_option"] = nat_ip_allocate_option
        __props__["nat_ips"] = nat_ips
        __props__["project"] = project
        __props__["region"] = region
        __props__["router"] = router
        __props__["source_subnetwork_ip_ranges_to_nat"] = source_subnetwork_ip_ranges_to_nat
        __props__["subnetworks"] = subnetworks
        __props__["tcp_established_idle_timeout_sec"] = tcp_established_idle_timeout_sec
        __props__["tcp_transitory_idle_timeout_sec"] = tcp_transitory_idle_timeout_sec
        __props__["udp_idle_timeout_sec"] = udp_idle_timeout_sec
        return RouterNat(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

