#!/usr/bin/python
#
# Copyright 2018-2020 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.0.97
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from polyaxon_sdk.configuration import Configuration


class V1Project(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "uuid": "str",
        "user": "str",
        "user_email": "str",
        "owner": "str",
        "name": "str",
        "description": "str",
        "tags": "list[str]",
        "created_at": "datetime",
        "updated_at": "datetime",
        "is_public": "bool",
        "deleted": "bool",
        "bookmarked": "bool",
        "readme": "str",
        "settings": "V1ProjectSettings",
        "teams": "list[str]",
        "role": "str",
    }

    attribute_map = {
        "uuid": "uuid",
        "user": "user",
        "user_email": "user_email",
        "owner": "owner",
        "name": "name",
        "description": "description",
        "tags": "tags",
        "created_at": "created_at",
        "updated_at": "updated_at",
        "is_public": "is_public",
        "deleted": "deleted",
        "bookmarked": "bookmarked",
        "readme": "readme",
        "settings": "settings",
        "teams": "teams",
        "role": "role",
    }

    def __init__(
        self,
        uuid=None,
        user=None,
        user_email=None,
        owner=None,
        name=None,
        description=None,
        tags=None,
        created_at=None,
        updated_at=None,
        is_public=None,
        deleted=None,
        bookmarked=None,
        readme=None,
        settings=None,
        teams=None,
        role=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """V1Project - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._uuid = None
        self._user = None
        self._user_email = None
        self._owner = None
        self._name = None
        self._description = None
        self._tags = None
        self._created_at = None
        self._updated_at = None
        self._is_public = None
        self._deleted = None
        self._bookmarked = None
        self._readme = None
        self._settings = None
        self._teams = None
        self._role = None
        self.discriminator = None

        if uuid is not None:
            self.uuid = uuid
        if user is not None:
            self.user = user
        if user_email is not None:
            self.user_email = user_email
        if owner is not None:
            self.owner = owner
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if tags is not None:
            self.tags = tags
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if is_public is not None:
            self.is_public = is_public
        if deleted is not None:
            self.deleted = deleted
        if bookmarked is not None:
            self.bookmarked = bookmarked
        if readme is not None:
            self.readme = readme
        if settings is not None:
            self.settings = settings
        if teams is not None:
            self.teams = teams
        if role is not None:
            self.role = role

    @property
    def uuid(self):
        """Gets the uuid of this V1Project.  # noqa: E501


        :return: The uuid of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this V1Project.


        :param uuid: The uuid of this V1Project.  # noqa: E501
        :type: str
        """

        self._uuid = uuid

    @property
    def user(self):
        """Gets the user of this V1Project.  # noqa: E501


        :return: The user of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this V1Project.


        :param user: The user of this V1Project.  # noqa: E501
        :type: str
        """

        self._user = user

    @property
    def user_email(self):
        """Gets the user_email of this V1Project.  # noqa: E501


        :return: The user_email of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._user_email

    @user_email.setter
    def user_email(self, user_email):
        """Sets the user_email of this V1Project.


        :param user_email: The user_email of this V1Project.  # noqa: E501
        :type: str
        """

        self._user_email = user_email

    @property
    def owner(self):
        """Gets the owner of this V1Project.  # noqa: E501


        :return: The owner of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this V1Project.


        :param owner: The owner of this V1Project.  # noqa: E501
        :type: str
        """

        self._owner = owner

    @property
    def name(self):
        """Gets the name of this V1Project.  # noqa: E501


        :return: The name of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1Project.


        :param name: The name of this V1Project.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this V1Project.  # noqa: E501


        :return: The description of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V1Project.


        :param description: The description of this V1Project.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def tags(self):
        """Gets the tags of this V1Project.  # noqa: E501


        :return: The tags of this V1Project.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this V1Project.


        :param tags: The tags of this V1Project.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def created_at(self):
        """Gets the created_at of this V1Project.  # noqa: E501


        :return: The created_at of this V1Project.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this V1Project.


        :param created_at: The created_at of this V1Project.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this V1Project.  # noqa: E501


        :return: The updated_at of this V1Project.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this V1Project.


        :param updated_at: The updated_at of this V1Project.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def is_public(self):
        """Gets the is_public of this V1Project.  # noqa: E501


        :return: The is_public of this V1Project.  # noqa: E501
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """Sets the is_public of this V1Project.


        :param is_public: The is_public of this V1Project.  # noqa: E501
        :type: bool
        """

        self._is_public = is_public

    @property
    def deleted(self):
        """Gets the deleted of this V1Project.  # noqa: E501


        :return: The deleted of this V1Project.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this V1Project.


        :param deleted: The deleted of this V1Project.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def bookmarked(self):
        """Gets the bookmarked of this V1Project.  # noqa: E501


        :return: The bookmarked of this V1Project.  # noqa: E501
        :rtype: bool
        """
        return self._bookmarked

    @bookmarked.setter
    def bookmarked(self, bookmarked):
        """Sets the bookmarked of this V1Project.


        :param bookmarked: The bookmarked of this V1Project.  # noqa: E501
        :type: bool
        """

        self._bookmarked = bookmarked

    @property
    def readme(self):
        """Gets the readme of this V1Project.  # noqa: E501


        :return: The readme of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._readme

    @readme.setter
    def readme(self, readme):
        """Sets the readme of this V1Project.


        :param readme: The readme of this V1Project.  # noqa: E501
        :type: str
        """

        self._readme = readme

    @property
    def settings(self):
        """Gets the settings of this V1Project.  # noqa: E501


        :return: The settings of this V1Project.  # noqa: E501
        :rtype: V1ProjectSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this V1Project.


        :param settings: The settings of this V1Project.  # noqa: E501
        :type: V1ProjectSettings
        """

        self._settings = settings

    @property
    def teams(self):
        """Gets the teams of this V1Project.  # noqa: E501


        :return: The teams of this V1Project.  # noqa: E501
        :rtype: list[str]
        """
        return self._teams

    @teams.setter
    def teams(self, teams):
        """Sets the teams of this V1Project.


        :param teams: The teams of this V1Project.  # noqa: E501
        :type: list[str]
        """

        self._teams = teams

    @property
    def role(self):
        """Gets the role of this V1Project.  # noqa: E501


        :return: The role of this V1Project.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this V1Project.


        :param role: The role of this V1Project.  # noqa: E501
        :type: str
        """

        self._role = role

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1Project):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1Project):
            return True

        return self.to_dict() != other.to_dict()
