"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SQS dead letter queue destination configuration for a Lambda event source.
 *
 * @stability stable
 */
class SqsDlq {
    /**
     * @stability stable
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration for the DLQ.
     *
     * @stability stable
     */
    bind(_target, targetHandler) {
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDlq = SqsDlq;
_a = JSII_RTTI_SYMBOL_1;
SqsDlq[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SqsDlq", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEsTUFBTTs7OztJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0tBQzdDOzs7Ozs7SUFHTSxJQUFJLENBQUMsT0FBNEIsRUFBRSxhQUF3QjtRQUNoRSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRTVDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7S0FDSDs7QUFYSCx3QkFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBTcXNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYmluZChfdGFyZ2V0OiBJRXZlbnRTb3VyY2VNYXBwaW5nLCB0YXJnZXRIYW5kbGVyOiBJRnVuY3Rpb24pOiBEbHFEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyh0YXJnZXRIYW5kbGVyKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogdGhpcy5xdWV1ZS5xdWV1ZUFybixcbiAgICB9O1xuICB9XG59XG4iXX0=