"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
 * (experimental) A new IVS Playback Key Pair.
 *
 * @experimental
 */
class PlaybackKeyPair extends PlaybackKeyPairBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {});
        jsiiDeprecationWarnings._aws_cdk_aws_ivs_PlaybackKeyPairProps(props);
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs.PlaybackKeyPair", version: "1.138.2" };
//# sourceMappingURL=data:application/json;base64,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